/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorDay;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorHour;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorMinute;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorMonth;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorSecond;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorWeek;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorYear;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.parquet.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedDynPartitionTimeGranularityOptimizer
extends Transform {
    @Override
    public ParseContext transform(ParseContext pCtx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        String FS = FileSinkOperator.getOperatorName() + "%";
        opRules.put(new RuleRegExp("Sorted Dynamic Partition Time Granularity", FS), this.getSortDynPartProc(pCtx));
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, null);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pCtx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pCtx;
    }

    private NodeProcessor getSortDynPartProc(ParseContext pCtx) {
        return new SortedDynamicPartitionProc(pCtx);
    }

    class SortedDynamicPartitionProc
    implements NodeProcessor {
        private final Logger LOG = LoggerFactory.getLogger(SortedDynPartitionTimeGranularityOptimizer.class);
        protected ParseContext parseCtx;

        public SortedDynamicPartitionProc(ParseContext pCtx) {
            this.parseCtx = pCtx;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            FileSinkOperator fsOp = (FileSinkOperator)nd;
            String sh = ((FileSinkDesc)fsOp.getConf()).getTableInfo().getOutputFileFormatClassName();
            if (this.parseCtx.getQueryProperties().isQuery() || sh == null || !sh.equals("org.apache.hadoop.hive.druid.io.DruidOutputFormat")) {
                return null;
            }
            String segmentGranularity = null;
            Table table = ((FileSinkDesc)fsOp.getConf()).getTable();
            segmentGranularity = table != null ? table.getParameters().get("druid.segment.granularity") : this.parseCtx.getCreateTable().getTblProps().get("druid.segment.granularity");
            segmentGranularity = !Strings.isNullOrEmpty(segmentGranularity) ? segmentGranularity : HiveConf.getVar(this.parseCtx.getConf(), HiveConf.ConfVars.HIVE_DRUID_INDEXING_GRANULARITY);
            this.LOG.info("Sorted dynamic partitioning on time granularity optimization kicked in...");
            Operator<OperatorDesc> fsParent = fsOp.getParentOperators().get(0);
            fsParent = fsOp.getParentOperators().get(0);
            fsParent.getChildOperators().clear();
            Operator<? extends OperatorDesc> granularitySelOp = this.getGranularitySelOp(fsParent, segmentGranularity);
            ArrayList<ColumnInfo> parentCols = Lists.newArrayList(granularitySelOp.getSchema().getSignature());
            ArrayList<ExprNodeDesc> allRSCols = Lists.newArrayList();
            for (ColumnInfo ci : parentCols) {
                allRSCols.add(new ExprNodeColumnDesc(ci));
            }
            ArrayList<Integer> keyPositions = new ArrayList<Integer>();
            keyPositions.add(allRSCols.size() - 1);
            ArrayList<Integer> sortOrder = new ArrayList<Integer>(1);
            sortOrder.add(1);
            ArrayList<Integer> sortNullOrder = new ArrayList<Integer>(1);
            sortNullOrder.add(0);
            ReduceSinkOperator rsOp = this.getReduceSinkOp(keyPositions, sortOrder, sortNullOrder, allRSCols, granularitySelOp);
            ArrayList<ExprNodeDesc> descs = new ArrayList<ExprNodeDesc>(allRSCols.size());
            ArrayList<String> colNames = new ArrayList<String>();
            for (int i = 0; i < allRSCols.size(); ++i) {
                ExprNodeDesc col = allRSCols.get(i);
                String colName = col.getExprString();
                colNames.add(colName);
                if (keyPositions.contains(i)) {
                    descs.add(new ExprNodeColumnDesc(col.getTypeInfo(), Utilities.ReduceField.KEY.toString() + "." + colName, null, false));
                    continue;
                }
                descs.add(new ExprNodeColumnDesc(col.getTypeInfo(), Utilities.ReduceField.VALUE.toString() + "." + colName, null, false));
            }
            RowSchema selRS = new RowSchema(granularitySelOp.getSchema());
            SelectDesc selConf = new SelectDesc(descs, colNames);
            SelectOperator backtrackSelOp = (SelectOperator)OperatorFactory.getAndMakeChild(selConf, selRS, (Operator)rsOp, new Operator[0]);
            fsOp.getParentOperators().clear();
            fsOp.getParentOperators().add(backtrackSelOp);
            backtrackSelOp.getChildOperators().add(fsOp);
            ((FileSinkDesc)fsOp.getConf()).setDpSortState(FileSinkDesc.DPSortState.PARTITION_SORTED);
            ((FileSinkDesc)fsOp.getConf()).setPartitionCols(((ReduceSinkDesc)rsOp.getConf()).getPartitionCols());
            ColumnInfo ci = new ColumnInfo(granularitySelOp.getSchema().getSignature().get(granularitySelOp.getSchema().getSignature().size() - 1));
            fsOp.getSchema().getSignature().add(ci);
            this.LOG.info("Inserted " + granularitySelOp.getOperatorId() + ", " + rsOp.getOperatorId() + " and " + backtrackSelOp.getOperatorId() + " as parent of " + fsOp.getOperatorId() + " and child of " + fsParent.getOperatorId());
            this.parseCtx.setReduceSinkAddedBySortedDynPartition(true);
            return null;
        }

        private Operator<? extends OperatorDesc> getGranularitySelOp(Operator<? extends OperatorDesc> fsParent, String segmentGranularity) throws SemanticException {
            Class udfClass;
            String udfName;
            ArrayList<ColumnInfo> parentCols = Lists.newArrayList(fsParent.getSchema().getSignature());
            ArrayList<ExprNodeDesc> descs = Lists.newArrayList();
            ArrayList<String> colNames = Lists.newArrayList();
            int timestampPos = -1;
            for (int i = 0; i < parentCols.size(); ++i) {
                ColumnInfo ci = parentCols.get(i);
                ExprNodeColumnDesc columnDesc = new ExprNodeColumnDesc(ci);
                descs.add(columnDesc);
                colNames.add(columnDesc.getExprString());
                if (columnDesc.getTypeInfo().getCategory() != ObjectInspector.Category.PRIMITIVE || ((PrimitiveTypeInfo)columnDesc.getTypeInfo()).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP) continue;
                if (timestampPos != -1) {
                    throw new SemanticException("Multiple columns with timestamp type on query result; could not resolve which one is the timestamp column");
                }
                timestampPos = i;
            }
            if (timestampPos == -1) {
                throw new SemanticException("No column with timestamp type on query result; one column should be of timestamp type");
            }
            RowSchema selRS = new RowSchema(fsParent.getSchema());
            switch (segmentGranularity) {
                case "YEAR": {
                    udfName = "floor_year";
                    udfClass = UDFDateFloorYear.class;
                    break;
                }
                case "MONTH": {
                    udfName = "floor_month";
                    udfClass = UDFDateFloorMonth.class;
                    break;
                }
                case "WEEK": {
                    udfName = "floor_week";
                    udfClass = UDFDateFloorWeek.class;
                    break;
                }
                case "DAY": {
                    udfName = "floor_day";
                    udfClass = UDFDateFloorDay.class;
                    break;
                }
                case "HOUR": {
                    udfName = "floor_hour";
                    udfClass = UDFDateFloorHour.class;
                    break;
                }
                case "MINUTE": {
                    udfName = "floor_minute";
                    udfClass = UDFDateFloorMinute.class;
                    break;
                }
                case "SECOND": {
                    udfName = "floor_second";
                    udfClass = UDFDateFloorSecond.class;
                    break;
                }
                default: {
                    throw new SemanticException("Granularity for Druid segment not recognized");
                }
            }
            ExprNodeColumnDesc expr = new ExprNodeColumnDesc(parentCols.get(timestampPos));
            descs.add(new ExprNodeGenericFuncDesc(TypeInfoFactory.timestampTypeInfo, (GenericUDF)new GenericUDFBridge(udfName, false, udfClass.getName()), Lists.newArrayList(expr)));
            colNames.add("__time_granularity");
            ColumnInfo ci = new ColumnInfo("__time_granularity", TypeInfoFactory.timestampTypeInfo, selRS.getSignature().get(0).getTabAlias(), false, false);
            selRS.getSignature().add(ci);
            SelectDesc selConf = new SelectDesc(descs, colNames);
            SelectOperator selOp = (SelectOperator)OperatorFactory.getAndMakeChild(selConf, selRS, fsParent, new Operator[0]);
            return selOp;
        }

        private ReduceSinkOperator getReduceSinkOp(List<Integer> keyPositions, List<Integer> sortOrder, List<Integer> sortNullOrder, ArrayList<ExprNodeDesc> allCols, Operator<? extends OperatorDesc> parent) throws SemanticException {
            ArrayList<ExprNodeDesc> keyCols = Lists.newArrayList();
            for (Integer idx : keyPositions) {
                keyCols.add(allCols.get(idx).clone());
            }
            ArrayList<ExprNodeDesc> valCols = Lists.newArrayList();
            for (int i = 0; i < allCols.size(); ++i) {
                if (keyPositions.contains(i)) continue;
                valCols.add(allCols.get(i).clone());
            }
            ArrayList<ExprNodeDesc> partCols = Lists.newArrayList();
            for (Integer idx : keyPositions) {
                partCols.add(allCols.get(idx).clone());
            }
            HashMap<String, ExprNodeDesc> colExprMap = Maps.newHashMap();
            HashMap<String, String> nameMapping = new HashMap<String, String>();
            ArrayList<String> keyColNames = Lists.newArrayList();
            for (ExprNodeDesc exprNodeDesc : keyCols) {
                String keyColName = exprNodeDesc.getExprString();
                keyColNames.add(keyColName);
                colExprMap.put((Object)((Object)Utilities.ReduceField.KEY) + "." + keyColName, exprNodeDesc);
                nameMapping.put(keyColName, (Object)((Object)Utilities.ReduceField.KEY) + "." + keyColName);
            }
            ArrayList<String> valColNames = Lists.newArrayList();
            for (ExprNodeDesc valCol : valCols) {
                String colName = valCol.getExprString();
                valColNames.add(colName);
                colExprMap.put((Object)((Object)Utilities.ReduceField.VALUE) + "." + colName, valCol);
                nameMapping.put(colName, (Object)((Object)Utilities.ReduceField.VALUE) + "." + colName);
            }
            String string = StringUtils.repeat("+", sortOrder.size());
            String nullOrderStr = StringUtils.repeat("a", sortNullOrder.size());
            List<FieldSchema> fields = PlanUtils.getFieldSchemasFromColumnList(keyCols, keyColNames, 0, "");
            TableDesc keyTable = PlanUtils.getReduceKeyTableDesc(fields, string, nullOrderStr);
            List<FieldSchema> valFields = PlanUtils.getFieldSchemasFromColumnList(valCols, valColNames, 0, "");
            TableDesc valueTable = PlanUtils.getReduceValueTableDesc(valFields);
            ArrayList<List<Integer>> distinctColumnIndices = Lists.newArrayList();
            ReduceSinkDesc rsConf = new ReduceSinkDesc(keyCols, keyCols.size(), valCols, keyColNames, distinctColumnIndices, valColNames, -1, partCols, -1, keyTable, valueTable);
            ArrayList<ColumnInfo> signature = new ArrayList<ColumnInfo>();
            for (int index = 0; index < parent.getSchema().getSignature().size(); ++index) {
                ColumnInfo colInfo = new ColumnInfo(parent.getSchema().getSignature().get(index));
                colInfo.setInternalName((String)nameMapping.get(colInfo.getInternalName()));
                signature.add(colInfo);
            }
            ReduceSinkOperator op = (ReduceSinkOperator)OperatorFactory.getAndMakeChild(rsConf, new RowSchema(signature), parent, new Operator[0]);
            op.setColumnExprMap(colExprMap);
            return op;
        }
    }
}

