/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.plan.HiveOperation;

public class QueryState {
    private final HiveConf queryConf;
    private HiveOperation commandType;

    public QueryState(HiveConf conf) {
        this(conf, null, false);
    }

    public QueryState(HiveConf conf, Map<String, String> confOverlay, boolean runAsync) {
        this.queryConf = this.createConf(conf, confOverlay, runAsync);
    }

    private HiveConf createConf(HiveConf conf, Map<String, String> confOverlay, boolean runAsync) {
        if (confOverlay != null && !confOverlay.isEmpty()) {
            conf = conf == null ? new HiveConf() : new HiveConf(conf);
            for (Map.Entry<String, String> confEntry : confOverlay.entrySet()) {
                try {
                    conf.verifyAndSet(confEntry.getKey(), confEntry.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Error applying statement specific settings", e);
                }
            }
        } else if (runAsync) {
            HiveConf hiveConf = conf = conf == null ? new HiveConf() : new HiveConf(conf);
        }
        if (conf == null) {
            conf = new HiveConf();
        }
        conf.setVar(HiveConf.ConfVars.HIVEQUERYID, QueryPlan.makeQueryId());
        return conf;
    }

    public String getQueryId() {
        return this.queryConf.getVar(HiveConf.ConfVars.HIVEQUERYID);
    }

    public String getQueryString() {
        return this.queryConf.getQueryString();
    }

    public String getCommandType() {
        if (this.commandType == null) {
            return null;
        }
        return this.commandType.getOperationName();
    }

    public HiveOperation getHiveOperation() {
        return this.commandType;
    }

    public void setCommandType(HiveOperation commandType) {
        this.commandType = commandType;
    }

    public HiveConf getConf() {
        return this.queryConf;
    }
}

