/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;

public class LlapTokenIdentifier
extends AbstractDelegationTokenIdentifier {
    private static final String KIND = "LLAP_TOKEN";
    public static final Text KIND_NAME = new Text("LLAP_TOKEN");
    private String clusterId;
    private String appId;
    private boolean isSigningRequired;

    public LlapTokenIdentifier() {
    }

    public LlapTokenIdentifier(Text owner, Text renewer, Text realUser, String clusterId, String appId, boolean isSigningRequired) {
        super(owner, renewer, realUser);
        Preconditions.checkNotNull(clusterId);
        this.clusterId = clusterId;
        this.appId = appId == null ? "" : appId;
        this.isSigningRequired = isSigningRequired;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.clusterId);
        out.writeUTF(this.appId);
        out.writeBoolean(this.isSigningRequired);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.clusterId = in.readUTF();
        Preconditions.checkNotNull(this.clusterId);
        this.appId = in.readUTF();
        this.isSigningRequired = in.readBoolean();
        this.appId = this.appId == null ? "" : this.appId;
    }

    public Text getKind() {
        return KIND_NAME;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public boolean isSigningRequired() {
        return this.isSigningRequired;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 * super.hashCode() + (StringUtils.isBlank(this.appId) ? 0 : this.appId.hashCode());
        result = 31 * result + (this.isSigningRequired ? 1231 : 1237);
        return 31 * result + (this.clusterId == null ? 0 : this.clusterId.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LlapTokenIdentifier) || !super.equals(obj)) {
            return false;
        }
        LlapTokenIdentifier other = (LlapTokenIdentifier)((Object)obj);
        return this.isSigningRequired == other.isSigningRequired && (StringUtils.isBlank(this.appId) ? StringUtils.isBlank(other.appId) : this.appId.equals(other.appId)) && (this.clusterId == null ? other.clusterId == null : this.clusterId.equals(other.clusterId));
    }

    public String toString() {
        return "LLAP_TOKEN; " + super.toString() + ", cluster " + this.clusterId + ", app ID " + this.appId + ", signing " + this.isSigningRequired;
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends Token.TrivialRenewer {
        protected Text getKind() {
            return KIND_NAME;
        }
    }
}

