/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.util.Util;

public class SqlExtractFunction
extends SqlFunction {
    public SqlExtractFunction() {
        super("EXTRACT", SqlKind.EXTRACT, ReturnTypes.BIGINT_NULLABLE, null, OperandTypes.INTERVALINTERVAL_INTERVALDATETIME, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        Util.discard(operandsCount);
        return "{0}({1} FROM {2})";
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.sep("FROM");
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        writer.endFunCall(frame);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        switch ((TimeUnitRange)((Object)call.getOperandLiteralValue(0))) {
            case YEAR: {
                return call.getOperandMonotonicity(1).unstrict();
            }
        }
        return SqlMonotonicity.NOT_MONOTONIC;
    }
}

