/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableIntList;

public class RelCollations {
    public static final RelCollation EMPTY = RelCollationTraitDef.INSTANCE.canonize(new RelCollationImpl(ImmutableList.of()));
    @Deprecated
    public static final RelCollation PRESERVE = RelCollationTraitDef.INSTANCE.canonize(new RelCollationImpl((ImmutableList)ImmutableList.of(new RelFieldCollation(-1))){

        @Override
        public String toString() {
            return "PRESERVE";
        }
    });

    private RelCollations() {
    }

    public static RelCollation of(RelFieldCollation ... fieldCollations) {
        return new RelCollationImpl(ImmutableList.copyOf(fieldCollations));
    }

    public static RelCollation of(List<RelFieldCollation> fieldCollations) {
        return new RelCollationImpl(ImmutableList.copyOf(fieldCollations));
    }

    public static RelCollation of(int fieldIndex) {
        return RelCollations.of(new RelFieldCollation(fieldIndex));
    }

    public static List<RelCollation> createSingleton(int fieldIndex) {
        return ImmutableList.of(RelCollations.of(fieldIndex));
    }

    public static boolean isValid(RelDataType rowType, List<RelCollation> collationList, boolean fail) {
        int fieldCount = rowType.getFieldCount();
        for (RelCollation collation : collationList) {
            for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
                int index = fieldCollation.getFieldIndex();
                if (index >= 0 && index < fieldCount) continue;
                assert (!fail);
                return false;
            }
        }
        return true;
    }

    public static boolean equal(List<RelCollation> collationList1, List<RelCollation> collationList2) {
        return collationList1.equals(collationList2);
    }

    public static List<Integer> ordinals(RelCollation collation) {
        return Lists.transform(collation.getFieldCollations(), new Function<RelFieldCollation, Integer>(){

            @Override
            public Integer apply(RelFieldCollation input) {
                return input.getFieldIndex();
            }
        });
    }

    public static boolean contains(RelCollation collation, Iterable<Integer> keys) {
        int n = collation.getFieldCollations().size();
        Iterator<Integer> iterator = keys.iterator();
        for (int i = 0; i < n; ++i) {
            RelFieldCollation fieldCollation = collation.getFieldCollations().get(i);
            if (!iterator.hasNext()) {
                return true;
            }
            if (fieldCollation.getFieldIndex() == iterator.next().intValue()) continue;
            return false;
        }
        return !iterator.hasNext();
    }

    public static boolean contains(List<RelCollation> collations, ImmutableIntList keys) {
        for (RelCollation collation : collations) {
            if (!RelCollations.contains(collation, (Iterable<Integer>)keys)) continue;
            return true;
        }
        return false;
    }

    public static RelCollation shift(RelCollation collation, int offset) {
        if (offset == 0) {
            return collation;
        }
        ImmutableList.Builder fieldCollations = ImmutableList.builder();
        for (RelFieldCollation fc : collation.getFieldCollations()) {
            fieldCollations.add(fc.shift(offset));
        }
        return new RelCollationImpl((ImmutableList<RelFieldCollation>)fieldCollations.build());
    }
}

