/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.prepare;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.runtime.Bindable;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.runtime.Typed;
import org.apache.calcite.schema.impl.StarTable;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.TryThreadLocal;
import org.apache.calcite.util.trace.CalciteTimingTracer;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

public abstract class Prepare {
    protected static final Logger LOGGER = CalciteTrace.getStatementTracer();
    protected final CalcitePrepare.Context context;
    protected final CatalogReader catalogReader;
    protected String queryString = null;
    protected final Convention resultConvention;
    protected CalciteTimingTracer timingTracer;
    protected List<List<String>> fieldOrigins;
    protected RelDataType parameterRowType;
    public static final TryThreadLocal<Boolean> THREAD_TRIM = TryThreadLocal.of(false);
    public static final TryThreadLocal<Boolean> THREAD_EXPAND = TryThreadLocal.of(false);

    public Prepare(CalcitePrepare.Context context, CatalogReader catalogReader, Convention resultConvention) {
        assert (context != null);
        this.context = context;
        this.catalogReader = catalogReader;
        this.resultConvention = resultConvention;
    }

    protected abstract PreparedResult createPreparedExplanation(RelDataType var1, RelDataType var2, RelRoot var3, boolean var4, SqlExplainLevel var5);

    protected RelRoot optimize(RelRoot root, List<Materialization> materializations, List<CalciteSchema.LatticeEntry> lattices) {
        RelOptPlanner planner = root.rel.getCluster().getPlanner();
        planner.setRoot(root.rel);
        RelTraitSet desiredTraits = this.getDesiredRootTraitSet(root);
        Program program = this.getProgram();
        DataContext dataContext = this.context.getDataContext();
        planner.setExecutor(new RexExecutorImpl(dataContext));
        for (Materialization materialization : materializations) {
            planner.addMaterialization(new RelOptMaterialization(materialization.tableRel, materialization.queryRel, materialization.starRelOptTable));
        }
        for (CalciteSchema.LatticeEntry lattice : lattices) {
            CalciteSchema.TableEntry starTable = lattice.getStarTable();
            JavaTypeFactory typeFactory = this.context.getTypeFactory();
            RelOptTableImpl starRelOptTable = RelOptTableImpl.create((RelOptSchema)this.catalogReader, starTable.getTable().getRowType(typeFactory), starTable, null);
            planner.addLattice(new RelOptLattice(lattice.getLattice(), starRelOptTable));
        }
        RelNode rootRel4 = program.run(planner, root.rel, desiredTraits);
        LOGGER.debug("Plan after physical tweaks: {}", (Object)RelOptUtil.toString(rootRel4, SqlExplainLevel.ALL_ATTRIBUTES));
        return root.withRel(rootRel4);
    }

    private Program getProgram() {
        ImmutableList materializations = ImmutableList.of();
        Holder<Object> holder = Holder.of(null);
        Hook.PROGRAM.run(Pair.of(materializations, holder));
        if (holder.get() != null) {
            return holder.get();
        }
        return Programs.standard();
    }

    protected RelTraitSet getDesiredRootTraitSet(RelRoot root) {
        return root.rel.getTraitSet().replace(this.resultConvention).replace(root.collation).simplify();
    }

    protected abstract PreparedResult implement(RelRoot var1);

    public PreparedResult prepareSql(SqlNode sqlQuery, Class runtimeContextClass, SqlValidator validator, boolean needsValidation) {
        return this.prepareSql(sqlQuery, sqlQuery, runtimeContextClass, validator, needsValidation);
    }

    public PreparedResult prepareSql(SqlNode sqlQuery, SqlNode sqlNodeOriginal, Class runtimeContextClass, SqlValidator validator, boolean needsValidation) {
        SqlExplainLevel detailLevel;
        boolean explainAsXml;
        SqlExplain.Depth explainDepth;
        this.queryString = sqlQuery.toString();
        this.init(runtimeContextClass);
        SqlToRelConverter.ConfigBuilder builder = SqlToRelConverter.configBuilder().withTrimUnusedFields(true).withExpand((Boolean)THREAD_EXPAND.get()).withExplain(sqlQuery.getKind() == SqlKind.EXPLAIN);
        SqlToRelConverter sqlToRelConverter = this.getSqlToRelConverter(validator, this.catalogReader, builder.build());
        SqlExplain sqlExplain = null;
        if (sqlQuery.getKind() == SqlKind.EXPLAIN) {
            sqlExplain = (SqlExplain)sqlQuery;
            sqlQuery = sqlExplain.getExplicandum();
            sqlToRelConverter.setDynamicParamCountInExplain(sqlExplain.getDynamicParamCount());
        }
        RelRoot root = sqlToRelConverter.convertQuery(sqlQuery, needsValidation, true);
        Hook.CONVERTED.run(root.rel);
        if (this.timingTracer != null) {
            this.timingTracer.traceTime("end sql2rel");
        }
        RelDataType resultType = validator.getValidatedNodeType(sqlQuery);
        this.fieldOrigins = validator.getFieldOrigins(sqlQuery);
        assert (this.fieldOrigins.size() == resultType.getFieldCount());
        this.parameterRowType = validator.getParameterRowType(sqlQuery);
        if (sqlExplain != null) {
            explainDepth = sqlExplain.getDepth();
            explainAsXml = sqlExplain.isXml();
            detailLevel = sqlExplain.getDetailLevel();
            switch (explainDepth) {
                case TYPE: {
                    return this.createPreparedExplanation(resultType, this.parameterRowType, null, explainAsXml, detailLevel);
                }
                case LOGICAL: {
                    return this.createPreparedExplanation(null, this.parameterRowType, root, explainAsXml, detailLevel);
                }
            }
        }
        root = root.withRel(this.flattenTypes(root.rel, true));
        if (this.context.config().forceDecorrelate()) {
            root = root.withRel(this.decorrelate(sqlToRelConverter, sqlQuery, root.rel));
        }
        root = this.trimUnusedFields(root);
        Hook.TRIMMED.run(root.rel);
        if (sqlExplain != null) {
            explainDepth = sqlExplain.getDepth();
            explainAsXml = sqlExplain.isXml();
            detailLevel = sqlExplain.getDetailLevel();
            switch (explainDepth) {
                default: 
            }
            root = this.optimize(root, this.getMaterializations(), this.getLattices());
            return this.createPreparedExplanation(null, this.parameterRowType, root, explainAsXml, detailLevel);
        }
        root = this.optimize(root, this.getMaterializations(), this.getLattices());
        if (this.timingTracer != null) {
            this.timingTracer.traceTime("end optimization");
        }
        if (!root.kind.belongsTo(SqlKind.DML)) {
            root = root.withKind(sqlNodeOriginal.getKind());
        }
        return this.implement(root);
    }

    protected TableModify.Operation mapTableModOp(boolean isDml, SqlKind sqlKind) {
        if (!isDml) {
            return null;
        }
        switch (sqlKind) {
            case INSERT: {
                return TableModify.Operation.INSERT;
            }
            case DELETE: {
                return TableModify.Operation.DELETE;
            }
            case MERGE: {
                return TableModify.Operation.MERGE;
            }
            case UPDATE: {
                return TableModify.Operation.UPDATE;
            }
        }
        return null;
    }

    protected abstract SqlToRelConverter getSqlToRelConverter(SqlValidator var1, CatalogReader var2, SqlToRelConverter.Config var3);

    public abstract RelNode flattenTypes(RelNode var1, boolean var2);

    protected abstract RelNode decorrelate(SqlToRelConverter var1, SqlNode var2, RelNode var3);

    protected abstract List<Materialization> getMaterializations();

    protected abstract List<CalciteSchema.LatticeEntry> getLattices();

    protected RelRoot trimUnusedFields(RelRoot root) {
        SqlToRelConverter.Config config = SqlToRelConverter.configBuilder().withTrimUnusedFields(this.shouldTrim(root.rel)).withExpand((Boolean)THREAD_EXPAND.get()).build();
        SqlToRelConverter converter = this.getSqlToRelConverter(this.getSqlValidator(), this.catalogReader, config);
        boolean ordered = !root.collation.getFieldCollations().isEmpty();
        boolean dml = SqlKind.DML.contains((Object)root.kind);
        return root.withRel(converter.trimUnusedFields(dml || ordered, root.rel));
    }

    private boolean shouldTrim(RelNode rootRel) {
        return (Boolean)THREAD_TRIM.get() != false || RelOptUtil.countJoins(rootRel) < 2;
    }

    public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath, List<String> viewPath) {
        throw new UnsupportedOperationException();
    }

    protected abstract void init(Class var1);

    protected abstract SqlValidator getSqlValidator();

    public static class Materialization {
        final CalciteSchema.TableEntry materializedTable;
        final String sql;
        final List<String> viewSchemaPath;
        RelNode tableRel;
        RelNode queryRel;
        private RelOptTable starRelOptTable;

        public Materialization(CalciteSchema.TableEntry materializedTable, String sql, List<String> viewSchemaPath) {
            assert (materializedTable != null);
            assert (sql != null);
            this.materializedTable = materializedTable;
            this.sql = sql;
            this.viewSchemaPath = viewSchemaPath;
        }

        public void materialize(RelNode queryRel, RelOptTable starRelOptTable) {
            this.queryRel = queryRel;
            this.starRelOptTable = starRelOptTable;
            assert (starRelOptTable.unwrap(StarTable.class) != null);
        }
    }

    public static abstract class PreparedResultImpl
    implements PreparedResult,
    Typed {
        protected final RelNode rootRel;
        protected final RelDataType parameterRowType;
        protected final RelDataType rowType;
        protected final boolean isDml;
        protected final TableModify.Operation tableModOp;
        protected final List<List<String>> fieldOrigins;
        protected final List<RelCollation> collations;

        public PreparedResultImpl(RelDataType rowType, RelDataType parameterRowType, List<List<String>> fieldOrigins, List<RelCollation> collations, RelNode rootRel, TableModify.Operation tableModOp, boolean isDml) {
            this.rowType = Preconditions.checkNotNull(rowType);
            this.parameterRowType = Preconditions.checkNotNull(parameterRowType);
            this.fieldOrigins = Preconditions.checkNotNull(fieldOrigins);
            this.collations = ImmutableList.copyOf(collations);
            this.rootRel = Preconditions.checkNotNull(rootRel);
            this.tableModOp = tableModOp;
            this.isDml = isDml;
        }

        @Override
        public boolean isDml() {
            return this.isDml;
        }

        @Override
        public TableModify.Operation getTableModOp() {
            return this.tableModOp;
        }

        @Override
        public List<List<String>> getFieldOrigins() {
            return this.fieldOrigins;
        }

        @Override
        public RelDataType getParameterRowType() {
            return this.parameterRowType;
        }

        public RelDataType getPhysicalRowType() {
            return this.rowType;
        }

        @Override
        public abstract Type getElementType();

        public RelNode getRootRel() {
            return this.rootRel;
        }

        @Override
        public abstract Bindable getBindable();
    }

    public static interface PreparedResult {
        public String getCode();

        public boolean isDml();

        public TableModify.Operation getTableModOp();

        public List<List<String>> getFieldOrigins();

        public RelDataType getParameterRowType();

        public Bindable getBindable();
    }

    public static abstract class PreparedExplain
    implements PreparedResult {
        private final RelDataType rowType;
        private final RelDataType parameterRowType;
        private final RelRoot root;
        private final boolean asXml;
        private final SqlExplainLevel detailLevel;

        public PreparedExplain(RelDataType rowType, RelDataType parameterRowType, RelRoot root, boolean asXml, SqlExplainLevel detailLevel) {
            this.rowType = rowType;
            this.parameterRowType = parameterRowType;
            this.root = root;
            this.asXml = asXml;
            this.detailLevel = detailLevel;
        }

        @Override
        public String getCode() {
            if (this.root == null) {
                return RelOptUtil.dumpType(this.rowType);
            }
            return RelOptUtil.dumpPlan("", this.root.rel, this.asXml, this.detailLevel);
        }

        @Override
        public RelDataType getParameterRowType() {
            return this.parameterRowType;
        }

        @Override
        public boolean isDml() {
            return false;
        }

        @Override
        public TableModify.Operation getTableModOp() {
            return null;
        }

        @Override
        public List<List<String>> getFieldOrigins() {
            return Collections.singletonList(Collections.nCopies(4, null));
        }

        @Override
        public abstract Bindable getBindable();
    }

    public static interface PreparingTable
    extends RelOptTable,
    SqlValidatorTable {
    }

    public static interface CatalogReader
    extends RelOptSchema,
    SqlValidatorCatalogReader,
    SqlOperatorTable {
        public static final ThreadLocal<CatalogReader> THREAD_LOCAL = new ThreadLocal();

        @Override
        public PreparingTable getTableForMember(List<String> var1);

        public CatalogReader withSchemaPath(List<String> var1);

        @Override
        public PreparingTable getTable(List<String> var1);
    }
}

