/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.hive.ql.io;

import java.io.InputStream;

import org.apache.hadoop.io.compress.*;
/**
 *
 * SchemaAwareCompressionInputStream adds the ability to inform the compression
 * stream what column is being read.
 *
 */
public abstract class SchemaAwareCompressionInputStream extends CompressionInputStream {

  protected SchemaAwareCompressionInputStream(InputStream in) throws java.io.IOException {
    super(in);
  }

  /**
   * The column being read
   *
   * @param columnIndex the index of the column. Use -1 for non-column data
   */
  public abstract void setColumnIndex(int columnIndex);
}
