/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFWeekOfYearDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFWeekOfYearString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFWeekOfYearTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="yearweek", value="_FUNC_(date) - Returns the week of the year of the given date. A week is considered to start on a Monday and week 1 is the first week with >3 days.", extended="Examples:\n  > SELECT _FUNC_('2008-02-20') FROM src LIMIT 1;\n  8\n  > SELECT _FUNC_('1980-12-31 12:59:59') FROM src LIMIT 1;\n  1")
@VectorizedExpressions(value={VectorUDFWeekOfYearDate.class, VectorUDFWeekOfYearString.class, VectorUDFWeekOfYearTimestamp.class})
@NDV(maxNdv=52L)
public class UDFWeekOfYear
extends UDF {
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private final Calendar calendar = Calendar.getInstance();
    private final IntWritable result = new IntWritable();

    public UDFWeekOfYear() {
        this.calendar.setFirstDayOfWeek(2);
        this.calendar.setMinimalDaysInFirstWeek(4);
    }

    public IntWritable evaluate(Text dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            Date date = this.formatter.parse(dateString.toString());
            this.calendar.setTime(date);
            this.result.set(this.calendar.get(3));
            return this.result;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public IntWritable evaluate(DateWritable d) {
        if (d == null) {
            return null;
        }
        this.calendar.setTime(d.get());
        this.result.set(this.calendar.get(3));
        return this.result;
    }

    public IntWritable evaluate(TimestampWritable t) {
        if (t == null) {
            return null;
        }
        this.calendar.setTime(t.getTimestamp());
        this.result.set(this.calendar.get(3));
        return this.result;
    }
}

