/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.txn.CompactionTxnHandler;
import org.apache.hadoop.hive.ql.txn.compactor.HouseKeeperServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcidCompactionHistoryService
extends HouseKeeperServiceBase {
    private static final Logger LOG = LoggerFactory.getLogger(AcidCompactionHistoryService.class);

    @Override
    protected long getStartDelayMs() {
        return 0L;
    }

    @Override
    protected long getIntervalMs() {
        return this.hiveConf.getTimeVar(HiveConf.ConfVars.COMPACTOR_HISTORY_REAPER_INTERVAL, TimeUnit.MILLISECONDS);
    }

    @Override
    protected Runnable getScheduedAction(HiveConf hiveConf, AtomicInteger isAliveCounter) {
        return new ObsoleteEntryReaper(hiveConf, isAliveCounter);
    }

    @Override
    public String getServiceDescription() {
        return "Removes obsolete entries from Compaction History";
    }

    private static final class ObsoleteEntryReaper
    implements Runnable {
        private final CompactionTxnHandler txnHandler;
        private final AtomicInteger isAliveCounter;

        private ObsoleteEntryReaper(HiveConf hiveConf, AtomicInteger isAliveCounter) {
            this.txnHandler = new CompactionTxnHandler(hiveConf);
            this.isAliveCounter = isAliveCounter;
        }

        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                this.txnHandler.purgeCompactionHistory();
                int count = this.isAliveCounter.incrementAndGet();
                LOG.info("History reaper reaper ran for " + (System.currentTimeMillis() - startTime) / 1000L + "seconds.  isAliveCounter=" + count);
            }
            catch (Throwable t) {
                LOG.error("Serious error in {}", new Object[]{Thread.currentThread().getName(), ": {}" + t.getMessage(), t});
            }
        }
    }
}

