/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import java.util.List;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Apache Argus (incubating)"})
@InterfaceStability.Evolving
public final class QueryContext {
    private final String commandString;
    private final List<String> forwardedAddresses;

    private QueryContext(Builder builder) {
        this.commandString = builder.commandString;
        this.forwardedAddresses = builder.forwardedAddresses;
    }

    public String getCommandString() {
        return this.commandString;
    }

    public List<String> getForwardedAddresses() {
        return this.forwardedAddresses;
    }

    public String toString() {
        return "QueryContext [commandString=" + this.commandString + ", forwardedAddresses=" + this.forwardedAddresses + "]";
    }

    public static class Builder {
        private String commandString;
        private List<String> forwardedAddresses;

        public String getCommandString() {
            return this.commandString;
        }

        public void setCommandString(String commandString) {
            this.commandString = commandString;
        }

        public List<String> getForwardedAddresses() {
            return this.forwardedAddresses;
        }

        public void setForwardedAddresses(List<String> forwardedAddresses) {
            this.forwardedAddresses = forwardedAddresses;
        }

        public QueryContext build() {
            return new QueryContext(this);
        }
    }
}

