/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.List;
import org.antlr.runtime.TokenRewriteStream;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.MaskAndFilterInfo;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UnparseTranslator;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.QueryContext;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMask {
    protected final Logger LOG = LoggerFactory.getLogger(TableMask.class);
    HiveAuthorizer authorizer;
    private UnparseTranslator translator;
    private boolean enable;
    private boolean needsRewrite;
    private QueryContext queryContext;

    public TableMask(SemanticAnalyzer analyzer, HiveConf conf) throws SemanticException {
        try {
            this.authorizer = SessionState.get().getAuthorizerV2();
            String cmdString = analyzer.ctx.getCmd();
            QueryContext.Builder ctxBuilder = new QueryContext.Builder();
            ctxBuilder.setCommandString(cmdString);
            this.queryContext = ctxBuilder.build();
            if (this.authorizer != null && this.needTransform()) {
                this.enable = true;
                this.translator = new UnparseTranslator(conf);
                this.translator.enable();
            }
        }
        catch (Exception e) {
            this.LOG.warn("Failed to initialize masking policy");
            throw new SemanticException(e);
        }
    }

    public List<HivePrivilegeObject> applyRowFilterAndColumnMasking(List<HivePrivilegeObject> privObjs) throws SemanticException {
        return this.authorizer.applyRowFilterAndColumnMasking(this.queryContext, privObjs);
    }

    public boolean isEnabled() throws SemanticException {
        return this.enable;
    }

    public boolean needTransform() throws SemanticException {
        return this.authorizer.needTransform();
    }

    public String create(HivePrivilegeObject privObject, MaskAndFilterInfo maskAndFilterInfo) throws SemanticException {
        StringBuilder sb = new StringBuilder();
        sb.append("(SELECT ");
        boolean firstOne = true;
        List exprs = privObject.getCellValueTransformers();
        if (exprs != null) {
            if (exprs.size() != privObject.getColumns().size()) {
                throw new SemanticException("Expect " + privObject.getColumns().size() + " columns in " + privObject.getObjectName() + ", but only find " + exprs.size());
            }
            List<String> colTypes = maskAndFilterInfo.colTypes;
            for (int index = 0; index < exprs.size(); ++index) {
                String expr = (String)exprs.get(index);
                if (expr == null) {
                    throw new SemanticException("Expect string type CellValueTransformer in " + privObject.getObjectName() + ", but only find null");
                }
                if (!firstOne) {
                    sb.append(", ");
                } else {
                    firstOne = false;
                }
                String colName = privObject.getColumns().get(index);
                if (!expr.equals(colName)) {
                    sb.append("CAST(" + expr + " AS " + colTypes.get(index) + ") AS " + colName);
                    continue;
                }
                sb.append(expr);
            }
        } else {
            for (int index = 0; index < privObject.getColumns().size(); ++index) {
                String expr = privObject.getColumns().get(index);
                if (!firstOne) {
                    sb.append(", ");
                } else {
                    firstOne = false;
                }
                sb.append(expr);
            }
        }
        sb.append(" FROM " + privObject.getObjectName());
        sb.append(" " + maskAndFilterInfo.additionalTabInfo);
        String filter = privObject.getRowFilterExpression();
        if (filter != null) {
            sb.append(" WHERE " + filter);
        }
        sb.append(")" + maskAndFilterInfo.alias);
        this.LOG.debug("TableMask creates `" + sb.toString() + "`");
        return sb.toString();
    }

    void addTableMasking(ASTNode node, String replacementText) throws SemanticException {
        this.translator.addTranslation(node, replacementText);
    }

    void applyTableMasking(TokenRewriteStream tokenRewriteStream) throws SemanticException {
        this.translator.applyTranslations(tokenRewriteStream);
    }

    public boolean needsRewrite() {
        return this.needsRewrite;
    }

    public void setNeedsRewrite(boolean needsRewrite) {
        this.needsRewrite = needsRewrite;
    }
}

