/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSQRewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(HiveConf conf, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(tree.getType()));
        switch (tree.getType()) {
            case 709: {
                return new ExplainSemanticAnalyzer(conf);
            }
            case 710: {
                return new ExplainSQRewriteSemanticAnalyzer(conf);
            }
            case 768: {
                return new LoadSemanticAnalyzer(conf);
            }
            case 712: {
                return new ExportSemanticAnalyzer(conf);
            }
            case 737: {
                return new ImportSemanticAnalyzer(conf);
            }
            case 625: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 626: 
                    case 627: 
                    case 628: 
                    case 633: 
                    case 634: 
                    case 635: 
                    case 639: 
                    case 640: 
                    case 641: 
                    case 642: 
                    case 644: 
                    case 647: 
                    case 649: 
                    case 650: {
                        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(conf);
                    }
                }
                HiveOperation commandType = tablePartitionCommandType.get(child.getType())[tree.getChildCount() > 2 ? 1 : 0];
                SemanticAnalyzerFactory.setSessionCommandType(commandType);
                return new DDLSemanticAnalyzer(conf);
            }
            case 652: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 653: 
                    case 654: 
                    case 655: 
                    case 656: 
                    case 657: {
                        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(conf);
                    }
                }
                assert (child.getType() == 824);
                SemanticAnalyzerFactory.setSessionCommandType(HiveOperation.ALTERVIEW_AS);
                return new SemanticAnalyzer(conf);
            }
            case 621: 
            case 622: 
            case 623: 
            case 624: 
            case 631: 
            case 671: 
            case 673: 
            case 676: 
            case 693: 
            case 694: 
            case 695: 
            case 701: 
            case 703: 
            case 705: 
            case 706: 
            case 707: 
            case 722: 
            case 724: 
            case 769: 
            case 770: 
            case 774: 
            case 834: 
            case 835: 
            case 850: 
            case 851: 
            case 852: 
            case 853: 
            case 854: 
            case 855: 
            case 856: 
            case 857: 
            case 858: 
            case 859: 
            case 860: 
            case 861: 
            case 862: 
            case 863: 
            case 864: 
            case 865: 
            case 866: 
            case 867: 
            case 868: 
            case 869: 
            case 887: 
            case 929: 
            case 937: 
            case 938: {
                return new DDLSemanticAnalyzer(conf);
            }
            case 672: 
            case 702: 
            case 828: {
                return new FunctionSemanticAnalyzer(conf);
            }
            case 658: {
                return new ColumnStatsSemanticAnalyzer(conf);
            }
            case 675: 
            case 704: {
                return new MacroSemanticAnalyzer(conf);
            }
            case 692: 
            case 939: {
                return new UpdateDeleteSemanticAnalyzer(conf);
            }
        }
        SemanticAnalyzer semAnalyzer = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_CBO_ENABLED) ? new CalcitePlanner(conf) : new SemanticAnalyzer(conf);
        return semAnalyzer;
    }

    private static void setSessionCommandType(HiveOperation commandType) {
        if (SessionState.get() != null) {
            SessionState.get().setCommandType(commandType);
        }
    }

    private SemanticAnalyzerFactory() {
    }

    static HiveOperation getOperation(int hiveParserToken) {
        return commandType.get(hiveParserToken);
    }

    static {
        commandType.put(709, HiveOperation.EXPLAIN);
        commandType.put(768, HiveOperation.LOAD);
        commandType.put(712, HiveOperation.EXPORT);
        commandType.put(737, HiveOperation.IMPORT);
        commandType.put(671, HiveOperation.CREATEDATABASE);
        commandType.put(701, HiveOperation.DROPDATABASE);
        commandType.put(887, HiveOperation.SWITCHDATABASE);
        commandType.put(677, HiveOperation.CREATETABLE);
        commandType.put(929, HiveOperation.TRUNCATETABLE);
        commandType.put(706, HiveOperation.DROPTABLE);
        commandType.put(695, HiveOperation.DESCTABLE);
        commandType.put(694, HiveOperation.DESCFUNCTION);
        commandType.put(774, HiveOperation.MSCK);
        commandType.put(626, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(644, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(642, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(641, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(633, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(627, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(649, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(628, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(650, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(640, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(634, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(635, HiveOperation.ALTERTABLE_EXCHANGEPARTITION);
        commandType.put(852, HiveOperation.SHOWDATABASES);
        commandType.put(858, HiveOperation.SHOWTABLES);
        commandType.put(850, HiveOperation.SHOWCOLUMNS);
        commandType.put(867, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(868, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(860, HiveOperation.SHOW_CREATEDATABASE);
        commandType.put(861, HiveOperation.SHOW_CREATETABLE);
        commandType.put(854, HiveOperation.SHOWFUNCTIONS);
        commandType.put(855, HiveOperation.SHOWINDEXES);
        commandType.put(857, HiveOperation.SHOWPARTITIONS);
        commandType.put(856, HiveOperation.SHOWLOCKS);
        commandType.put(853, HiveOperation.SHOWLOCKS);
        commandType.put(851, HiveOperation.SHOWCONF);
        commandType.put(672, HiveOperation.CREATEFUNCTION);
        commandType.put(702, HiveOperation.DROPFUNCTION);
        commandType.put(675, HiveOperation.CREATEMACRO);
        commandType.put(704, HiveOperation.DROPMACRO);
        commandType.put(678, HiveOperation.CREATEVIEW);
        commandType.put(707, HiveOperation.DROPVIEW);
        commandType.put(673, HiveOperation.CREATEINDEX);
        commandType.put(703, HiveOperation.DROPINDEX);
        commandType.put(624, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(623, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(656, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(655, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(653, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(654, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(657, HiveOperation.ALTERVIEW_RENAME);
        commandType.put(652, HiveOperation.ALTERVIEW_AS);
        commandType.put(824, HiveOperation.QUERY);
        commandType.put(770, HiveOperation.LOCKTABLE);
        commandType.put(938, HiveOperation.UNLOCKTABLE);
        commandType.put(769, HiveOperation.LOCKDB);
        commandType.put(937, HiveOperation.UNLOCKDB);
        commandType.put(676, HiveOperation.CREATEROLE);
        commandType.put(705, HiveOperation.DROPROLE);
        commandType.put(722, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(834, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(862, HiveOperation.SHOW_GRANT);
        commandType.put(724, HiveOperation.GRANT_ROLE);
        commandType.put(835, HiveOperation.REVOKE_ROLE);
        commandType.put(863, HiveOperation.SHOW_ROLES);
        commandType.put(866, HiveOperation.SHOW_ROLES);
        commandType.put(865, HiveOperation.SHOW_ROLE_PRINCIPALS);
        commandType.put(864, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(622, HiveOperation.ALTERDATABASE);
        commandType.put(621, HiveOperation.ALTERDATABASE_OWNER);
        commandType.put(693, HiveOperation.DESCDATABASE);
        commandType.put(647, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(658, HiveOperation.ANALYZE_TABLE);
        commandType.put(639, HiveOperation.ALTERTABLE_PARTCOLTYPE);
        commandType.put(859, HiveOperation.SHOW_COMPACTIONS);
        commandType.put(869, HiveOperation.SHOW_TRANSACTIONS);
        commandType.put(875, HiveOperation.START_TRANSACTION);
        commandType.put(670, HiveOperation.COMMIT);
        commandType.put(838, HiveOperation.ROLLBACK);
        commandType.put(848, HiveOperation.SET_AUTOCOMMIT);
        tablePartitionCommandType.put(636, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(637, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(638, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(646, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(645, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(643, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(632, new HiveOperation[]{HiveOperation.ALTERTABLE_COMPACT, HiveOperation.ALTERTABLE_COMPACT});
        tablePartitionCommandType.put(648, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(629, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(631, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
        tablePartitionCommandType.put(651, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
    }
}

