/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;

public class HiveSortUnionReduceRule
extends RelOptRule {
    public static final HiveSortUnionReduceRule INSTANCE = new HiveSortUnionReduceRule();

    private HiveSortUnionReduceRule() {
        super(HiveSortUnionReduceRule.operand(HiveSortLimit.class, (RelOptRuleOperand)HiveSortUnionReduceRule.operand(HiveUnion.class, (RelOptRuleOperandChildren)HiveSortUnionReduceRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public boolean matches(RelOptRuleCall call) {
        HiveSortLimit sort = (HiveSortLimit)call.rel(0);
        HiveUnion union = (HiveUnion)call.rel(1);
        return union.all && sort.fetch != null && RexLiteral.intValue((RexNode)sort.fetch) > 0;
    }

    public void onMatch(RelOptRuleCall call) {
        HiveSortLimit sort = (HiveSortLimit)call.rel(0);
        HiveUnion union = (HiveUnion)call.rel(1);
        ArrayList<RelNode> inputs = new ArrayList<RelNode>();
        boolean finishPushSortPastUnion = true;
        int offset = sort.offset == null ? 0 : RexLiteral.intValue((RexNode)sort.offset);
        for (RelNode input : union.getInputs()) {
            if ((double)(RexLiteral.intValue((RexNode)sort.fetch) + offset) < RelMetadataQuery.getRowCount((RelNode)input)) {
                finishPushSortPastUnion = false;
                RexLiteral fetchRN = sort.getCluster().getRexBuilder().makeExactLiteral(BigDecimal.valueOf(RexLiteral.intValue((RexNode)sort.fetch) + offset));
                HiveSortLimit branchSort = sort.copy(sort.getTraitSet(), input, sort.getCollation(), null, (RexNode)fetchRN);
                branchSort.setRuleCreated(true);
                inputs.add(branchSort);
                continue;
            }
            inputs.add(input);
        }
        if (finishPushSortPastUnion) {
            return;
        }
        HiveUnion unionCopy = (HiveUnion)union.copy(union.getTraitSet(), inputs, union.all);
        HiveSortLimit result = sort.copy(sort.getTraitSet(), (RelNode)unionCopy, sort.getCollation(), sort.offset, sort.fetch);
        call.transformTo((RelNode)result);
    }
}

