/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRexUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(HiveRexUtil.class);

    public static RexNode simplify(RexBuilder rexBuilder, RexNode e) {
        return HiveRexUtil.simplify(rexBuilder, e, false);
    }

    public static RexNode simplify(RexBuilder rexBuilder, RexNode e, boolean unknownAsFalse) {
        switch (e.getKind()) {
            case AND: {
                return HiveRexUtil.simplifyAnd(rexBuilder, (RexCall)e, unknownAsFalse);
            }
            case OR: {
                return HiveRexUtil.simplifyOr(rexBuilder, (RexCall)e);
            }
            case NOT: {
                return HiveRexUtil.simplifyNot(rexBuilder, (RexCall)e);
            }
            case CASE: {
                return HiveRexUtil.simplifyCase(rexBuilder, (RexCall)e, unknownAsFalse);
            }
            case IS_NULL: {
                return ((RexNode)((RexCall)e).getOperands().get(0)).getType().isNullable() ? e : rexBuilder.makeLiteral(false);
            }
            case IS_NOT_NULL: {
                return ((RexNode)((RexCall)e).getOperands().get(0)).getType().isNullable() ? e : rexBuilder.makeLiteral(true);
            }
        }
        return e;
    }

    private static RexNode simplifyNot(RexBuilder rexBuilder, RexCall call) {
        RexNode a = (RexNode)call.getOperands().get(0);
        switch (a.getKind()) {
            case NOT: {
                return HiveRexUtil.simplify(rexBuilder, (RexNode)((RexCall)a).getOperands().get(0));
            }
        }
        SqlKind negateKind = a.getKind().negate();
        if (a.getKind() != negateKind) {
            return HiveRexUtil.simplify(rexBuilder, rexBuilder.makeCall(HiveRexUtil.op(negateKind), ImmutableList.of(((RexCall)a).getOperands().get(0))));
        }
        SqlKind negateKind2 = HiveRexUtil.negate(a.getKind());
        if (a.getKind() != negateKind2) {
            return HiveRexUtil.simplify(rexBuilder, rexBuilder.makeCall(HiveRexUtil.op(negateKind2), ((RexCall)a).getOperands()));
        }
        return call;
    }

    private static RexNode simplifyCase(RexBuilder rexBuilder, RexCall call, boolean unknownAsFalse) {
        ArrayList<RexNode> newOperands;
        List operands;
        block15: {
            operands = call.getOperands();
            newOperands = new ArrayList<RexNode>();
            HashSet<String> values = new HashSet<String>();
            boolean constainsNullableCase = false;
            for (int i = 0; i < operands.size(); ++i) {
                RexNode operand = (RexNode)operands.get(i);
                if (RexUtil.isCasePredicate((RexCall)call, (int)i)) {
                    if (operand.isAlwaysTrue()) {
                        newOperands.add((RexNode)operands.get(i + 1));
                        if (!operand.getType().isNullable()) break;
                        constainsNullableCase = true;
                        break;
                    }
                    if (operand.isAlwaysFalse() || RexUtil.isNull((RexNode)operand)) {
                        ++i;
                        continue;
                    }
                    if (operand.getType().isNullable()) {
                        constainsNullableCase = true;
                    }
                } else if (unknownAsFalse && RexUtil.isNull((RexNode)operand)) {
                    values.add(rexBuilder.makeLiteral(false).toString());
                } else {
                    values.add(operand.toString());
                }
                newOperands.add(operand);
            }
            assert (newOperands.size() % 2 == 1);
            if (newOperands.size() == 1 || values.size() == 1) {
                return rexBuilder.makeCast(call.getType(), (RexNode)newOperands.get(newOperands.size() - 1));
            }
            if (call.getType().getSqlTypeName() == SqlTypeName.BOOLEAN && (!constainsNullableCase || unknownAsFalse)) {
                List<Pair<RexNode, RexNode>> pairs = HiveRexUtil.casePairs(rexBuilder, newOperands);
                for (Ord pair : Ord.zip(pairs)) {
                    if (((RexNode)((Pair)pair.e).getValue()).isAlwaysTrue() || ((RexNode)((Pair)pair.e).getValue()).isAlwaysFalse() || unknownAsFalse && RexUtil.isNull((RexNode)((RexNode)((Pair)pair.e).getValue()))) continue;
                    break block15;
                }
                ArrayList<RexNode> terms = new ArrayList<RexNode>();
                ArrayList<Object> notTerms = new ArrayList<Object>();
                for (Ord pair : Ord.zip(pairs)) {
                    if (((RexNode)((Pair)pair.e).getValue()).isAlwaysTrue()) {
                        terms.add(RexUtil.andNot((RexBuilder)rexBuilder, (RexNode)((RexNode)((Pair)pair.e).getKey()), notTerms));
                        continue;
                    }
                    notTerms.add(((Pair)pair.e).getKey());
                }
                return RexUtil.composeDisjunction((RexBuilder)rexBuilder, terms, (boolean)false);
            }
        }
        if (newOperands.equals(operands)) {
            return call;
        }
        return call.clone(call.getType(), newOperands);
    }

    private static List<Pair<RexNode, RexNode>> casePairs(RexBuilder rexBuilder, List<RexNode> operands) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < operands.size() - 1; i += 2) {
            builder.add(Pair.of((Object)operands.get(i), (Object)operands.get(i + 1)));
        }
        builder.add(Pair.of((Object)rexBuilder.makeLiteral(true), (Object)Util.last(operands)));
        return builder.build();
    }

    public static RexNode simplifyAnd(RexBuilder rexBuilder, RexCall e, boolean unknownAsFalse) {
        ArrayList<RexNode> terms = new ArrayList<RexNode>();
        ArrayList<RexNode> notTerms = new ArrayList<RexNode>();
        RelOptUtil.decomposeConjunction((RexNode)e, terms, notTerms);
        if (unknownAsFalse) {
            return HiveRexUtil.simplifyAnd2ForUnknownAsFalse(rexBuilder, terms, notTerms);
        }
        return HiveRexUtil.simplifyAnd2(rexBuilder, terms, notTerms);
    }

    public static RexNode simplifyAnd2(RexBuilder rexBuilder, List<RexNode> terms, List<RexNode> notTerms) {
        if (terms.contains(rexBuilder.makeLiteral(false))) {
            return rexBuilder.makeLiteral(false);
        }
        if (terms.isEmpty() && notTerms.isEmpty()) {
            return rexBuilder.makeLiteral(true);
        }
        if (terms.size() == 1 && notTerms.isEmpty()) {
            return HiveRexUtil.simplify(rexBuilder, terms.get(0));
        }
        for (RexNode notDisjunction : notTerms) {
            List terms2 = RelOptUtil.conjunctions((RexNode)notDisjunction);
            if (!terms.containsAll(terms2)) continue;
            return rexBuilder.makeLiteral(false);
        }
        for (RexNode notDisjunction : notTerms) {
            terms.add(HiveRexUtil.simplify(rexBuilder, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{notDisjunction})));
        }
        return RexUtil.composeConjunction((RexBuilder)rexBuilder, terms, (boolean)false);
    }

    public static RexNode simplifyAnd2ForUnknownAsFalse(RexBuilder rexBuilder, List<RexNode> terms, List<RexNode> notTerms) {
        if (terms.contains(rexBuilder.makeLiteral(false))) {
            return rexBuilder.makeLiteral(false);
        }
        if (terms.isEmpty() && notTerms.isEmpty()) {
            return rexBuilder.makeLiteral(true);
        }
        if (terms.size() == 1 && notTerms.isEmpty()) {
            return HiveRexUtil.simplify(rexBuilder, terms.get(0), true);
        }
        HashSet<String> negatedTerms = new HashSet<String>();
        HashSet<String> nullOperands = new HashSet<String>();
        LinkedHashSet notNullOperands = new LinkedHashSet();
        HashSet<String> comparedOperands = new HashSet<String>();
        block7: for (int i = 0; i < terms.size(); ++i) {
            RexNode term = terms.get(i);
            if (!HiveCalciteUtil.isDeterministic(term)) continue;
            switch (term.getKind()) {
                case EQUALS: 
                case NOT_EQUALS: 
                case LESS_THAN: 
                case GREATER_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN_OR_EQUAL: {
                    RexCall negatedTerm;
                    RexCall call = (RexCall)term;
                    RexNode left = (RexNode)call.getOperands().get(0);
                    comparedOperands.add(left.toString());
                    if (left.getKind() == SqlKind.CAST) {
                        RexCall leftCast = (RexCall)left;
                        comparedOperands.add(((RexNode)leftCast.getOperands().get(0)).toString());
                    }
                    RexNode right = (RexNode)call.getOperands().get(1);
                    comparedOperands.add(right.toString());
                    if (right.getKind() == SqlKind.CAST) {
                        RexCall rightCast = (RexCall)right;
                        comparedOperands.add(((RexNode)rightCast.getOperands().get(0)).toString());
                    }
                    if ((negatedTerm = HiveRexUtil.negate(rexBuilder, call)) == null) continue block7;
                    negatedTerms.add(negatedTerm.toString());
                    RexCall invertNegatedTerm = HiveRexUtil.invert(rexBuilder, negatedTerm);
                    if (invertNegatedTerm == null) continue block7;
                    negatedTerms.add(invertNegatedTerm.toString());
                    continue block7;
                }
                case IN: {
                    comparedOperands.add(((RexNode)((RexCall)term).operands.get(0)).toString());
                    continue block7;
                }
                case BETWEEN: {
                    comparedOperands.add(((RexNode)((RexCall)term).operands.get(1)).toString());
                    continue block7;
                }
                case IS_NOT_NULL: {
                    notNullOperands.add(((RexCall)term).getOperands().get(0));
                    terms.remove(i);
                    --i;
                    continue block7;
                }
                case IS_NULL: {
                    nullOperands.add(((RexNode)((RexCall)term).getOperands().get(0)).toString());
                }
            }
        }
        if (!Collections.disjoint(nullOperands, comparedOperands)) {
            return rexBuilder.makeLiteral(false);
        }
        for (RexNode operand : notNullOperands) {
            if (comparedOperands.contains(operand.toString())) continue;
            terms.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{operand}));
        }
        HashSet<String> termsSet = new HashSet<String>(Lists.transform(terms, HiveCalciteUtil.REX_STR_FN));
        for (RexNode notDisjunction : notTerms) {
            List<String> terms2Set;
            if (!HiveCalciteUtil.isDeterministic(notDisjunction) || !termsSet.containsAll(terms2Set = Lists.transform(RelOptUtil.conjunctions((RexNode)notDisjunction), HiveCalciteUtil.REX_STR_FN))) continue;
            return rexBuilder.makeLiteral(false);
        }
        for (RexNode notDisjunction : notTerms) {
            terms.add(HiveRexUtil.simplify(rexBuilder, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{notDisjunction}), true));
        }
        for (String negatedTerm : negatedTerms) {
            if (!termsSet.contains(negatedTerm)) continue;
            return rexBuilder.makeLiteral(false);
        }
        return RexUtil.composeConjunction((RexBuilder)rexBuilder, terms, (boolean)false);
    }

    public static RexNode simplifyOr(RexBuilder rexBuilder, RexCall call) {
        assert (call.getKind() == SqlKind.OR);
        List terms = RelOptUtil.disjunctions((RexNode)call);
        block3: for (int i = 0; i < terms.size(); ++i) {
            RexNode term = (RexNode)terms.get(i);
            switch (term.getKind()) {
                case LITERAL: {
                    if (RexLiteral.isNullLiteral((RexNode)term)) continue block3;
                    if (RexLiteral.booleanValue((RexNode)term)) {
                        return term;
                    }
                    terms.remove(i);
                    --i;
                }
            }
        }
        return RexUtil.composeDisjunction((RexBuilder)rexBuilder, (Iterable)terms, (boolean)false);
    }

    private static RexCall negate(RexBuilder rexBuilder, RexCall call) {
        switch (call.getKind()) {
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: {
                return (RexCall)rexBuilder.makeCall(HiveRexUtil.op(HiveRexUtil.negate(call.getKind())), call.getOperands());
            }
        }
        return null;
    }

    private static SqlKind negate(SqlKind kind) {
        switch (kind) {
            case EQUALS: {
                return SqlKind.NOT_EQUALS;
            }
            case NOT_EQUALS: {
                return SqlKind.EQUALS;
            }
            case LESS_THAN: {
                return SqlKind.GREATER_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return SqlKind.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlKind.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlKind.LESS_THAN;
            }
        }
        return kind;
    }

    private static RexCall invert(RexBuilder rexBuilder, RexCall call) {
        switch (call.getKind()) {
            case EQUALS: {
                return (RexCall)rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, Lists.reverse(call.getOperands()));
            }
            case NOT_EQUALS: {
                return (RexCall)rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, Lists.reverse(call.getOperands()));
            }
            case LESS_THAN: {
                return (RexCall)rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, Lists.reverse(call.getOperands()));
            }
            case GREATER_THAN: {
                return (RexCall)rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, Lists.reverse(call.getOperands()));
            }
            case LESS_THAN_OR_EQUAL: {
                return (RexCall)rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, Lists.reverse(call.getOperands()));
            }
            case GREATER_THAN_OR_EQUAL: {
                return (RexCall)rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, Lists.reverse(call.getOperands()));
            }
        }
        return null;
    }

    private static SqlOperator op(SqlKind kind) {
        switch (kind) {
            case IS_FALSE: {
                return SqlStdOperatorTable.IS_FALSE;
            }
            case IS_TRUE: {
                return SqlStdOperatorTable.IS_TRUE;
            }
            case IS_UNKNOWN: {
                return SqlStdOperatorTable.IS_UNKNOWN;
            }
            case IS_NULL: {
                return SqlStdOperatorTable.IS_NULL;
            }
            case IS_NOT_FALSE: {
                return SqlStdOperatorTable.IS_NOT_FALSE;
            }
            case IS_NOT_TRUE: {
                return SqlStdOperatorTable.IS_NOT_TRUE;
            }
            case IS_NOT_NULL: {
                return SqlStdOperatorTable.IS_NOT_NULL;
            }
            case EQUALS: {
                return SqlStdOperatorTable.EQUALS;
            }
            case NOT_EQUALS: {
                return SqlStdOperatorTable.NOT_EQUALS;
            }
            case LESS_THAN: {
                return SqlStdOperatorTable.LESS_THAN;
            }
            case GREATER_THAN: {
                return SqlStdOperatorTable.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
            }
        }
        throw new AssertionError(kind);
    }

    public static SqlKind invert(SqlKind kind) {
        switch (kind) {
            case EQUALS: {
                return SqlKind.EQUALS;
            }
            case NOT_EQUALS: {
                return SqlKind.NOT_EQUALS;
            }
            case LESS_THAN: {
                return SqlKind.GREATER_THAN;
            }
            case GREATER_THAN: {
                return SqlKind.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlKind.GREATER_THAN_OR_EQUAL;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlKind.LESS_THAN_OR_EQUAL;
            }
        }
        return null;
    }

    public static class ExprSimplifier
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private final boolean unknownAsFalse;
        private final Map<RexNode, Boolean> unknownAsFalseMap;

        public ExprSimplifier(RexBuilder rexBuilder, boolean unknownAsFalse) {
            this.rexBuilder = rexBuilder;
            this.unknownAsFalse = unknownAsFalse;
            this.unknownAsFalseMap = new HashMap<RexNode, Boolean>();
        }

        public RexNode visitCall(RexCall call) {
            RexNode simplifiedNode;
            RexNode node;
            Boolean unknownAsFalseCall = this.unknownAsFalse;
            if (unknownAsFalseCall.booleanValue()) {
                switch (call.getKind()) {
                    case AND: 
                    case CASE: {
                        unknownAsFalseCall = this.unknownAsFalseMap.get(call);
                        if (unknownAsFalseCall != null) break;
                        unknownAsFalseCall = true;
                        break;
                    }
                    default: {
                        unknownAsFalseCall = false;
                    }
                }
                for (RexNode operand : call.operands) {
                    this.unknownAsFalseMap.put(operand, unknownAsFalseCall);
                }
            }
            if ((node = super.visitCall(call)) == (simplifiedNode = HiveRexUtil.simplify(this.rexBuilder, node, unknownAsFalseCall))) {
                return node;
            }
            if (simplifiedNode.getType().equals(call.getType())) {
                return simplifiedNode;
            }
            return this.rexBuilder.makeCast(call.getType(), simplifiedNode, true);
        }
    }
}

