/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc.encoded;

public class OrcBatchKey {
    public long file;
    public int stripeIx;
    public int rgIx;

    public OrcBatchKey(long file, int stripeIx, int rgIx) {
        this.set(file, stripeIx, rgIx);
    }

    public void set(long file, int stripeIx, int rgIx) {
        this.file = file;
        this.stripeIx = stripeIx;
        this.rgIx = rgIx;
    }

    public String toString() {
        return "[" + this.file + ", stripe " + this.stripeIx + ", rgIx " + this.rgIx + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + (int)(this.file ^ this.file >>> 32);
        return (31 * result + this.rgIx) * 31 + this.stripeIx;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OrcBatchKey)) {
            return false;
        }
        OrcBatchKey other = (OrcBatchKey)obj;
        return this.stripeIx == other.stripeIx && this.rgIx == other.rgIx && this.file == other.file;
    }

    public OrcBatchKey clone() throws CloneNotSupportedException {
        return new OrcBatchKey(this.file, this.stripeIx, this.rgIx);
    }
}

