/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.io.orc.TreeReaderFactory;
import org.apache.orc.OrcProto;
import org.apache.orc.OrcUtils;
import org.apache.orc.TypeDescription;

public class SchemaEvolution {
    private static final Log LOG = LogFactory.getLog(SchemaEvolution.class);
    public static final List<String> acidEventFieldNames = new ArrayList<String>();
    public static final List<OrcProto.Type.Kind> acidEventOrcTypeKinds;

    public static TreeReaderFactory.TreeReaderSchema validateAndCreate(List<OrcProto.Type> fileTypes, List<OrcProto.Type> schemaTypes) throws IOException {
        List<OrcProto.Type> fullSchemaTypes;
        List<OrcProto.Type> rowSchema;
        int rowSubtype;
        boolean isAcid = SchemaEvolution.checkAcidSchema(fileTypes);
        if (isAcid) {
            rowSubtype = 6;
            rowSchema = fileTypes.subList(rowSubtype, fileTypes.size());
        } else {
            rowSubtype = 0;
            rowSchema = fileTypes;
        }
        int numFileColumns = rowSchema.get(0).getSubtypesCount();
        int numDesiredColumns = schemaTypes.get(0).getSubtypesCount();
        int numReadColumns = Math.min(numFileColumns, numDesiredColumns);
        for (int i = 0; i < numReadColumns; ++i) {
            OrcProto.Type fColType = fileTypes.get(rowSubtype + i);
            OrcProto.Type rColType = schemaTypes.get(i);
            if (fColType.getKind().equals(rColType.getKind())) continue;
            boolean ok = false;
            if (fColType.getKind().equals(OrcProto.Type.Kind.SHORT)) {
                if (rColType.getKind().equals(OrcProto.Type.Kind.INT) || rColType.getKind().equals(OrcProto.Type.Kind.LONG)) {
                    ok = true;
                }
            } else if (fColType.getKind().equals(OrcProto.Type.Kind.INT) && rColType.getKind().equals(OrcProto.Type.Kind.LONG)) {
                ok = true;
            }
            if (ok) continue;
            throw new IOException("ORC does not support type conversion from " + fColType.getKind().name() + " to " + rColType.getKind().name());
        }
        if (isAcid) {
            fullSchemaTypes = new ArrayList<OrcProto.Type>();
            for (int i = 0; i < rowSubtype; ++i) {
                fullSchemaTypes.add(fileTypes.get(i).toBuilder().build());
            }
            OrcUtils.appendOrcTypesRebuildSubtypes(fullSchemaTypes, schemaTypes, 0);
        } else {
            fullSchemaTypes = schemaTypes;
        }
        int innerStructSubtype = rowSubtype;
        return new TreeReaderFactory.TreeReaderSchema().fileTypes(fileTypes).schemaTypes(fullSchemaTypes).innerStructSubtype(innerStructSubtype);
    }

    private static boolean checkAcidSchema(List<OrcProto.Type> fileSchema) {
        List<String> rootFields;
        return fileSchema.get(0).getKind().equals(OrcProto.Type.Kind.STRUCT) && acidEventFieldNames.equals(rootFields = fileSchema.get(0).getFieldNamesList());
    }

    public static List<OrcProto.Type> createEventSchema(TypeDescription typeDescr) {
        int i;
        ArrayList<OrcProto.Type> result = new ArrayList<OrcProto.Type>();
        OrcProto.Type.Builder type = OrcProto.Type.newBuilder();
        type.setKind(OrcProto.Type.Kind.STRUCT);
        type.addAllFieldNames(acidEventFieldNames);
        for (i = 0; i < acidEventFieldNames.size(); ++i) {
            type.addSubtypes(i + 1);
        }
        result.add(type.build());
        for (i = 0; i < acidEventOrcTypeKinds.size() - 1; ++i) {
            type.clear();
            type.setKind(acidEventOrcTypeKinds.get(i));
            result.add(type.build());
        }
        OrcUtils.appendOrcTypesRebuildSubtypes(result, typeDescr);
        return result;
    }

    static {
        acidEventFieldNames.add("operation");
        acidEventFieldNames.add("originalTransaction");
        acidEventFieldNames.add("bucket");
        acidEventFieldNames.add("rowId");
        acidEventFieldNames.add("currentTransaction");
        acidEventFieldNames.add("row");
        acidEventOrcTypeKinds = new ArrayList<OrcProto.Type.Kind>();
        acidEventOrcTypeKinds.add(OrcProto.Type.Kind.INT);
        acidEventOrcTypeKinds.add(OrcProto.Type.Kind.LONG);
        acidEventOrcTypeKinds.add(OrcProto.Type.Kind.INT);
        acidEventOrcTypeKinds.add(OrcProto.Type.Kind.LONG);
        acidEventOrcTypeKinds.add(OrcProto.Type.Kind.LONG);
        acidEventOrcTypeKinds.add(OrcProto.Type.Kind.STRUCT);
    }
}

