/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.orc.DefaultDataReaderFactory;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderUtils;
import org.apache.hadoop.hive.ql.io.orc.SchemaEvolution;
import org.apache.hadoop.hive.ql.io.orc.TreeReaderFactory;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.Text;
import org.apache.orc.BloomFilterIO;
import org.apache.orc.BooleanColumnStatistics;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.CompressionCodec;
import org.apache.orc.DataReader;
import org.apache.orc.DataReaderFactory;
import org.apache.orc.DateColumnStatistics;
import org.apache.orc.DecimalColumnStatistics;
import org.apache.orc.DoubleColumnStatistics;
import org.apache.orc.IntegerColumnStatistics;
import org.apache.orc.MetadataReaderFactory;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcProto;
import org.apache.orc.OrcUtils;
import org.apache.orc.Reader;
import org.apache.orc.StringColumnStatistics;
import org.apache.orc.StripeInformation;
import org.apache.orc.TimestampColumnStatistics;
import org.apache.orc.impl.BufferChunk;
import org.apache.orc.impl.ColumnStatisticsImpl;
import org.apache.orc.impl.DataReaderProperties;
import org.apache.orc.impl.DefaultMetadataReaderFactory;
import org.apache.orc.impl.InStream;
import org.apache.orc.impl.MetadataReader;
import org.apache.orc.impl.MetadataReaderProperties;
import org.apache.orc.impl.OrcIndex;
import org.apache.orc.impl.PositionProvider;
import org.apache.orc.impl.StreamName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordReaderImpl
implements RecordReader {
    static final Logger LOG = LoggerFactory.getLogger(RecordReaderImpl.class);
    private static final boolean isLogDebugEnabled = LOG.isDebugEnabled();
    private static final Object UNKNOWN_VALUE = new Object();
    private final Path path;
    private final long firstRow;
    private final List<StripeInformation> stripes = new ArrayList<StripeInformation>();
    private OrcProto.StripeFooter stripeFooter;
    private final long totalRowCount;
    private final CompressionCodec codec;
    private final List<OrcProto.Type> types;
    private final int bufferSize;
    private final boolean[] included;
    private final long rowIndexStride;
    private long rowInStripe = 0L;
    private int currentStripe = -1;
    private long rowBaseInStripe = 0L;
    private long rowCountInStripe = 0L;
    private final Map<StreamName, InStream> streams = new HashMap<StreamName, InStream>();
    DiskRangeList bufferChunks = null;
    private final TreeReaderFactory.TreeReader reader;
    private final OrcProto.RowIndex[] indexes;
    private final OrcProto.BloomFilterIndex[] bloomFilterIndices;
    private final SargApplier sargApp;
    private boolean[] includedRowGroups = null;
    private final Configuration conf;
    private final MetadataReader metadata;
    private final DataReader dataReader;
    private static final String TRANSLATED_SARG_SEPARATOR = "_";

    static int findColumns(String[] columnNames, String columnName, int rootColumn) {
        for (int i = 0; i < columnNames.length; ++i) {
            if (!columnName.equals(columnNames[i])) continue;
            return i + rootColumn;
        }
        return -1;
    }

    public static int[] mapSargColumnsToOrcInternalColIdx(List<PredicateLeaf> sargLeaves, String[] columnNames, int rootColumn) {
        int[] result = new int[sargLeaves.size()];
        Arrays.fill(result, -1);
        for (int i = 0; i < result.length; ++i) {
            String colName = sargLeaves.get(i).getColumnName();
            result[i] = RecordReaderImpl.findColumns(columnNames, colName, rootColumn);
        }
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    private RecordReaderImpl(Builder builder) throws IOException {
        TreeReaderFactory.TreeReaderSchema treeReaderSchema;
        Reader.Options options = builder.options;
        this.types = builder.types;
        if (options.getSchema() == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Schema on read not provided -- using file schema " + this.types.toString());
            }
            treeReaderSchema = new TreeReaderFactory.TreeReaderSchema().fileTypes(this.types).schemaTypes(this.types);
        } else {
            List<OrcProto.Type> schemaTypes = OrcUtils.getOrcTypes(options.getSchema());
            treeReaderSchema = SchemaEvolution.validateAndCreate(this.types, schemaTypes);
        }
        this.path = builder.path;
        this.codec = builder.codec;
        this.bufferSize = builder.bufferSize;
        this.included = options.getInclude();
        this.conf = builder.conf;
        this.rowIndexStride = builder.strideRate;
        this.metadata = builder.metadataReaderFactory.create(MetadataReaderProperties.builder().withFileSystem(builder.fileSystem).withPath(this.path).withCodec(this.codec).withBufferSize(this.bufferSize).withTypeCount(this.types.size()).build());
        SearchArgument sarg = options.getSearchArgument();
        this.sargApp = sarg != null && builder.strideRate != 0L ? new SargApplier(sarg, options.getColumnNames(), builder.strideRate, this.types, this.included.length) : null;
        long rows = 0L;
        long skippedRows = 0L;
        long offset = options.getOffset();
        long maxOffset = options.getMaxOffset();
        for (StripeInformation stripe : builder.stripes) {
            long stripeStart = stripe.getOffset();
            if (offset > stripeStart) {
                skippedRows += stripe.getNumberOfRows();
                continue;
            }
            if (stripeStart >= maxOffset) continue;
            this.stripes.add(stripe);
            rows += stripe.getNumberOfRows();
        }
        Boolean zeroCopy = options.getUseZeroCopy();
        if (zeroCopy == null) {
            zeroCopy = OrcConf.USE_ZEROCOPY.getBoolean(this.conf);
        }
        this.dataReader = builder.dataReaderFactory.create(DataReaderProperties.builder().withFileSystem(builder.fileSystem).withCodec(this.codec).withPath(this.path).withZeroCopy(zeroCopy).build());
        this.dataReader.open();
        this.firstRow = skippedRows;
        this.totalRowCount = rows;
        Boolean skipCorrupt = options.getSkipCorruptRecords();
        if (skipCorrupt == null) {
            skipCorrupt = OrcConf.SKIP_CORRUPT_DATA.getBoolean(this.conf);
        }
        this.reader = TreeReaderFactory.createTreeReader(0, treeReaderSchema, this.included, skipCorrupt);
        this.indexes = new OrcProto.RowIndex[this.types.size()];
        this.bloomFilterIndices = new OrcProto.BloomFilterIndex[this.types.size()];
        this.advanceToNextRow(this.reader, 0L, true);
    }

    OrcProto.StripeFooter readStripeFooter(StripeInformation stripe) throws IOException {
        return this.metadata.readStripeFooter(stripe);
    }

    static <T> Location compareToRange(Comparable<T> point, T min, T max) {
        int minCompare = point.compareTo(min);
        if (minCompare < 0) {
            return Location.BEFORE;
        }
        if (minCompare == 0) {
            return Location.MIN;
        }
        int maxCompare = point.compareTo(max);
        if (maxCompare > 0) {
            return Location.AFTER;
        }
        if (maxCompare == 0) {
            return Location.MAX;
        }
        return Location.MIDDLE;
    }

    static Object getMax(ColumnStatistics index) {
        if (index instanceof IntegerColumnStatistics) {
            return ((IntegerColumnStatistics)index).getMaximum();
        }
        if (index instanceof DoubleColumnStatistics) {
            return ((DoubleColumnStatistics)index).getMaximum();
        }
        if (index instanceof StringColumnStatistics) {
            return ((StringColumnStatistics)index).getMaximum();
        }
        if (index instanceof DateColumnStatistics) {
            return ((DateColumnStatistics)index).getMaximum();
        }
        if (index instanceof DecimalColumnStatistics) {
            return ((DecimalColumnStatistics)index).getMaximum();
        }
        if (index instanceof TimestampColumnStatistics) {
            return ((TimestampColumnStatistics)index).getMaximum();
        }
        if (index instanceof BooleanColumnStatistics) {
            if (((BooleanColumnStatistics)index).getTrueCount() != 0L) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    static Object getMin(ColumnStatistics index) {
        if (index instanceof IntegerColumnStatistics) {
            return ((IntegerColumnStatistics)index).getMinimum();
        }
        if (index instanceof DoubleColumnStatistics) {
            return ((DoubleColumnStatistics)index).getMinimum();
        }
        if (index instanceof StringColumnStatistics) {
            return ((StringColumnStatistics)index).getMinimum();
        }
        if (index instanceof DateColumnStatistics) {
            return ((DateColumnStatistics)index).getMinimum();
        }
        if (index instanceof DecimalColumnStatistics) {
            return ((DecimalColumnStatistics)index).getMinimum();
        }
        if (index instanceof TimestampColumnStatistics) {
            return ((TimestampColumnStatistics)index).getMinimum();
        }
        if (index instanceof BooleanColumnStatistics) {
            if (((BooleanColumnStatistics)index).getFalseCount() != 0L) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return UNKNOWN_VALUE;
    }

    static SearchArgument.TruthValue evaluatePredicateProto(OrcProto.ColumnStatistics statsProto, PredicateLeaf predicate, OrcProto.BloomFilter bloomFilter) {
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize(statsProto);
        Object minValue = RecordReaderImpl.getMin(cs);
        Object maxValue = RecordReaderImpl.getMax(cs);
        BloomFilterIO bf = null;
        if (bloomFilter != null) {
            bf = new BloomFilterIO(bloomFilter);
        }
        return RecordReaderImpl.evaluatePredicateRange(predicate, minValue, maxValue, cs.hasNull(), bf);
    }

    static SearchArgument.TruthValue evaluatePredicate(ColumnStatistics stats, PredicateLeaf predicate, BloomFilterIO bloomFilter) {
        Object minValue = RecordReaderImpl.getMin(stats);
        Object maxValue = RecordReaderImpl.getMax(stats);
        return RecordReaderImpl.evaluatePredicateRange(predicate, minValue, maxValue, stats.hasNull(), bloomFilter);
    }

    static SearchArgument.TruthValue evaluatePredicateRange(PredicateLeaf predicate, Object min, Object max, boolean hasNull, BloomFilterIO bloomFilter) {
        SearchArgument.TruthValue result;
        if (min == null) {
            if (predicate.getOperator() == PredicateLeaf.Operator.IS_NULL) {
                return SearchArgument.TruthValue.YES;
            }
            return SearchArgument.TruthValue.NULL;
        }
        if (min == UNKNOWN_VALUE) {
            return SearchArgument.TruthValue.YES_NO_NULL;
        }
        try {
            Object baseObj = predicate.getLiteral();
            Object minValue = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), min);
            Object maxValue = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), max);
            Object predObj = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), baseObj);
            result = RecordReaderImpl.evaluatePredicateMinMax(predicate, predObj, minValue, maxValue, hasNull);
            if (RecordReaderImpl.shouldEvaluateBloomFilter(predicate, result, bloomFilter)) {
                result = RecordReaderImpl.evaluatePredicateBloomFilter(predicate, predObj, bloomFilter, hasNull);
            }
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Exception when evaluating predicate. Skipping ORC PPD. Exception: " + ExceptionUtils.getStackTrace(e));
            }
            result = predicate.getOperator().equals((Object)PredicateLeaf.Operator.NULL_SAFE_EQUALS) || !hasNull ? SearchArgument.TruthValue.YES_NO : SearchArgument.TruthValue.YES_NO_NULL;
        }
        return result;
    }

    private static boolean shouldEvaluateBloomFilter(PredicateLeaf predicate, SearchArgument.TruthValue result, BloomFilterIO bloomFilter) {
        return bloomFilter != null && result != SearchArgument.TruthValue.NO_NULL && result != SearchArgument.TruthValue.NO && (predicate.getOperator().equals((Object)PredicateLeaf.Operator.EQUALS) || predicate.getOperator().equals((Object)PredicateLeaf.Operator.NULL_SAFE_EQUALS) || predicate.getOperator().equals((Object)PredicateLeaf.Operator.IN));
    }

    private static SearchArgument.TruthValue evaluatePredicateMinMax(PredicateLeaf predicate, Object predObj, Object minValue, Object maxValue, boolean hasNull) {
        switch (predicate.getOperator()) {
            case NULL_SAFE_EQUALS: {
                Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                if (loc == Location.BEFORE || loc == Location.AFTER) {
                    return SearchArgument.TruthValue.NO;
                }
                return SearchArgument.TruthValue.YES_NO;
            }
            case EQUALS: {
                Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                if (minValue.equals(maxValue) && loc == Location.MIN) {
                    return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                }
                if (loc == Location.BEFORE || loc == Location.AFTER) {
                    return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                }
                return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
            }
            case LESS_THAN: {
                Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                if (loc == Location.AFTER) {
                    return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                }
                if (loc == Location.BEFORE || loc == Location.MIN) {
                    return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                }
                return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
            }
            case LESS_THAN_EQUALS: {
                Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                if (loc == Location.AFTER || loc == Location.MAX) {
                    return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                }
                if (loc == Location.BEFORE) {
                    return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                }
                return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
            }
            case IN: {
                if (minValue.equals(maxValue)) {
                    for (Object arg : predicate.getLiteralList()) {
                        predObj = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), arg);
                        Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                        if (loc != Location.MIN) continue;
                        return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                    }
                    return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                }
                for (Object arg : predicate.getLiteralList()) {
                    predObj = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), arg);
                    Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                    if (loc != Location.MIN && loc != Location.MIDDLE && loc != Location.MAX) continue;
                    return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
                }
                return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
            }
            case BETWEEN: {
                List<Object> args = predicate.getLiteralList();
                Object predObj1 = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), args.get(0));
                Location loc = RecordReaderImpl.compareToRange((Comparable)predObj1, minValue, maxValue);
                if (loc == Location.BEFORE || loc == Location.MIN) {
                    Object predObj2 = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), args.get(1));
                    Location loc2 = RecordReaderImpl.compareToRange((Comparable)predObj2, minValue, maxValue);
                    if (loc2 == Location.AFTER || loc2 == Location.MAX) {
                        return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                    }
                    if (loc2 == Location.BEFORE) {
                        return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                    }
                    return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
                }
                if (loc == Location.AFTER) {
                    return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                }
                return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
            }
            case IS_NULL: {
                return hasNull ? SearchArgument.TruthValue.YES_NO : SearchArgument.TruthValue.NO;
            }
        }
        return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
    }

    private static SearchArgument.TruthValue evaluatePredicateBloomFilter(PredicateLeaf predicate, Object predObj, BloomFilterIO bloomFilter, boolean hasNull) {
        switch (predicate.getOperator()) {
            case NULL_SAFE_EQUALS: {
                return RecordReaderImpl.checkInBloomFilter(bloomFilter, predObj, false);
            }
            case EQUALS: {
                return RecordReaderImpl.checkInBloomFilter(bloomFilter, predObj, hasNull);
            }
            case IN: {
                for (Object arg : predicate.getLiteralList()) {
                    Object predObjItem = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), arg);
                    SearchArgument.TruthValue result = RecordReaderImpl.checkInBloomFilter(bloomFilter, predObjItem, hasNull);
                    if (result != SearchArgument.TruthValue.YES_NO_NULL && result != SearchArgument.TruthValue.YES_NO) continue;
                    return result;
                }
                return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
            }
        }
        return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
    }

    private static SearchArgument.TruthValue checkInBloomFilter(BloomFilterIO bf, Object predObj, boolean hasNull) {
        SearchArgument.TruthValue result;
        SearchArgument.TruthValue truthValue = result = hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
        if (predObj instanceof Long) {
            if (bf.testLong((Long)predObj)) {
                result = SearchArgument.TruthValue.YES_NO_NULL;
            }
        } else if (predObj instanceof Double) {
            if (bf.testDouble((Double)predObj)) {
                result = SearchArgument.TruthValue.YES_NO_NULL;
            }
        } else if (predObj instanceof String || predObj instanceof Text || predObj instanceof HiveDecimalWritable || predObj instanceof BigDecimal) {
            if (bf.testString(predObj.toString())) {
                result = SearchArgument.TruthValue.YES_NO_NULL;
            }
        } else if (predObj instanceof Timestamp) {
            if (bf.testLong(((Timestamp)predObj).getTime())) {
                result = SearchArgument.TruthValue.YES_NO_NULL;
            }
        } else if (predObj instanceof TimestampWritable) {
            if (bf.testLong(((TimestampWritable)predObj).getTimestamp().getTime())) {
                result = SearchArgument.TruthValue.YES_NO_NULL;
            }
        } else if (predObj instanceof Date) {
            if (bf.testLong(DateWritable.dateToDays((Date)predObj))) {
                result = SearchArgument.TruthValue.YES_NO_NULL;
            }
        } else {
            result = predObj == null && !hasNull ? SearchArgument.TruthValue.NO : SearchArgument.TruthValue.YES_NO_NULL;
        }
        if (result == SearchArgument.TruthValue.YES_NO_NULL && !hasNull) {
            result = SearchArgument.TruthValue.YES_NO;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Bloom filter evaluation: " + result.toString());
        }
        return result;
    }

    private static Object getBaseObjectForComparison(PredicateLeaf.Type type, Object obj) {
        if (obj == null) {
            return null;
        }
        switch (type) {
            case BOOLEAN: {
                if (obj instanceof Boolean) {
                    return obj;
                }
                return Boolean.valueOf(obj.toString());
            }
            case DATE: {
                if (obj instanceof Date) {
                    return obj;
                }
                if (obj instanceof String) {
                    return Date.valueOf((String)obj);
                }
                if (!(obj instanceof Timestamp)) break;
                return DateWritable.timeToDate(((Timestamp)obj).getTime() / 1000L);
            }
            case DECIMAL: {
                if (obj instanceof Boolean) {
                    return new HiveDecimalWritable((Boolean)obj != false ? HiveDecimal.ONE : HiveDecimal.ZERO);
                }
                if (obj instanceof Integer) {
                    return new HiveDecimalWritable(((Integer)obj).intValue());
                }
                if (obj instanceof Long) {
                    return new HiveDecimalWritable((Long)obj);
                }
                if (obj instanceof Float || obj instanceof Double || obj instanceof String) {
                    return new HiveDecimalWritable(obj.toString());
                }
                if (obj instanceof BigDecimal) {
                    return new HiveDecimalWritable(HiveDecimal.create((BigDecimal)obj));
                }
                if (obj instanceof HiveDecimal) {
                    return new HiveDecimalWritable((HiveDecimal)obj);
                }
                if (obj instanceof HiveDecimalWritable) {
                    return obj;
                }
                if (!(obj instanceof Timestamp)) break;
                return new HiveDecimalWritable(new Double(new TimestampWritable((Timestamp)obj).getDouble()).toString());
            }
            case FLOAT: {
                if (obj instanceof Number) {
                    return ((Number)obj).doubleValue();
                }
                if (obj instanceof HiveDecimal) {
                    return ((HiveDecimal)obj).doubleValue();
                }
                if (obj instanceof String) {
                    return Double.valueOf(obj.toString());
                }
                if (obj instanceof Timestamp) {
                    return new TimestampWritable((Timestamp)obj).getDouble();
                }
                if (obj instanceof HiveDecimal) {
                    return ((HiveDecimal)obj).doubleValue();
                }
                if (!(obj instanceof BigDecimal)) break;
                return ((BigDecimal)obj).doubleValue();
            }
            case LONG: {
                if (obj instanceof Number) {
                    return ((Number)obj).longValue();
                }
                if (obj instanceof HiveDecimal) {
                    return ((HiveDecimal)obj).longValue();
                }
                if (!(obj instanceof String)) break;
                return Long.valueOf(obj.toString());
            }
            case STRING: {
                if (obj == null) break;
                return obj.toString();
            }
            case TIMESTAMP: {
                if (obj instanceof Timestamp) {
                    return obj;
                }
                if (obj instanceof Integer) {
                    return TimestampWritable.longToTimestamp(((Number)obj).longValue(), false);
                }
                if (obj instanceof Float) {
                    return TimestampWritable.doubleToTimestamp(((Float)obj).doubleValue());
                }
                if (obj instanceof Double) {
                    return TimestampWritable.doubleToTimestamp((Double)obj);
                }
                if (obj instanceof HiveDecimal) {
                    return TimestampWritable.decimalToTimestamp((HiveDecimal)obj);
                }
                if (obj instanceof HiveDecimalWritable) {
                    return TimestampWritable.decimalToTimestamp(((HiveDecimalWritable)obj).getHiveDecimal());
                }
                if (!(obj instanceof Date)) break;
                return new Timestamp(((Date)obj).getTime());
            }
        }
        throw new IllegalArgumentException(String.format("ORC SARGS could not convert from %s to %s", new Object[]{obj == null ? "(null)" : obj.getClass().getSimpleName(), type}));
    }

    protected boolean[] pickRowGroups() throws IOException {
        if (this.sargApp == null) {
            return null;
        }
        this.readRowIndex(this.currentStripe, this.included, this.sargApp.sargColumns);
        return this.sargApp.pickRowGroups(this.stripes.get(this.currentStripe), this.indexes, this.bloomFilterIndices, false);
    }

    private void clearStreams() throws IOException {
        for (InStream is : this.streams.values()) {
            is.close();
        }
        if (this.bufferChunks != null && this.dataReader.isTrackingDiskRanges()) {
            DiskRangeList range = this.bufferChunks;
            while (range != null) {
                if (range instanceof BufferChunk) {
                    this.dataReader.releaseBuffer(((BufferChunk)range).getChunk());
                }
                range = range.next;
            }
        }
        this.bufferChunks = null;
        this.streams.clear();
    }

    private void readStripe() throws IOException {
        StripeInformation stripe = this.beginReadStripe();
        this.includedRowGroups = this.pickRowGroups();
        if (this.includedRowGroups != null) {
            while (this.rowInStripe < this.rowCountInStripe && !this.includedRowGroups[(int)(this.rowInStripe / this.rowIndexStride)]) {
                this.rowInStripe = Math.min(this.rowCountInStripe, this.rowInStripe + this.rowIndexStride);
            }
        }
        if (this.rowInStripe < this.rowCountInStripe) {
            if (this.included == null && this.includedRowGroups == null) {
                this.readAllDataStreams(stripe);
            } else {
                this.readPartialDataStreams(stripe);
            }
            this.reader.startStripe(this.streams, this.stripeFooter);
            if (this.rowInStripe != 0L) {
                this.seekToRowEntry(this.reader, (int)(this.rowInStripe / this.rowIndexStride));
            }
        }
    }

    private StripeInformation beginReadStripe() throws IOException {
        int i;
        StripeInformation stripe = this.stripes.get(this.currentStripe);
        this.stripeFooter = this.readStripeFooter(stripe);
        this.clearStreams();
        this.rowCountInStripe = stripe.getNumberOfRows();
        this.rowInStripe = 0L;
        this.rowBaseInStripe = 0L;
        for (i = 0; i < this.currentStripe; ++i) {
            this.rowBaseInStripe += this.stripes.get(i).getNumberOfRows();
        }
        for (i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = null;
        }
        return stripe;
    }

    private void readAllDataStreams(StripeInformation stripe) throws IOException {
        long start = stripe.getIndexLength();
        long end = start + stripe.getDataLength();
        DiskRangeList toRead = new DiskRangeList(start, end);
        this.bufferChunks = this.dataReader.readFileData(toRead, stripe.getOffset(), false);
        List<OrcProto.Stream> streamDescriptions = this.stripeFooter.getStreamsList();
        this.createStreams(streamDescriptions, this.bufferChunks, null, this.codec, this.bufferSize, this.streams);
    }

    static DiskRangeList planReadPartialDataStreams(List<OrcProto.Stream> streamList, OrcProto.RowIndex[] indexes, boolean[] includedColumns, boolean[] includedRowGroups, boolean isCompressed, List<OrcProto.ColumnEncoding> encodings, List<OrcProto.Type> types, int compressionSize, boolean doMergeBuffers) {
        long offset = 0L;
        boolean[] hasNull = RecordReaderUtils.findPresentStreamsByColumn(streamList, types);
        DiskRangeList.CreateHelper list = new DiskRangeList.CreateHelper();
        for (OrcProto.Stream stream : streamList) {
            long length = stream.getLength();
            int column = stream.getColumn();
            OrcProto.Stream.Kind streamKind = stream.getKind();
            if (stream.hasKind() && StreamName.getArea(streamKind) == StreamName.Area.DATA && column < includedColumns.length && includedColumns[column]) {
                if (includedRowGroups == null || RecordReaderUtils.isDictionary(streamKind, encodings.get(column))) {
                    RecordReaderUtils.addEntireStreamToRanges(offset, length, list, doMergeBuffers);
                } else {
                    RecordReaderUtils.addRgFilteredStreamToRanges(stream, includedRowGroups, isCompressed, indexes[column], encodings.get(column), types.get(column), compressionSize, hasNull[column], offset, length, list, doMergeBuffers);
                }
            }
            offset += length;
        }
        return list.extract();
    }

    void createStreams(List<OrcProto.Stream> streamDescriptions, DiskRangeList ranges, boolean[] includeColumn, CompressionCodec codec, int bufferSize, Map<StreamName, InStream> streams) throws IOException {
        long streamOffset = 0L;
        for (OrcProto.Stream streamDesc : streamDescriptions) {
            int column = streamDesc.getColumn();
            if (includeColumn != null && column < this.included.length && !includeColumn[column] || streamDesc.hasKind() && StreamName.getArea(streamDesc.getKind()) != StreamName.Area.DATA) {
                streamOffset += streamDesc.getLength();
                continue;
            }
            List<DiskRange> buffers = RecordReaderUtils.getStreamBuffers(ranges, streamOffset, streamDesc.getLength());
            StreamName name = new StreamName(column, streamDesc.getKind());
            streams.put(name, InStream.create(name.toString(), buffers, streamDesc.getLength(), codec, bufferSize));
            streamOffset += streamDesc.getLength();
        }
    }

    private void readPartialDataStreams(StripeInformation stripe) throws IOException {
        List<OrcProto.Stream> streamList = this.stripeFooter.getStreamsList();
        DiskRangeList toRead = RecordReaderImpl.planReadPartialDataStreams(streamList, this.indexes, this.included, this.includedRowGroups, this.codec != null, this.stripeFooter.getColumnsList(), this.types, this.bufferSize, true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("chunks = " + RecordReaderUtils.stringifyDiskRanges(toRead));
        }
        this.bufferChunks = this.dataReader.readFileData(toRead, stripe.getOffset(), false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("merge = " + RecordReaderUtils.stringifyDiskRanges(this.bufferChunks));
        }
        this.createStreams(streamList, this.bufferChunks, this.included, this.codec, this.bufferSize, this.streams);
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.rowInStripe < this.rowCountInStripe;
    }

    private void advanceStripe() throws IOException {
        this.rowInStripe = this.rowCountInStripe;
        while (this.rowInStripe >= this.rowCountInStripe && this.currentStripe < this.stripes.size() - 1) {
            ++this.currentStripe;
            this.readStripe();
        }
    }

    private boolean advanceToNextRow(TreeReaderFactory.TreeReader reader, long nextRow, boolean canAdvanceStripe) throws IOException {
        int rowGroup;
        long nextRowInStripe = nextRow - this.rowBaseInStripe;
        if (this.rowIndexStride != 0L && this.includedRowGroups != null && nextRowInStripe < this.rowCountInStripe && !this.includedRowGroups[rowGroup = (int)(nextRowInStripe / this.rowIndexStride)]) {
            while (rowGroup < this.includedRowGroups.length && !this.includedRowGroups[rowGroup]) {
                ++rowGroup;
            }
            if (rowGroup >= this.includedRowGroups.length) {
                if (canAdvanceStripe) {
                    this.advanceStripe();
                }
                return canAdvanceStripe;
            }
            nextRowInStripe = Math.min(this.rowCountInStripe, (long)rowGroup * this.rowIndexStride);
        }
        if (nextRowInStripe >= this.rowCountInStripe) {
            if (canAdvanceStripe) {
                this.advanceStripe();
            }
            return canAdvanceStripe;
        }
        if (nextRowInStripe != this.rowInStripe) {
            if (this.rowIndexStride != 0L) {
                rowGroup = (int)(nextRowInStripe / this.rowIndexStride);
                this.seekToRowEntry(reader, rowGroup);
                reader.skipRows(nextRowInStripe - (long)rowGroup * this.rowIndexStride);
            } else {
                reader.skipRows(nextRowInStripe - this.rowInStripe);
            }
            this.rowInStripe = nextRowInStripe;
        }
        return true;
    }

    @Override
    public Object next(Object previous) throws IOException {
        try {
            Object result = this.reader.next(previous);
            ++this.rowInStripe;
            this.advanceToNextRow(this.reader, this.rowInStripe + this.rowBaseInStripe, true);
            return result;
        }
        catch (IOException e) {
            throw new IOException("Error reading file: " + this.path, e);
        }
    }

    @Override
    public VectorizedRowBatch nextBatch(VectorizedRowBatch previous) throws IOException {
        try {
            VectorizedRowBatch result;
            if (this.rowInStripe >= this.rowCountInStripe) {
                ++this.currentStripe;
                this.readStripe();
            }
            int batchSize = this.computeBatchSize(1024L);
            this.rowInStripe += (long)batchSize;
            if (previous == null) {
                ColumnVector[] cols = (ColumnVector[])this.reader.nextVector(null, batchSize);
                result = new VectorizedRowBatch(cols.length);
                result.cols = cols;
            } else {
                result = previous;
                result.selectedInUse = false;
                this.reader.setVectorColumnCount(result.getDataColumnCount());
                this.reader.nextVector(result.cols, batchSize);
            }
            result.size = batchSize;
            this.advanceToNextRow(this.reader, this.rowInStripe + this.rowBaseInStripe, true);
            return result;
        }
        catch (IOException e) {
            throw new IOException("Error reading file: " + this.path, e);
        }
    }

    private int computeBatchSize(long targetBatchSize) {
        int batchSize;
        if (this.rowIndexStride != 0L && this.includedRowGroups != null && this.rowInStripe < this.rowCountInStripe) {
            int endRowGroup;
            int startRowGroup = (int)(this.rowInStripe / this.rowIndexStride);
            if (!this.includedRowGroups[startRowGroup]) {
                while (startRowGroup < this.includedRowGroups.length && !this.includedRowGroups[startRowGroup]) {
                    ++startRowGroup;
                }
            }
            for (endRowGroup = startRowGroup; endRowGroup < this.includedRowGroups.length && this.includedRowGroups[endRowGroup]; ++endRowGroup) {
            }
            long markerPosition = (long)endRowGroup * this.rowIndexStride < this.rowCountInStripe ? (long)endRowGroup * this.rowIndexStride : this.rowCountInStripe;
            batchSize = (int)Math.min(targetBatchSize, markerPosition - this.rowInStripe);
            if (isLogDebugEnabled && (long)batchSize < targetBatchSize) {
                LOG.debug("markerPosition: " + markerPosition + " batchSize: " + batchSize);
            }
        } else {
            batchSize = (int)Math.min(targetBatchSize, this.rowCountInStripe - this.rowInStripe);
        }
        return batchSize;
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = Closer.create();){
            closer.register(this.metadata);
            closer.register(this.dataReader);
            this.clearStreams();
        }
    }

    @Override
    public long getRowNumber() {
        return this.rowInStripe + this.rowBaseInStripe + this.firstRow;
    }

    @Override
    public float getProgress() {
        return ((float)this.rowBaseInStripe + (float)this.rowInStripe) / (float)this.totalRowCount;
    }

    MetadataReader getMetadataReader() {
        return this.metadata;
    }

    private int findStripe(long rowNumber) {
        for (int i = 0; i < this.stripes.size(); ++i) {
            StripeInformation stripe = this.stripes.get(i);
            if (stripe.getNumberOfRows() > rowNumber) {
                return i;
            }
            rowNumber -= stripe.getNumberOfRows();
        }
        throw new IllegalArgumentException("Seek after the end of reader range");
    }

    OrcIndex readRowIndex(int stripeIndex, boolean[] included, boolean[] sargColumns) throws IOException {
        return this.readRowIndex(stripeIndex, included, null, null, sargColumns);
    }

    OrcIndex readRowIndex(int stripeIndex, boolean[] included, OrcProto.RowIndex[] indexes, OrcProto.BloomFilterIndex[] bloomFilterIndex, boolean[] sargColumns) throws IOException {
        StripeInformation stripe = this.stripes.get(stripeIndex);
        OrcProto.StripeFooter stripeFooter = null;
        if (stripeIndex == this.currentStripe) {
            stripeFooter = this.stripeFooter;
            indexes = indexes == null ? this.indexes : indexes;
            OrcProto.BloomFilterIndex[] bloomFilterIndexArray = bloomFilterIndex = bloomFilterIndex == null ? this.bloomFilterIndices : bloomFilterIndex;
            sargColumns = sargColumns == null ? (Object)(this.sargApp == null ? null : this.sargApp.sargColumns) : sargColumns;
        }
        return this.metadata.readRowIndex(stripe, stripeFooter, included, indexes, sargColumns, bloomFilterIndex);
    }

    private void seekToRowEntry(TreeReaderFactory.TreeReader reader, int rowEntry) throws IOException {
        PositionProvider[] index = new PositionProvider[this.indexes.length];
        for (int i = 0; i < this.indexes.length; ++i) {
            if (this.indexes[i] == null) continue;
            index[i] = new PositionProviderImpl(this.indexes[i].getEntry(rowEntry));
        }
        reader.seek(index);
    }

    @Override
    public void seekToRow(long rowNumber) throws IOException {
        if (rowNumber < 0L) {
            throw new IllegalArgumentException("Seek to a negative row number " + rowNumber);
        }
        if (rowNumber < this.firstRow) {
            throw new IllegalArgumentException("Seek before reader range " + rowNumber);
        }
        int rightStripe = this.findStripe(rowNumber -= this.firstRow);
        if (rightStripe != this.currentStripe) {
            this.currentStripe = rightStripe;
            this.readStripe();
        }
        this.readRowIndex(this.currentStripe, this.included, this.sargApp == null ? null : this.sargApp.sargColumns);
        this.advanceToNextRow(this.reader, rowNumber, true);
    }

    public static String encodeTranslatedSargColumn(int rootColumn, Integer indexInSourceTable) {
        return rootColumn + TRANSLATED_SARG_SEPARATOR + (indexInSourceTable == null ? -1 : indexInSourceTable);
    }

    public static int[] mapTranslatedSargColumns(List<OrcProto.Type> types, List<PredicateLeaf> sargLeaves) {
        int[] result = new int[sargLeaves.size()];
        OrcProto.Type lastRoot = null;
        String lastRootStr = null;
        for (int i = 0; i < result.length; ++i) {
            String[] rootAndIndex = sargLeaves.get(i).getColumnName().split(TRANSLATED_SARG_SEPARATOR);
            assert (rootAndIndex.length == 2);
            String rootStr = rootAndIndex[0];
            String indexStr = rootAndIndex[1];
            int index = Integer.parseInt(indexStr);
            if (index == -1) {
                result[i] = -1;
                continue;
            }
            assert (index >= 0);
            if (!rootStr.equals(lastRootStr)) {
                lastRoot = types.get(Integer.parseInt(rootStr));
                lastRootStr = rootStr;
            }
            result[i] = lastRoot.getSubtypes(index);
        }
        return result;
    }

    public static class SargApplier {
        public static final boolean[] READ_ALL_RGS = null;
        public static final boolean[] READ_NO_RGS = new boolean[0];
        private final SearchArgument sarg;
        private final List<PredicateLeaf> sargLeaves;
        private final int[] filterColumns;
        private final long rowIndexStride;
        private final boolean[] sargColumns;

        public SargApplier(SearchArgument sarg, String[] columnNames, long rowIndexStride, List<OrcProto.Type> types, int includedCount) {
            this.sarg = sarg;
            this.sargLeaves = sarg.getLeaves();
            this.filterColumns = RecordReaderImpl.mapSargColumnsToOrcInternalColIdx(this.sargLeaves, columnNames, 0);
            this.rowIndexStride = rowIndexStride;
            this.sargColumns = new boolean[includedCount];
            for (int i : this.filterColumns) {
                if (i <= 0) continue;
                this.sargColumns[i] = true;
            }
        }

        public boolean[] pickRowGroups(StripeInformation stripe, OrcProto.RowIndex[] indexes, OrcProto.BloomFilterIndex[] bloomFilterIndices, boolean returnNone) throws IOException {
            long rowsInStripe = stripe.getNumberOfRows();
            int groupsInStripe = (int)((rowsInStripe + this.rowIndexStride - 1L) / this.rowIndexStride);
            boolean[] result = new boolean[groupsInStripe];
            SearchArgument.TruthValue[] leafValues = new SearchArgument.TruthValue[this.sargLeaves.size()];
            boolean hasSelected = false;
            boolean hasSkipped = false;
            for (int rowGroup = 0; rowGroup < result.length; ++rowGroup) {
                for (int pred = 0; pred < leafValues.length; ++pred) {
                    int columnIx = this.filterColumns[pred];
                    if (columnIx != -1) {
                        if (indexes[columnIx] == null) {
                            throw new AssertionError((Object)("Index is not populated for " + columnIx));
                        }
                        OrcProto.RowIndexEntry entry = indexes[columnIx].getEntry(rowGroup);
                        if (entry == null) {
                            throw new AssertionError((Object)("RG is not populated for " + columnIx + " rg " + rowGroup));
                        }
                        OrcProto.ColumnStatistics stats = entry.getStatistics();
                        OrcProto.BloomFilter bf = null;
                        if (bloomFilterIndices != null && bloomFilterIndices[this.filterColumns[pred]] != null) {
                            bf = bloomFilterIndices[this.filterColumns[pred]].getBloomFilter(rowGroup);
                        }
                        leafValues[pred] = RecordReaderImpl.evaluatePredicateProto(stats, this.sargLeaves.get(pred), bf);
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.trace("Stats = " + stats);
                        LOG.trace("Setting " + this.sargLeaves.get(pred) + " to " + (Object)((Object)leafValues[pred]));
                        continue;
                    }
                    leafValues[pred] = SearchArgument.TruthValue.YES_NO_NULL;
                }
                result[rowGroup] = this.sarg.evaluate(leafValues).isNeeded();
                hasSelected = hasSelected || result[rowGroup];
                boolean bl = hasSkipped = hasSkipped || !result[rowGroup];
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Row group " + this.rowIndexStride * (long)rowGroup + " to " + (this.rowIndexStride * (long)(rowGroup + 1) - 1L) + " is " + (result[rowGroup] ? "" : "not ") + "included.");
            }
            return hasSkipped ? (hasSelected || !returnNone ? result : READ_NO_RGS) : READ_ALL_RGS;
        }
    }

    static enum Location {
        BEFORE,
        MIN,
        MIDDLE,
        MAX,
        AFTER;

    }

    public static final class PositionProviderImpl
    implements PositionProvider {
        private final OrcProto.RowIndexEntry entry;
        private int index;

        public PositionProviderImpl(OrcProto.RowIndexEntry entry) {
            this(entry, 0);
        }

        public PositionProviderImpl(OrcProto.RowIndexEntry entry, int startPos) {
            this.entry = entry;
            this.index = startPos;
        }

        @Override
        public long getNext() {
            return this.entry.getPositions(this.index++);
        }
    }

    public static class Builder {
        private Reader.Options options;
        private CompressionCodec codec;
        private List<OrcProto.Type> types;
        private List<StripeInformation> stripes;
        private int bufferSize;
        private FileSystem fileSystem;
        private Path path;
        private Configuration conf;
        private long strideRate;
        private MetadataReaderFactory metadataReaderFactory = new DefaultMetadataReaderFactory();
        private DataReaderFactory dataReaderFactory = new DefaultDataReaderFactory();

        private Builder() {
        }

        public Builder withOptions(Reader.Options options) {
            this.options = options;
            return this;
        }

        public Builder withCodec(CompressionCodec codec) {
            this.codec = codec;
            return this;
        }

        public Builder withTypes(List<OrcProto.Type> types) {
            this.types = types;
            return this;
        }

        public Builder withStripes(List<StripeInformation> stripes) {
            this.stripes = stripes;
            return this;
        }

        public Builder withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder withFileSystem(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        public Builder withPath(Path path) {
            this.path = path;
            return this;
        }

        public Builder withConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder withStrideRate(long strideRate) {
            this.strideRate = strideRate;
            return this;
        }

        public Builder withMetadataReaderFactory(MetadataReaderFactory metadataReaderFactory) {
            this.metadataReaderFactory = metadataReaderFactory;
            return this;
        }

        public Builder withDataReaderFactory(DataReaderFactory dataReaderFactory) {
            this.dataReaderFactory = dataReaderFactory;
            return this;
        }

        public RecordReaderImpl build() throws IOException {
            Preconditions.checkNotNull(this.metadataReaderFactory);
            Preconditions.checkNotNull(this.dataReaderFactory);
            Preconditions.checkNotNull(this.options);
            Preconditions.checkNotNull(this.types);
            Preconditions.checkNotNull(this.stripes);
            Preconditions.checkNotNull(this.fileSystem);
            Preconditions.checkNotNull(this.path);
            Preconditions.checkNotNull(this.conf);
            return new RecordReaderImpl(this);
        }
    }
}

