/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.ColumnarSplit;
import org.apache.hadoop.hive.ql.io.LlapAwareSplit;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.orc.FileMetaInfo;
import org.apache.orc.OrcFile;

public class OrcSplit
extends FileSplit
implements ColumnarSplit,
LlapAwareSplit {
    private FileMetaInfo fileMetaInfo;
    private boolean hasFooter;
    private boolean isOriginal;
    private boolean hasBase;
    private final List<AcidInputFormat.DeltaMetaData> deltas = new ArrayList<AcidInputFormat.DeltaMetaData>();
    private OrcFile.WriterVersion writerVersion;
    private long projColsUncompressedSize;
    private transient Long fileId;
    static final int HAS_FILEID_FLAG = 8;
    static final int BASE_FLAG = 4;
    static final int ORIGINAL_FLAG = 2;
    static final int FOOTER_FLAG = 1;

    protected OrcSplit() {
        super(null, 0L, 0L, (String[])null);
    }

    public OrcSplit(Path path, Long fileId, long offset, long length, String[] hosts, FileMetaInfo fileMetaInfo, boolean isOriginal, boolean hasBase, List<AcidInputFormat.DeltaMetaData> deltas, long projectedDataSize) {
        super(path, offset, length, hosts);
        this.fileId = fileId;
        this.fileMetaInfo = fileMetaInfo;
        this.hasFooter = this.fileMetaInfo != null;
        this.isOriginal = isOriginal;
        this.hasBase = hasBase;
        this.deltas.addAll(deltas);
        this.projColsUncompressedSize = projectedDataSize <= 0L ? length : projectedDataSize;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        int flags = (this.hasBase ? 4 : 0) | (this.isOriginal ? 2 : 0) | (this.hasFooter ? 1 : 0) | (this.fileId != null ? 8 : 0);
        out.writeByte(flags);
        out.writeInt(this.deltas.size());
        for (AcidInputFormat.DeltaMetaData delta : this.deltas) {
            delta.write(out);
        }
        if (this.hasFooter) {
            Text.writeString((DataOutput)out, (String)this.fileMetaInfo.compressionType);
            WritableUtils.writeVInt((DataOutput)out, (int)this.fileMetaInfo.bufferSize);
            WritableUtils.writeVInt((DataOutput)out, (int)this.fileMetaInfo.metadataSize);
            ByteBuffer footerBuff = this.fileMetaInfo.footerBuffer;
            footerBuff.reset();
            WritableUtils.writeVInt((DataOutput)out, (int)(footerBuff.limit() - footerBuff.position()));
            out.write(footerBuff.array(), footerBuff.position(), footerBuff.limit() - footerBuff.position());
            WritableUtils.writeVInt((DataOutput)out, (int)this.fileMetaInfo.writerVersion.getId());
        }
        if (this.fileId != null) {
            out.writeLong(this.fileId);
        }
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        byte flags = in.readByte();
        this.hasFooter = (1 & flags) != 0;
        this.isOriginal = (2 & flags) != 0;
        this.hasBase = (4 & flags) != 0;
        boolean hasFileId = (8 & flags) != 0;
        this.deltas.clear();
        int numDeltas = in.readInt();
        for (int i = 0; i < numDeltas; ++i) {
            AcidInputFormat.DeltaMetaData dmd = new AcidInputFormat.DeltaMetaData();
            dmd.readFields(in);
            this.deltas.add(dmd);
        }
        if (this.hasFooter) {
            String compressionType = Text.readString((DataInput)in);
            int bufferSize = WritableUtils.readVInt((DataInput)in);
            int metadataSize = WritableUtils.readVInt((DataInput)in);
            int footerBuffSize = WritableUtils.readVInt((DataInput)in);
            ByteBuffer footerBuff = ByteBuffer.allocate(footerBuffSize);
            in.readFully(footerBuff.array(), 0, footerBuffSize);
            OrcFile.WriterVersion writerVersion = ReaderImpl.getWriterVersion(WritableUtils.readVInt((DataInput)in));
            this.fileMetaInfo = new FileMetaInfo(compressionType, bufferSize, metadataSize, footerBuff, writerVersion);
        }
        if (hasFileId) {
            this.fileId = in.readLong();
        }
    }

    FileMetaInfo getFileMetaInfo() {
        return this.fileMetaInfo;
    }

    public boolean hasFooter() {
        return this.hasFooter;
    }

    public boolean isOriginal() {
        return this.isOriginal;
    }

    public boolean hasBase() {
        return this.hasBase;
    }

    public List<AcidInputFormat.DeltaMetaData> getDeltas() {
        return this.deltas;
    }

    public boolean isAcid() {
        return this.hasBase || this.deltas.size() > 0;
    }

    public long getProjectedColumnsUncompressedSize() {
        return this.projColsUncompressedSize;
    }

    public Long getFileId() {
        return this.fileId;
    }

    @Override
    public long getColumnarProjectionSize() {
        return this.projColsUncompressedSize;
    }

    @Override
    public boolean canUseLlapIo() {
        return this.isOriginal && (this.deltas == null || this.deltas.isEmpty());
    }

    public String toString() {
        return "OrcSplit [" + this.getPath() + ", start=" + this.getStart() + ", length=" + this.getLength() + ", isOriginal=" + this.isOriginal + ", hasBase=" + this.hasBase + ", deltas=" + (this.deltas == null ? 0 : this.deltas.size()) + "]";
    }
}

