/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.io.Text;

public class VectorUDFDateAddScalarCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private int outputColumn;
    private long longValue = 0L;
    private Timestamp timestampValue = null;
    private byte[] stringValue = null;
    protected boolean isPositive = true;
    private final transient Calendar calendar = Calendar.getInstance();
    private transient SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private final transient Text text = new Text();
    private transient Date baseDate = new Date();

    public VectorUDFDateAddScalarCol() {
    }

    public VectorUDFDateAddScalarCol(Object object, int colNum, int outputColumn) {
        this();
        this.colNum = colNum;
        this.outputColumn = outputColumn;
        if (object instanceof Long) {
            this.longValue = (Long)object;
        } else if (object instanceof Timestamp) {
            this.timestampValue = (Timestamp)object;
        } else if (object instanceof byte[]) {
            this.stringValue = (byte[])object;
        }
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputCol = (LongColumnVector)batch.cols[this.colNum];
        int n = inputCol.isRepeating ? 1 : batch.size;
        int[] sel = batch.selected;
        boolean selectedInUse = !inputCol.isRepeating && batch.selectedInUse;
        BytesColumnVector outV = (BytesColumnVector)batch.cols[this.outputColumn];
        switch (this.inputTypes[0]) {
            case DATE: {
                this.baseDate.setTime(DateWritable.daysToMillis((int)this.longValue));
                break;
            }
            case TIMESTAMP: {
                this.baseDate.setTime(this.timestampValue.getTime());
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                try {
                    this.baseDate = this.formatter.parse(new String(this.stringValue, "UTF-8"));
                    break;
                }
                catch (Exception e) {
                    outV.noNulls = false;
                    if (selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.isNull[i] = true;
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.isNull[i] = true;
                        }
                    }
                    return;
                }
            }
            default: {
                throw new Error("Unsupported input type " + this.inputTypes[0].name());
            }
        }
        if (batch.size == 0) {
            return;
        }
        outV.isRepeating = inputCol.isRepeating;
        if (inputCol.noNulls) {
            outV.noNulls = true;
            if (selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    this.evaluate(this.baseDate, inputCol.vector[i], outV, i);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    this.evaluate(this.baseDate, inputCol.vector[i], outV, i);
                }
            }
        } else {
            outV.noNulls = false;
            if (selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    outV.isNull[i] = inputCol.isNull[i];
                    if (inputCol.isNull[i]) continue;
                    this.evaluate(this.baseDate, inputCol.vector[i], outV, i);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    outV.isNull[i] = inputCol.isNull[i];
                    if (inputCol.isNull[i]) continue;
                    this.evaluate(this.baseDate, inputCol.vector[i], outV, i);
                }
            }
        }
    }

    private void evaluate(Date baseDate, long numDays, BytesColumnVector output, int i) {
        this.calendar.setTime(baseDate);
        if (this.isPositive) {
            this.calendar.add(5, (int)numDays);
        } else {
            this.calendar.add(5, -((int)numDays));
        }
        Date newDate = this.calendar.getTime();
        this.text.set(this.formatter.format(newDate));
        int size = this.text.getLength();
        output.vector[i] = Arrays.copyOf(this.text.getBytes(), size);
        output.start[i] = 0;
        output.length[i] = size;
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "string";
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
    }

    public byte[] getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(byte[] stringValue) {
        this.stringValue = stringValue;
    }

    public boolean isPositive() {
        return this.isPositive;
    }

    public void setPositive(boolean isPositive) {
        this.isPositive = isPositive;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_DATETIME_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

