/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.List;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorAssignRow {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(VectorAssignRow.class);
    Assigner[] assigners;

    private Assigner createAssigner(PrimitiveTypeInfo primitiveTypeInfo, int columnIndex) throws HiveException {
        Assigner assigner;
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
        switch (primitiveCategory) {
            case VOID: {
                assigner = new VoidAssigner(columnIndex);
                break;
            }
            case BOOLEAN: {
                assigner = new BooleanAssigner(columnIndex);
                break;
            }
            case BYTE: {
                assigner = new ByteAssigner(columnIndex);
                break;
            }
            case SHORT: {
                assigner = new ShortAssigner(columnIndex);
                break;
            }
            case INT: {
                assigner = new IntAssigner(columnIndex);
                break;
            }
            case LONG: {
                assigner = new LongAssigner(columnIndex);
                break;
            }
            case TIMESTAMP: {
                assigner = new TimestampAssigner(columnIndex);
                break;
            }
            case DATE: {
                assigner = new DateAssigner(columnIndex);
                break;
            }
            case FLOAT: {
                assigner = new FloatAssigner(columnIndex);
                break;
            }
            case DOUBLE: {
                assigner = new DoubleAssigner(columnIndex);
                break;
            }
            case BINARY: {
                assigner = new BinaryAssigner(columnIndex);
                break;
            }
            case STRING: {
                assigner = new StringAssigner(columnIndex);
                break;
            }
            case VARCHAR: {
                assigner = new VarCharAssigner(columnIndex);
                break;
            }
            case CHAR: {
                assigner = new CharAssigner(columnIndex);
                break;
            }
            case DECIMAL: {
                assigner = new DecimalAssigner(columnIndex);
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                assigner = new IntervalYearMonthAssigner(columnIndex);
                break;
            }
            case INTERVAL_DAY_TIME: {
                assigner = new IntervalDayTimeAssigner(columnIndex);
                break;
            }
            default: {
                throw new HiveException("No vector row assigner for primitive category " + (Object)((Object)primitiveCategory));
            }
        }
        return assigner;
    }

    public void init(StructObjectInspector structObjectInspector, List<Integer> projectedColumns) throws HiveException {
        List<? extends StructField> fields = structObjectInspector.getAllStructFieldRefs();
        this.assigners = new Assigner[fields.size()];
        int i = 0;
        for (StructField structField : fields) {
            int columnIndex = projectedColumns.get(i);
            ObjectInspector fieldInspector = structField.getFieldObjectInspector();
            PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromTypeString(fieldInspector.getTypeName());
            this.assigners[i] = this.createAssigner(primitiveTypeInfo, columnIndex);
            ++i;
        }
    }

    public void init(List<String> typeNames) throws HiveException {
        this.assigners = new Assigner[typeNames.size()];
        int i = 0;
        for (String typeName : typeNames) {
            PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromTypeString(typeName);
            this.assigners[i] = this.createAssigner(primitiveTypeInfo, i);
            ++i;
        }
    }

    protected void setBatch(VectorizedRowBatch batch) throws HiveException {
        for (int i = 0; i < this.assigners.length; ++i) {
            Assigner assigner = this.assigners[i];
            int columnIndex = assigner.getColumnIndex();
            if (batch.cols[columnIndex] == null) {
                throw new HiveException("Unexpected null vector column " + columnIndex);
            }
            assigner.setColumnVector(batch);
        }
    }

    protected void forgetBatch() {
        for (Assigner assigner : this.assigners) {
            assigner.forgetColumnVector();
        }
    }

    public void assignRowColumn(int batchIndex, int logicalColumnIndex, Object object) {
        this.assigners[logicalColumnIndex].assign(batchIndex, object);
    }

    public void assignRow(int batchIndex, Object[] objects) {
        int i = 0;
        for (Assigner assigner : this.assigners) {
            assigner.assign(batchIndex, objects[i++]);
        }
    }

    private class DecimalAssigner
    extends Assigner {
        protected DecimalColumnVector colVector;

        DecimalAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void setColumnVector(VectorizedRowBatch batch) {
            this.colVector = (DecimalColumnVector)batch.cols[this.columnIndex];
        }

        @Override
        void forgetColumnVector() {
            this.colVector = null;
        }

        @Override
        void assign(int batchIndex, Object object) {
            if (object == null) {
                VectorizedBatchUtil.setNullColIsNullValue(this.colVector, batchIndex);
            } else {
                if (object instanceof HiveDecimal) {
                    this.colVector.set(batchIndex, (HiveDecimal)object);
                } else {
                    this.colVector.set(batchIndex, (HiveDecimalWritable)object);
                }
                this.colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class CharAssigner
    extends AbstractBytesAssigner {
        CharAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void assign(int batchIndex, Object object) {
            if (object == null) {
                VectorizedBatchUtil.setNullColIsNullValue(this.colVector, batchIndex);
            } else {
                HiveChar hiveChar = object instanceof HiveChar ? (HiveChar)object : ((HiveCharWritable)object).getHiveChar();
                byte[] bytes = hiveChar.getStrippedValue().getBytes();
                this.colVector.setVal(batchIndex, bytes, 0, bytes.length);
                this.colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class VarCharAssigner
    extends AbstractBytesAssigner {
        VarCharAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void assign(int batchIndex, Object object) {
            if (object == null) {
                VectorizedBatchUtil.setNullColIsNullValue(this.colVector, batchIndex);
            } else {
                HiveVarchar hiveVarchar = object instanceof HiveVarchar ? (HiveVarchar)object : ((HiveVarcharWritable)object).getHiveVarchar();
                byte[] bytes = hiveVarchar.getValue().getBytes();
                this.colVector.setVal(batchIndex, bytes, 0, bytes.length);
                this.colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class StringAssigner
    extends AbstractBytesAssigner {
        StringAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void assign(int batchIndex, Object object) {
            if (object == null) {
                VectorizedBatchUtil.setNullColIsNullValue(this.colVector, batchIndex);
            } else {
                Text tw = (Text)object;
                this.colVector.setVal(batchIndex, tw.getBytes(), 0, tw.getLength());
                this.colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class BinaryAssigner
    extends AbstractBytesAssigner {
        BinaryAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void assign(int batchIndex, Object object) {
            if (object == null) {
                VectorizedBatchUtil.setNullColIsNullValue(this.colVector, batchIndex);
            } else {
                BytesWritable bw = (BytesWritable)object;
                this.colVector.setVal(batchIndex, bw.getBytes(), 0, bw.getLength());
                this.colVector.isNull[batchIndex] = false;
            }
        }
    }

    private abstract class AbstractBytesAssigner
    extends Assigner {
        protected BytesColumnVector colVector;

        AbstractBytesAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void setColumnVector(VectorizedRowBatch batch) {
            this.colVector = (BytesColumnVector)batch.cols[this.columnIndex];
        }

        @Override
        void forgetColumnVector() {
            this.colVector = null;
        }
    }

    private class DoubleAssigner
    extends AbstractDoubleAssigner {
        DoubleAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void assign(int batchIndex, Object object) {
            if (object == null) {
                VectorizedBatchUtil.setNullColIsNullValue(this.colVector, batchIndex);
            } else {
                DoubleWritable dw = (DoubleWritable)((Object)object);
                this.vector[batchIndex] = dw.get();
                this.colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class FloatAssigner
    extends AbstractDoubleAssigner {
        FloatAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void assign(int batchIndex, Object object) {
            if (object == null) {
                VectorizedBatchUtil.setNullColIsNullValue(this.colVector, batchIndex);
            } else {
                FloatWritable fw = (FloatWritable)object;
                this.vector[batchIndex] = fw.get();
                this.colVector.isNull[batchIndex] = false;
            }
        }
    }

    private abstract class AbstractDoubleAssigner
    extends Assigner {
        protected DoubleColumnVector colVector;
        protected double[] vector;

        AbstractDoubleAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void setColumnVector(VectorizedRowBatch batch) {
            this.colVector = (DoubleColumnVector)batch.cols[this.columnIndex];
            this.vector = this.colVector.vector;
        }

        @Override
        void forgetColumnVector() {
            this.colVector = null;
            this.vector = null;
        }
    }

    private class IntervalDayTimeAssigner
    extends AbstractIntervalDayTimeAssigner {
        IntervalDayTimeAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void assign(int batchIndex, Object object) {
            if (object == null) {
                VectorizedBatchUtil.setNullColIsNullValue(this.colVector, batchIndex);
            } else {
                HiveIntervalDayTimeWritable idtw = (HiveIntervalDayTimeWritable)object;
                HiveIntervalDayTime idt = idtw.getHiveIntervalDayTime();
                this.colVector.set(batchIndex, idt);
                this.colVector.isNull[batchIndex] = false;
            }
        }
    }

    private abstract class AbstractIntervalDayTimeAssigner
    extends Assigner {
        protected IntervalDayTimeColumnVector colVector;

        AbstractIntervalDayTimeAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void setColumnVector(VectorizedRowBatch batch) {
            this.colVector = (IntervalDayTimeColumnVector)batch.cols[this.columnIndex];
        }

        @Override
        void forgetColumnVector() {
            this.colVector = null;
        }
    }

    private class IntervalYearMonthAssigner
    extends AbstractLongAssigner {
        IntervalYearMonthAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void assign(int batchIndex, Object object) {
            if (object == null) {
                VectorizedBatchUtil.setNullColIsNullValue(this.colVector, batchIndex);
            } else {
                HiveIntervalYearMonthWritable iymw = (HiveIntervalYearMonthWritable)object;
                HiveIntervalYearMonth iym = iymw.getHiveIntervalYearMonth();
                this.vector[batchIndex] = iym.getTotalMonths();
                this.colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class TimestampAssigner
    extends AbstractTimestampAssigner {
        TimestampAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void assign(int batchIndex, Object object) {
            if (object == null) {
                VectorizedBatchUtil.setNullColIsNullValue(this.colVector, batchIndex);
            } else {
                this.colVector.set(batchIndex, ((TimestampWritable)object).getTimestamp());
                this.colVector.isNull[batchIndex] = false;
            }
        }
    }

    private abstract class AbstractTimestampAssigner
    extends Assigner {
        protected TimestampColumnVector colVector;

        AbstractTimestampAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void setColumnVector(VectorizedRowBatch batch) {
            this.colVector = (TimestampColumnVector)batch.cols[this.columnIndex];
        }

        @Override
        void forgetColumnVector() {
            this.colVector = null;
        }
    }

    private class DateAssigner
    extends AbstractLongAssigner {
        DateAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void assign(int batchIndex, Object object) {
            if (object == null) {
                VectorizedBatchUtil.setNullColIsNullValue(this.colVector, batchIndex);
            } else {
                DateWritable bw = (DateWritable)object;
                this.vector[batchIndex] = bw.getDays();
                this.colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class LongAssigner
    extends AbstractLongAssigner {
        LongAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void assign(int batchIndex, Object object) {
            if (object == null) {
                VectorizedBatchUtil.setNullColIsNullValue(this.colVector, batchIndex);
            } else {
                LongWritable lw = (LongWritable)object;
                this.vector[batchIndex] = lw.get();
                this.colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class IntAssigner
    extends AbstractLongAssigner {
        IntAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void assign(int batchIndex, Object object) {
            if (object == null) {
                VectorizedBatchUtil.setNullColIsNullValue(this.colVector, batchIndex);
            } else {
                IntWritable iw = (IntWritable)object;
                this.vector[batchIndex] = iw.get();
                this.colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class ShortAssigner
    extends AbstractLongAssigner {
        ShortAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void assign(int batchIndex, Object object) {
            if (object == null) {
                VectorizedBatchUtil.setNullColIsNullValue(this.colVector, batchIndex);
            } else {
                ShortWritable sw = (ShortWritable)object;
                this.vector[batchIndex] = sw.get();
                this.colVector.isNull[batchIndex] = false;
            }
        }
    }

    protected class ByteAssigner
    extends AbstractLongAssigner {
        ByteAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void assign(int batchIndex, Object object) {
            if (object == null) {
                VectorizedBatchUtil.setNullColIsNullValue(this.colVector, batchIndex);
            } else {
                ByteWritable bw = (ByteWritable)((Object)object);
                this.vector[batchIndex] = bw.get();
                this.colVector.isNull[batchIndex] = false;
            }
        }
    }

    protected class BooleanAssigner
    extends AbstractLongAssigner {
        BooleanAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void assign(int batchIndex, Object object) {
            if (object == null) {
                VectorizedBatchUtil.setNullColIsNullValue(this.colVector, batchIndex);
            } else {
                BooleanWritable bw = (BooleanWritable)object;
                this.vector[batchIndex] = bw.get() ? 1 : 0;
                this.colVector.isNull[batchIndex] = false;
            }
        }
    }

    private abstract class AbstractLongAssigner
    extends Assigner {
        protected LongColumnVector colVector;
        protected long[] vector;

        AbstractLongAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void setColumnVector(VectorizedRowBatch batch) {
            this.colVector = (LongColumnVector)batch.cols[this.columnIndex];
            this.vector = this.colVector.vector;
        }

        @Override
        void forgetColumnVector() {
            this.colVector = null;
            this.vector = null;
        }
    }

    private class VoidAssigner
    extends Assigner {
        VoidAssigner(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void setColumnVector(VectorizedRowBatch batch) {
        }

        @Override
        void forgetColumnVector() {
        }

        @Override
        void assign(int batchIndex, Object object) {
            assert (object == null);
        }
    }

    protected abstract class Assigner {
        protected int columnIndex;

        Assigner(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        abstract void setColumnVector(VectorizedRowBatch var1);

        abstract void forgetColumnVector();

        abstract void assign(int var1, Object var2);
    }
}

