/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.xml;

import java.io.IOException;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestReusableStringReader {
    private static final String fox = "Quick brown fox jumps over the lazy dog.";

    @Test
    public void testEmpty() throws IOException {
        UDFXPathUtil.ReusableStringReader reader = new UDFXPathUtil.ReusableStringReader();
        try {
            int ch = reader.read();
            Assert.fail((String)"IOException expected.");
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            boolean ready = reader.ready();
            Assert.fail((String)"IOException expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        reader.close();
    }

    @Test
    public void testMarkReset() throws IOException {
        UDFXPathUtil.ReusableStringReader reader = new UDFXPathUtil.ReusableStringReader();
        if (reader.markSupported()) {
            reader.set(fox);
            Assert.assertTrue((boolean)reader.ready());
            char[] cc = new char[6];
            int read = reader.read(cc);
            Assert.assertEquals((long)6L, (long)read);
            Assert.assertEquals((Object)"Quick ", (Object)new String(cc));
            reader.mark(100);
            read = reader.read(cc);
            Assert.assertEquals((long)6L, (long)read);
            Assert.assertEquals((Object)"brown ", (Object)new String(cc));
            reader.reset();
            read = reader.read(cc);
            Assert.assertEquals((long)6L, (long)read);
            Assert.assertEquals((Object)"brown ", (Object)new String(cc));
        }
        reader.close();
    }

    @Test
    public void testSkip() throws IOException {
        UDFXPathUtil.ReusableStringReader reader = new UDFXPathUtil.ReusableStringReader();
        reader.set(fox);
        long skipped = reader.skip(fox.length() + 1);
        Assert.assertEquals((long)fox.length(), (long)skipped);
        Assert.assertEquals((long)-1L, (long)reader.read());
        reader.set(fox);
        char[] cc = new char[6];
        int read = reader.read(cc);
        Assert.assertEquals((long)6L, (long)read);
        Assert.assertEquals((Object)"Quick ", (Object)new String(cc));
        skipped = reader.skip(30L);
        Assert.assertEquals((long)30L, (long)skipped);
        read = reader.read(cc);
        Assert.assertEquals((long)4L, (long)read);
        Assert.assertEquals((Object)"dog.", (Object)new String(cc, 0, read));
        skipped = reader.skip(300L);
        Assert.assertEquals((long)0L, (long)skipped);
        Assert.assertEquals((long)-1L, (long)reader.read());
        reader.close();
    }
}

