/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.nio.ByteBuffer;
import junit.framework.Assert;
import org.apache.hadoop.hive.ql.io.orc.ZlibCodec;
import org.junit.Test;

public class TestZlib {
    @Test
    public void testNoOverflow() throws Exception {
        ByteBuffer in = ByteBuffer.allocate(10);
        ByteBuffer out = ByteBuffer.allocate(10);
        in.put(new byte[]{1, 2, 3, 4, 5, 6, 7, 10});
        in.flip();
        ZlibCodec codec = new ZlibCodec();
        Assert.assertEquals((boolean)false, (boolean)codec.compress(in, out, null));
    }

    @Test
    public void testCorrupt() throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(1000);
        buf.put(new byte[]{127, -128, 0, 99, 98, -1});
        buf.flip();
        ZlibCodec codec = new ZlibCodec();
        ByteBuffer out = ByteBuffer.allocate(1000);
        try {
            codec.decompress(buf, out);
            Assert.fail();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }
}

