/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.MemoryManager;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcRawRecordMerger;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;

public class TestOrcRawRecordMerger {
    private static final Log LOG = LogFactory.getLog(TestOrcRawRecordMerger.class);
    private final MockSettings settings = Mockito.withSettings();
    private final Path tmpDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));

    @Test
    public void testOrdering() throws Exception {
        OrcRawRecordMerger.ReaderKey left = new OrcRawRecordMerger.ReaderKey(100L, 200, 1200L, 300L);
        OrcRawRecordMerger.ReaderKey right = new OrcRawRecordMerger.ReaderKey();
        right.setValues(100L, 200, 1000L, 200L);
        Assert.assertTrue((right.compareTo((RecordIdentifier)left) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((left.compareTo((RecordIdentifier)right) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)false, (Object)left.equals((Object)right));
        left.set((RecordIdentifier)right);
        Assert.assertTrue((right.compareTo((RecordIdentifier)left) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)true, (Object)right.equals((Object)left));
        right.setRowId(2000L);
        Assert.assertTrue((right.compareTo((RecordIdentifier)left) > 0 ? 1 : 0) != 0);
        left.setValues(1L, 2, 3L, 4L);
        right.setValues(100L, 2, 3L, 4L);
        Assert.assertTrue((left.compareTo((RecordIdentifier)right) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((right.compareTo((RecordIdentifier)left) > 0 ? 1 : 0) != 0);
        left.setValues(1L, 2, 3L, 4L);
        right.setValues(1L, 100, 3L, 4L);
        Assert.assertTrue((left.compareTo((RecordIdentifier)right) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((right.compareTo((RecordIdentifier)left) > 0 ? 1 : 0) != 0);
        left.setValues(1L, 2, 3L, 100L);
        right.setValues(1L, 2, 3L, 4L);
        Assert.assertTrue((left.compareTo((RecordIdentifier)right) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((right.compareTo((RecordIdentifier)left) > 0 ? 1 : 0) != 0);
        RecordIdentifier ri = new RecordIdentifier(1L, 2, 3L);
        Assert.assertEquals((long)1L, (long)ri.compareTo((RecordIdentifier)left));
        Assert.assertEquals((long)-1L, (long)left.compareTo(ri));
        Assert.assertEquals((Object)false, (Object)ri.equals((Object)left));
        Assert.assertEquals((Object)false, (Object)left.equals((Object)ri));
    }

    private static void setRow(OrcStruct event, int operation, long originalTransaction, int bucket, long rowId, long currentTransaction, String value) {
        event.setFieldValue(0, (Object)new IntWritable(operation));
        event.setFieldValue(1, (Object)new LongWritable(originalTransaction));
        event.setFieldValue(2, (Object)new IntWritable(bucket));
        event.setFieldValue(3, (Object)new LongWritable(rowId));
        event.setFieldValue(4, (Object)new LongWritable(currentTransaction));
        OrcStruct row = new OrcStruct(1);
        row.setFieldValue(0, (Object)new Text(value));
        event.setFieldValue(5, (Object)row);
    }

    private static String value(OrcStruct event) {
        return OrcRecordUpdater.getRow((OrcStruct)event).getFieldValue(0).toString();
    }

    private List<StripeInformation> createStripes(long ... rowCounts) {
        long offset = 0L;
        ArrayList<StripeInformation> result = new ArrayList<StripeInformation>(rowCounts.length);
        for (long count : rowCounts) {
            OrcProto.StripeInformation.Builder stripe = OrcProto.StripeInformation.newBuilder();
            stripe.setDataLength(800L).setIndexLength(100L).setFooterLength(100L).setNumberOfRows(count).setOffset(offset);
            offset += 1000L;
            result.add((StripeInformation)new ReaderImpl.StripeInformationImpl(stripe.build()));
        }
        return result;
    }

    private Reader createMockReader() throws IOException {
        Reader reader = (Reader)Mockito.mock(Reader.class, (MockSettings)this.settings);
        RecordReader recordReader = (RecordReader)Mockito.mock(RecordReader.class, (MockSettings)this.settings);
        OrcStruct row1 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row1, 0, 10L, 20, 20L, 100L, "first");
        OrcStruct row2 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row2, 0, 10L, 20, 30L, 110L, "second");
        OrcStruct row3 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row3, 0, 10L, 20, 40L, 120L, "third");
        OrcStruct row4 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row4, 0, 40L, 50, 60L, 130L, "fourth");
        OrcStruct row5 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row5, 0, 40L, 50, 61L, 140L, "fifth");
        Mockito.when((Object)reader.rowsOptions((Reader.Options)Mockito.any(Reader.Options.class))).thenReturn((Object)recordReader);
        Mockito.when((Object)recordReader.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, true, true, false});
        Mockito.when((Object)Float.valueOf(recordReader.getProgress())).thenReturn((Object)Float.valueOf(1.0f));
        Mockito.when((Object)recordReader.next(null)).thenReturn((Object)row1);
        Mockito.when((Object)recordReader.next((Object)row1)).thenReturn((Object)row2);
        Mockito.when((Object)recordReader.next((Object)row2)).thenReturn((Object)row3);
        Mockito.when((Object)recordReader.next((Object)row3)).thenReturn((Object)row4);
        Mockito.when((Object)recordReader.next((Object)row4)).thenReturn((Object)row5);
        return reader;
    }

    @Test
    public void testReaderPair() throws Exception {
        OrcRawRecordMerger.ReaderKey key = new OrcRawRecordMerger.ReaderKey();
        Reader reader = this.createMockReader();
        RecordIdentifier minKey = new RecordIdentifier(10L, 20, 30L);
        RecordIdentifier maxKey = new RecordIdentifier(40L, 50, 60L);
        OrcRawRecordMerger.ReaderPair pair = new OrcRawRecordMerger.ReaderPair(key, reader, 20, minKey, maxKey, new Reader.Options());
        RecordReader recordReader = pair.recordReader;
        Assert.assertEquals((long)10L, (long)key.getTransactionId());
        Assert.assertEquals((long)20L, (long)key.getBucketId());
        Assert.assertEquals((long)40L, (long)key.getRowId());
        Assert.assertEquals((long)120L, (long)key.getCurrentTransactionId());
        Assert.assertEquals((Object)"third", (Object)TestOrcRawRecordMerger.value(pair.nextRecord));
        pair.next(pair.nextRecord);
        Assert.assertEquals((long)40L, (long)key.getTransactionId());
        Assert.assertEquals((long)50L, (long)key.getBucketId());
        Assert.assertEquals((long)60L, (long)key.getRowId());
        Assert.assertEquals((long)130L, (long)key.getCurrentTransactionId());
        Assert.assertEquals((Object)"fourth", (Object)TestOrcRawRecordMerger.value(pair.nextRecord));
        pair.next(pair.nextRecord);
        Assert.assertEquals(null, (Object)pair.nextRecord);
        ((RecordReader)Mockito.verify((Object)recordReader)).close();
    }

    @Test
    public void testReaderPairNoMin() throws Exception {
        OrcRawRecordMerger.ReaderKey key = new OrcRawRecordMerger.ReaderKey();
        Reader reader = this.createMockReader();
        OrcRawRecordMerger.ReaderPair pair = new OrcRawRecordMerger.ReaderPair(key, reader, 20, null, null, new Reader.Options());
        RecordReader recordReader = pair.recordReader;
        Assert.assertEquals((long)10L, (long)key.getTransactionId());
        Assert.assertEquals((long)20L, (long)key.getBucketId());
        Assert.assertEquals((long)20L, (long)key.getRowId());
        Assert.assertEquals((long)100L, (long)key.getCurrentTransactionId());
        Assert.assertEquals((Object)"first", (Object)TestOrcRawRecordMerger.value(pair.nextRecord));
        pair.next(pair.nextRecord);
        Assert.assertEquals((long)10L, (long)key.getTransactionId());
        Assert.assertEquals((long)20L, (long)key.getBucketId());
        Assert.assertEquals((long)30L, (long)key.getRowId());
        Assert.assertEquals((long)110L, (long)key.getCurrentTransactionId());
        Assert.assertEquals((Object)"second", (Object)TestOrcRawRecordMerger.value(pair.nextRecord));
        pair.next(pair.nextRecord);
        Assert.assertEquals((long)10L, (long)key.getTransactionId());
        Assert.assertEquals((long)20L, (long)key.getBucketId());
        Assert.assertEquals((long)40L, (long)key.getRowId());
        Assert.assertEquals((long)120L, (long)key.getCurrentTransactionId());
        Assert.assertEquals((Object)"third", (Object)TestOrcRawRecordMerger.value(pair.nextRecord));
        pair.next(pair.nextRecord);
        Assert.assertEquals((long)40L, (long)key.getTransactionId());
        Assert.assertEquals((long)50L, (long)key.getBucketId());
        Assert.assertEquals((long)60L, (long)key.getRowId());
        Assert.assertEquals((long)130L, (long)key.getCurrentTransactionId());
        Assert.assertEquals((Object)"fourth", (Object)TestOrcRawRecordMerger.value(pair.nextRecord));
        pair.next(pair.nextRecord);
        Assert.assertEquals((long)40L, (long)key.getTransactionId());
        Assert.assertEquals((long)50L, (long)key.getBucketId());
        Assert.assertEquals((long)61L, (long)key.getRowId());
        Assert.assertEquals((long)140L, (long)key.getCurrentTransactionId());
        Assert.assertEquals((Object)"fifth", (Object)TestOrcRawRecordMerger.value(pair.nextRecord));
        pair.next(pair.nextRecord);
        Assert.assertEquals(null, (Object)pair.nextRecord);
        ((RecordReader)Mockito.verify((Object)recordReader)).close();
    }

    private static OrcStruct createOriginalRow(String value) {
        OrcStruct result = new OrcStruct(1);
        result.setFieldValue(0, (Object)new Text(value));
        return result;
    }

    private Reader createMockOriginalReader() throws IOException {
        Reader reader = (Reader)Mockito.mock(Reader.class, (MockSettings)this.settings);
        RecordReader recordReader = (RecordReader)Mockito.mock(RecordReader.class, (MockSettings)this.settings);
        OrcStruct row1 = TestOrcRawRecordMerger.createOriginalRow("first");
        OrcStruct row2 = TestOrcRawRecordMerger.createOriginalRow("second");
        OrcStruct row3 = TestOrcRawRecordMerger.createOriginalRow("third");
        OrcStruct row4 = TestOrcRawRecordMerger.createOriginalRow("fourth");
        OrcStruct row5 = TestOrcRawRecordMerger.createOriginalRow("fifth");
        Mockito.when((Object)reader.rowsOptions((Reader.Options)Mockito.any(Reader.Options.class))).thenReturn((Object)recordReader);
        Mockito.when((Object)recordReader.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, true, true, false});
        Mockito.when((Object)recordReader.getRowNumber()).thenReturn((Object)0L, (Object[])new Long[]{1L, 2L, 3L, 4L});
        Mockito.when((Object)recordReader.next(null)).thenReturn((Object)row1);
        Mockito.when((Object)recordReader.next((Object)row1)).thenReturn((Object)row2);
        Mockito.when((Object)recordReader.next((Object)row2)).thenReturn((Object)row3);
        Mockito.when((Object)recordReader.next((Object)row3)).thenReturn((Object)row4);
        Mockito.when((Object)recordReader.next((Object)row4)).thenReturn((Object)row5);
        return reader;
    }

    @Test
    public void testOriginalReaderPair() throws Exception {
        OrcRawRecordMerger.ReaderKey key = new OrcRawRecordMerger.ReaderKey();
        Reader reader = this.createMockOriginalReader();
        RecordIdentifier minKey = new RecordIdentifier(0L, 10, 1L);
        RecordIdentifier maxKey = new RecordIdentifier(0L, 10, 3L);
        boolean[] includes = new boolean[]{true, true};
        OrcRawRecordMerger.OriginalReaderPair pair = new OrcRawRecordMerger.OriginalReaderPair(key, reader, 10, minKey, maxKey, new Reader.Options().include(includes));
        RecordReader recordReader = pair.recordReader;
        Assert.assertEquals((long)0L, (long)key.getTransactionId());
        Assert.assertEquals((long)10L, (long)key.getBucketId());
        Assert.assertEquals((long)2L, (long)key.getRowId());
        Assert.assertEquals((long)0L, (long)key.getCurrentTransactionId());
        Assert.assertEquals((Object)"third", (Object)TestOrcRawRecordMerger.value(pair.nextRecord));
        pair.next(pair.nextRecord);
        Assert.assertEquals((long)0L, (long)key.getTransactionId());
        Assert.assertEquals((long)10L, (long)key.getBucketId());
        Assert.assertEquals((long)3L, (long)key.getRowId());
        Assert.assertEquals((long)0L, (long)key.getCurrentTransactionId());
        Assert.assertEquals((Object)"fourth", (Object)TestOrcRawRecordMerger.value(pair.nextRecord));
        pair.next(pair.nextRecord);
        Assert.assertEquals(null, (Object)pair.nextRecord);
        ((RecordReader)Mockito.verify((Object)recordReader)).close();
    }

    private static ValidTxnList createMaximalTxnList() {
        return new ValidReadTxnList("9223372036854775807:");
    }

    @Test
    public void testOriginalReaderPairNoMin() throws Exception {
        OrcRawRecordMerger.ReaderKey key = new OrcRawRecordMerger.ReaderKey();
        Reader reader = this.createMockOriginalReader();
        OrcRawRecordMerger.OriginalReaderPair pair = new OrcRawRecordMerger.OriginalReaderPair(key, reader, 10, null, null, new Reader.Options());
        Assert.assertEquals((Object)"first", (Object)TestOrcRawRecordMerger.value(pair.nextRecord));
        Assert.assertEquals((long)0L, (long)key.getTransactionId());
        Assert.assertEquals((long)10L, (long)key.getBucketId());
        Assert.assertEquals((long)0L, (long)key.getRowId());
        Assert.assertEquals((long)0L, (long)key.getCurrentTransactionId());
        pair.next(pair.nextRecord);
        Assert.assertEquals((Object)"second", (Object)TestOrcRawRecordMerger.value(pair.nextRecord));
        Assert.assertEquals((long)0L, (long)key.getTransactionId());
        Assert.assertEquals((long)10L, (long)key.getBucketId());
        Assert.assertEquals((long)1L, (long)key.getRowId());
        Assert.assertEquals((long)0L, (long)key.getCurrentTransactionId());
        pair.next(pair.nextRecord);
        Assert.assertEquals((Object)"third", (Object)TestOrcRawRecordMerger.value(pair.nextRecord));
        Assert.assertEquals((long)0L, (long)key.getTransactionId());
        Assert.assertEquals((long)10L, (long)key.getBucketId());
        Assert.assertEquals((long)2L, (long)key.getRowId());
        Assert.assertEquals((long)0L, (long)key.getCurrentTransactionId());
        pair.next(pair.nextRecord);
        Assert.assertEquals((Object)"fourth", (Object)TestOrcRawRecordMerger.value(pair.nextRecord));
        Assert.assertEquals((long)0L, (long)key.getTransactionId());
        Assert.assertEquals((long)10L, (long)key.getBucketId());
        Assert.assertEquals((long)3L, (long)key.getRowId());
        Assert.assertEquals((long)0L, (long)key.getCurrentTransactionId());
        pair.next(pair.nextRecord);
        Assert.assertEquals((Object)"fifth", (Object)TestOrcRawRecordMerger.value(pair.nextRecord));
        Assert.assertEquals((long)0L, (long)key.getTransactionId());
        Assert.assertEquals((long)10L, (long)key.getBucketId());
        Assert.assertEquals((long)4L, (long)key.getRowId());
        Assert.assertEquals((long)0L, (long)key.getCurrentTransactionId());
        pair.next(pair.nextRecord);
        Assert.assertEquals(null, (Object)pair.nextRecord);
        ((RecordReader)Mockito.verify((Object)pair.recordReader)).close();
    }

    @Test
    public void testNewBase() throws Exception {
        Configuration conf = new Configuration();
        conf.set("columns", "col1");
        conf.set("columns.types", "string");
        Reader reader = (Reader)Mockito.mock(Reader.class, (MockSettings)this.settings);
        RecordReader recordReader = (RecordReader)Mockito.mock(RecordReader.class, (MockSettings)this.settings);
        ArrayList<OrcProto.Type> types = new ArrayList<OrcProto.Type>();
        OrcProto.Type.Builder typeBuilder = OrcProto.Type.newBuilder();
        typeBuilder.setKind(OrcProto.Type.Kind.STRUCT).addSubtypes(1).addSubtypes(2).addSubtypes(3).addSubtypes(4).addSubtypes(5).addSubtypes(6);
        types.add(typeBuilder.build());
        types.add(null);
        types.add(null);
        types.add(null);
        types.add(null);
        types.add(null);
        typeBuilder.clearSubtypes();
        typeBuilder.addSubtypes(7);
        types.add(typeBuilder.build());
        Mockito.when((Object)reader.getTypes()).thenReturn(types);
        Mockito.when((Object)reader.rowsOptions((Reader.Options)Mockito.any(Reader.Options.class))).thenReturn((Object)recordReader);
        OrcStruct row1 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row1, 0, 10L, 20, 20L, 100L, "first");
        OrcStruct row2 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row2, 0, 10L, 20, 30L, 110L, "second");
        OrcStruct row3 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row3, 0, 10L, 20, 40L, 120L, "third");
        OrcStruct row4 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row4, 0, 40L, 50, 60L, 130L, "fourth");
        OrcStruct row5 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row5, 0, 40L, 50, 61L, 140L, "fifth");
        Mockito.when((Object)recordReader.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, true, true, false});
        Mockito.when((Object)Float.valueOf(recordReader.getProgress())).thenReturn((Object)Float.valueOf(1.0f));
        Mockito.when((Object)recordReader.next(null)).thenReturn((Object)row1, new Object[]{row4});
        Mockito.when((Object)recordReader.next((Object)row1)).thenReturn((Object)row2);
        Mockito.when((Object)recordReader.next((Object)row2)).thenReturn((Object)row3);
        Mockito.when((Object)recordReader.next((Object)row3)).thenReturn((Object)row5);
        Mockito.when((Object)reader.getMetadataValue("hive.acid.key.index")).thenReturn((Object)ByteBuffer.wrap("10,20,30;40,50,60;40,50,61".getBytes("UTF-8")));
        Mockito.when((Object)reader.getStripes()).thenReturn(this.createStripes(2L, 2L, 1L));
        OrcRawRecordMerger merger = new OrcRawRecordMerger(conf, false, reader, false, 10, TestOrcRawRecordMerger.createMaximalTxnList(), new Reader.Options().range(1000L, 1000L), null);
        RecordReader rr = merger.getCurrentReader().recordReader;
        Assert.assertEquals((long)0L, (long)merger.getOtherReaders().size());
        Assert.assertEquals((Object)new RecordIdentifier(10L, 20, 30L), (Object)merger.getMinKey());
        Assert.assertEquals((Object)new RecordIdentifier(40L, 50, 60L), (Object)merger.getMaxKey());
        RecordIdentifier id = merger.createKey();
        OrcStruct event = merger.createValue();
        Assert.assertEquals((Object)true, (Object)merger.next(id, event));
        Assert.assertEquals((long)10L, (long)id.getTransactionId());
        Assert.assertEquals((long)20L, (long)id.getBucketId());
        Assert.assertEquals((long)40L, (long)id.getRowId());
        Assert.assertEquals((Object)"third", (Object)TestOrcRawRecordMerger.getValue(event));
        Assert.assertEquals((Object)true, (Object)merger.next(id, event));
        Assert.assertEquals((long)40L, (long)id.getTransactionId());
        Assert.assertEquals((long)50L, (long)id.getBucketId());
        Assert.assertEquals((long)60L, (long)id.getRowId());
        Assert.assertEquals((Object)"fourth", (Object)TestOrcRawRecordMerger.getValue(event));
        Assert.assertEquals((Object)false, (Object)merger.next(id, event));
        Assert.assertEquals((double)1.0, (double)merger.getProgress(), (double)0.01);
        merger.close();
        ((RecordReader)Mockito.verify((Object)rr)).close();
        ((RecordReader)Mockito.verify((Object)rr)).getProgress();
        StructObjectInspector eventObjectInspector = (StructObjectInspector)merger.getObjectInspector();
        List fields = eventObjectInspector.getAllStructFieldRefs();
        Assert.assertEquals((long)6L, (long)fields.size());
        Assert.assertEquals((Object)"operation", (Object)((StructField)fields.get(0)).getFieldName());
        Assert.assertEquals((Object)"currentTransaction", (Object)((StructField)fields.get(4)).getFieldName());
        Assert.assertEquals((Object)"originalTransaction", (Object)((StructField)fields.get(1)).getFieldName());
        Assert.assertEquals((Object)"bucket", (Object)((StructField)fields.get(2)).getFieldName());
        Assert.assertEquals((Object)"rowId", (Object)((StructField)fields.get(3)).getFieldName());
        StructObjectInspector rowObjectInspector = (StructObjectInspector)((StructField)fields.get(5)).getFieldObjectInspector();
        Assert.assertEquals((Object)"col1", (Object)((StructField)rowObjectInspector.getAllStructFieldRefs().get(0)).getFieldName());
    }

    static String getValue(OrcStruct event) {
        return OrcRecordUpdater.getRow((OrcStruct)event).getFieldValue(0).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmpty() throws Exception {
        boolean BUCKET = false;
        Configuration conf = new Configuration();
        OrcOutputFormat of = new OrcOutputFormat();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path root = new Path(this.tmpDir, "testEmpty").makeQualified((FileSystem)fs);
        fs.delete(root, true);
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).inspector(inspector).bucket(0).writingBase(true).maximumTransactionId(100L);
            of.getRecordUpdater(root, options).close(false);
            ValidReadTxnList txnList = new ValidReadTxnList("200:");
            AcidUtils.Directory directory = AcidUtils.getAcidState((Path)root, (Configuration)conf, (ValidTxnList)txnList);
            Path basePath = AcidUtils.createBucketFile((Path)directory.getBaseDirectory(), (int)0);
            Reader baseReader = OrcFile.createReader((Path)basePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
            OrcRawRecordMerger merger = new OrcRawRecordMerger(conf, true, baseReader, false, 0, TestOrcRawRecordMerger.createMaximalTxnList(), new Reader.Options(), AcidUtils.getPaths((List)directory.getCurrentDirectories()));
            RecordIdentifier key = merger.createKey();
            OrcStruct value = merger.createValue();
            Assert.assertEquals((Object)false, (Object)merger.next(key, value));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNewBaseAndDelta() throws Exception {
        int BUCKET = 10;
        String[] values = new String[]{"first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "ninth", "tenth"};
        Configuration conf = new Configuration();
        OrcOutputFormat of = new OrcOutputFormat();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path root = new Path(this.tmpDir, "testNewBaseAndDelta").makeQualified((FileSystem)fs);
        fs.delete(root, true);
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var8_7] (shouldn't be in output)
            AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).inspector(inspector).bucket(10);
            RecordUpdater ru = of.getRecordUpdater(root, options.writingBase(true).maximumTransactionId(100L));
            for (String v : values) {
                ru.insert(0L, (Object)new MyRow(v));
            }
            ru.close(false);
            ru = of.getRecordUpdater(root, options.writingBase(false).minimumTransactionId(200L).maximumTransactionId(200L).recordIdColumn(1));
            ru.update(200L, (Object)new MyRow("update 1", 0L, 0L, 10));
            ru.update(200L, (Object)new MyRow("update 2", 2L, 0L, 10));
            ru.update(200L, (Object)new MyRow("update 3", 3L, 0L, 10));
            ru.delete(200L, (Object)new MyRow("", 7L, 0L, 10));
            ru.delete(200L, (Object)new MyRow("", 8L, 0L, 10));
            ru.close(false);
            ValidReadTxnList txnList = new ValidReadTxnList("200:");
            AcidUtils.Directory directory = AcidUtils.getAcidState((Path)root, (Configuration)conf, (ValidTxnList)txnList);
            Assert.assertEquals((Object)new Path(root, "base_0000100"), (Object)directory.getBaseDirectory());
            Assert.assertEquals((Object)new Path(root, "delta_0000200_0000200"), (Object)((AcidUtils.ParsedDelta)directory.getCurrentDirectories().get(0)).getPath());
            Path basePath = AcidUtils.createBucketFile((Path)directory.getBaseDirectory(), (int)10);
            Reader baseReader = OrcFile.createReader((Path)basePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
            OrcRawRecordMerger merger = new OrcRawRecordMerger(conf, true, baseReader, false, 10, TestOrcRawRecordMerger.createMaximalTxnList(), new Reader.Options(), AcidUtils.getPaths((List)directory.getCurrentDirectories()));
            Assert.assertEquals(null, (Object)merger.getMinKey());
            Assert.assertEquals(null, (Object)merger.getMaxKey());
            RecordIdentifier id = merger.createKey();
            OrcStruct event = merger.createValue();
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)1L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 0L, 200L), (Object)id);
            Assert.assertEquals((Object)"update 1", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertFalse((boolean)merger.isDelete(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 1L, 0L), (Object)id);
            Assert.assertEquals((Object)"second", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertFalse((boolean)merger.isDelete(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)1L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 2L, 200L), (Object)id);
            Assert.assertEquals((Object)"update 2", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)1L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 3L, 200L), (Object)id);
            Assert.assertEquals((Object)"update 3", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 4L, 0L), (Object)id);
            Assert.assertEquals((Object)"fifth", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 5L, 0L), (Object)id);
            Assert.assertEquals((Object)"sixth", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 6L, 0L), (Object)id);
            Assert.assertEquals((Object)"seventh", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 7L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertTrue((boolean)merger.isDelete(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 8L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 9L, 0L), (Object)id);
            Assert.assertEquals((Object)"tenth", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)false, (Object)merger.next(id, event));
            merger.close();
            merger = new OrcRawRecordMerger(conf, false, baseReader, false, 10, TestOrcRawRecordMerger.createMaximalTxnList(), new Reader.Options(), AcidUtils.getPaths((List)directory.getCurrentDirectories()));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)1L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 0L, 200L), (Object)id);
            Assert.assertEquals((Object)"update 1", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 0L, 0L), (Object)id);
            Assert.assertEquals((Object)"first", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 1L, 0L), (Object)id);
            Assert.assertEquals((Object)"second", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)1L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 2L, 200L), (Object)id);
            Assert.assertEquals((Object)"update 2", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 2L, 0L), (Object)id);
            Assert.assertEquals((Object)"third", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)1L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 3L, 200L), (Object)id);
            Assert.assertEquals((Object)"update 3", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 3L, 0L), (Object)id);
            Assert.assertEquals((Object)"fourth", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 4L, 0L), (Object)id);
            Assert.assertEquals((Object)"fifth", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 5L, 0L), (Object)id);
            Assert.assertEquals((Object)"sixth", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 6L, 0L), (Object)id);
            Assert.assertEquals((Object)"seventh", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 7L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 7L, 0L), (Object)id);
            Assert.assertEquals((Object)"eighth", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 8L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 8L, 0L), (Object)id);
            Assert.assertEquals((Object)"ninth", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, 9L, 0L), (Object)id);
            Assert.assertEquals((Object)"tenth", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)false, (Object)merger.next(id, event));
            merger.close();
            ValidReadTxnList txns = new ValidReadTxnList("2000:200");
            merger = new OrcRawRecordMerger(conf, true, baseReader, false, 10, (ValidTxnList)txns, new Reader.Options(), AcidUtils.getPaths((List)directory.getCurrentDirectories()));
            for (int i = 0; i < values.length; ++i) {
                Assert.assertEquals((Object)true, (Object)merger.next(id, event));
                LOG.info((Object)("id = " + id + "event = " + event));
                Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
                Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, 10, (long)i, 0L), (Object)id);
                Assert.assertEquals((Object)values[i], (Object)TestOrcRawRecordMerger.getValue(event));
            }
            Assert.assertEquals((Object)false, (Object)merger.next(id, event));
            merger.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecordReaderOldBaseAndDelta() throws Exception {
        int BUCKET = 10;
        Configuration conf = new Configuration();
        OrcOutputFormat of = new OrcOutputFormat();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path root = new Path(this.tmpDir, "testOldBaseAndDelta").makeQualified((FileSystem)fs);
        fs.delete(root, true);
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            org.apache.hadoop.mapred.RecordReader rr;
            int i;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(BigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            MemoryManager mgr = new MemoryManager(conf){
                int rowsAddedSinceCheck;
                {
                    this.rowsAddedSinceCheck = 0;
                }

                synchronized void addedRow() throws IOException {
                    if (++this.rowsAddedSinceCheck >= 2) {
                        this.notifyWriters();
                        this.rowsAddedSinceCheck = 0;
                    }
                }
            };
            Writer writer = OrcFile.createWriter((Path)new Path(root, "0000010_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf).inspector(inspector).fileSystem((FileSystem)fs).blockPadding(false).bufferSize(10000).compress(CompressionKind.NONE).stripeSize(1L).memory(mgr).version(OrcFile.Version.V_0_11));
            String[] values = new String[]{"ignore.1", "0.1", "ignore.2", "ignore.3", "2.0", "2.1", "3.0", "ignore.4", "ignore.5", "ignore.6"};
            for (int i2 = 0; i2 < values.length; ++i2) {
                writer.addRow((Object)new BigRow(i2, i2, values[i2], i2, i2));
            }
            writer.close();
            AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).writingBase(false).minimumTransactionId(1L).maximumTransactionId(1L).bucket(10).inspector(inspector).filesystem((FileSystem)fs).recordIdColumn(5);
            RecordUpdater ru = of.getRecordUpdater(root, options);
            values = new String[]{"0.0", null, null, "1.1", null, null, null, "ignore.7"};
            for (i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                ru.update(1L, (Object)new BigRow(i, i, values[i], i, i, i, 0L, 10));
            }
            ru.delete(100L, (Object)new BigRow(9L, 0L, 10));
            ru.close(false);
            options = options.minimumTransactionId(2L).maximumTransactionId(2L);
            ru = of.getRecordUpdater(root, options);
            values = new String[]{null, null, "1.0", null, null, null, null, "3.1"};
            for (i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                ru.update(2L, (Object)new BigRow(i, i, values[i], i, i, i, 0L, 10));
            }
            ru.delete(100L, (Object)new BigRow(8L, 0L, 10));
            ru.close(false);
            OrcInputFormat inf = new OrcInputFormat();
            JobConf job = new JobConf();
            job.set("mapred.min.split.size", "1");
            job.set("mapred.max.split.size", "2");
            job.set("mapred.input.dir", root.toString());
            InputSplit[] splits = inf.getSplits(job, 5);
            Assert.assertEquals((long)5L, (long)splits.length);
            for (int i3 = 0; i3 < 4; ++i3) {
                System.out.println("starting split " + i3);
                rr = inf.getRecordReader(splits[i3], job, Reporter.NULL);
                NullWritable key = (NullWritable)rr.createKey();
                OrcStruct value = (OrcStruct)rr.createValue();
                for (int j = 0; j < 2; ++j) {
                    System.out.println("i = " + i3 + ", j = " + j);
                    Assert.assertEquals((Object)true, (Object)rr.next((Object)key, (Object)value));
                    System.out.println("record = " + value);
                    Assert.assertEquals((Object)(i3 + "." + j), (Object)value.getFieldValue(2).toString());
                }
                Assert.assertEquals((Object)false, (Object)rr.next((Object)key, (Object)value));
            }
            rr = inf.getRecordReader(splits[4], job, Reporter.NULL);
            Assert.assertEquals((Object)false, (Object)rr.next(rr.createKey(), rr.createValue()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecordReaderNewBaseAndDelta() throws Exception {
        int BUCKET = 10;
        Configuration conf = new Configuration();
        OrcOutputFormat of = new OrcOutputFormat();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path root = new Path(this.tmpDir, "testRecordReaderNewBaseAndDelta").makeQualified((FileSystem)fs);
        fs.delete(root, true);
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            org.apache.hadoop.mapred.RecordReader rr;
            int i;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(BigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            MemoryManager mgr = new MemoryManager(conf){
                int rowsAddedSinceCheck;
                {
                    this.rowsAddedSinceCheck = 0;
                }

                synchronized void addedRow() throws IOException {
                    if (++this.rowsAddedSinceCheck >= 2) {
                        this.notifyWriters();
                        this.rowsAddedSinceCheck = 0;
                    }
                }
            };
            OrcRecordUpdater.OrcOptions options = (OrcRecordUpdater.OrcOptions)new OrcRecordUpdater.OrcOptions(conf).writingBase(true).minimumTransactionId(0L).maximumTransactionId(0L).bucket(10).inspector(inspector).filesystem((FileSystem)fs);
            options.orcOptions(OrcFile.writerOptions((Configuration)conf).stripeSize(1L).blockPadding(false).compress(CompressionKind.NONE).memory(mgr));
            RecordUpdater ru = of.getRecordUpdater(root, (AcidOutputFormat.Options)options);
            String[] values = new String[]{"ignore.1", "0.1", "ignore.2", "ignore.3", "2.0", "2.1", "3.0", "ignore.4", "ignore.5", "ignore.6"};
            for (i = 0; i < values.length; ++i) {
                ru.insert(0L, (Object)new BigRow(i, i, values[i], i, i));
            }
            ru.close(false);
            options.writingBase(false).minimumTransactionId(1L).maximumTransactionId(1L).recordIdColumn(5);
            ru = of.getRecordUpdater(root, (AcidOutputFormat.Options)options);
            values = new String[]{"0.0", null, null, "1.1", null, null, null, "ignore.7"};
            for (i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                ru.update(1L, (Object)new BigRow(i, i, values[i], i, i, i, 0L, 10));
            }
            ru.delete(100L, (Object)new BigRow(9L, 0L, 10));
            ru.close(false);
            options.minimumTransactionId(2L).maximumTransactionId(2L);
            ru = of.getRecordUpdater(root, (AcidOutputFormat.Options)options);
            values = new String[]{null, null, "1.0", null, null, null, null, "3.1"};
            for (i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                ru.update(2L, (Object)new BigRow(i, i, values[i], i, i, i, 0L, 10));
            }
            ru.delete(100L, (Object)new BigRow(8L, 0L, 10));
            ru.close(false);
            OrcInputFormat inf = new OrcInputFormat();
            JobConf job = new JobConf();
            job.set("mapred.min.split.size", "1");
            job.set("mapred.max.split.size", "2");
            job.set("mapred.input.dir", root.toString());
            InputSplit[] splits = inf.getSplits(job, 5);
            Assert.assertEquals((long)5L, (long)splits.length);
            for (int i2 = 0; i2 < 4; ++i2) {
                System.out.println("starting split " + i2);
                rr = inf.getRecordReader(splits[i2], job, Reporter.NULL);
                NullWritable key = (NullWritable)rr.createKey();
                OrcStruct value = (OrcStruct)rr.createValue();
                for (int j = 0; j < 2; ++j) {
                    System.out.println("i = " + i2 + ", j = " + j);
                    Assert.assertEquals((Object)true, (Object)rr.next((Object)key, (Object)value));
                    System.out.println("record = " + value);
                    Assert.assertEquals((Object)(i2 + "." + j), (Object)value.getFieldValue(2).toString());
                }
                Assert.assertEquals((Object)false, (Object)rr.next((Object)key, (Object)value));
            }
            rr = inf.getRecordReader(splits[4], job, Reporter.NULL);
            Assert.assertEquals((Object)false, (Object)rr.next(rr.createKey(), rr.createValue()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecordReaderDelta() throws Exception {
        boolean BUCKET = false;
        Configuration conf = new Configuration();
        OrcOutputFormat of = new OrcOutputFormat();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path root = new Path(this.tmpDir, "testRecordReaderDelta").makeQualified((FileSystem)fs);
        fs.delete(root, true);
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).bucket(0).inspector(inspector).filesystem((FileSystem)fs).writingBase(false).minimumTransactionId(1L).maximumTransactionId(1L);
            RecordUpdater ru = of.getRecordUpdater(root, options);
            String[] values = new String[]{"a", "b", "c", "d", "e"};
            for (i = 0; i < values.length; ++i) {
                ru.insert(1L, (Object)new MyRow(values[i]));
            }
            ru.close(false);
            options.minimumTransactionId(2L).maximumTransactionId(2L);
            ru = of.getRecordUpdater(root, options);
            values = new String[]{"f", "g", "h", "i", "j"};
            for (i = 0; i < values.length; ++i) {
                ru.insert(2L, (Object)new MyRow(values[i]));
            }
            ru.close(false);
            OrcInputFormat inf = new OrcInputFormat();
            JobConf job = new JobConf();
            job.set("mapred.min.split.size", "1");
            job.set("mapred.max.split.size", "2");
            job.set("mapred.input.dir", root.toString());
            job.set("bucket_count", "1");
            InputSplit[] splits = inf.getSplits(job, 5);
            Assert.assertEquals((long)1L, (long)splits.length);
            org.apache.hadoop.mapred.RecordReader rr = inf.getRecordReader(splits[0], job, Reporter.NULL);
            values = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"};
            OrcStruct row = (OrcStruct)rr.createValue();
            for (int i2 = 0; i2 < values.length; ++i2) {
                System.out.println("Checking " + i2);
                Assert.assertEquals((Object)true, (Object)rr.next((Object)NullWritable.get(), (Object)row));
                Assert.assertEquals((Object)values[i2], (Object)row.getFieldValue(0).toString());
            }
            Assert.assertEquals((Object)false, (Object)rr.next((Object)NullWritable.get(), (Object)row));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecordReaderIncompleteDelta() throws Exception {
        boolean BUCKET = true;
        Configuration conf = new Configuration();
        OrcOutputFormat of = new OrcOutputFormat();
        FileSystem fs = FileSystem.getLocal((Configuration)conf).getRaw();
        Path root = new Path(this.tmpDir, "testRecordReaderIncompleteDelta").makeQualified(fs);
        fs.delete(root, true);
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            int i2;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).writingBase(true).minimumTransactionId(0L).maximumTransactionId(0L).bucket(1).inspector(inspector).filesystem(fs);
            RecordUpdater ru = of.getRecordUpdater(root, options);
            String[] values = new String[]{"1", "2", "3", "4", "5"};
            for (i2 = 0; i2 < values.length; ++i2) {
                ru.insert(0L, (Object)new MyRow(values[i2]));
            }
            ru.close(false);
            options.writingBase(false).minimumTransactionId(10L).maximumTransactionId(19L);
            ru = of.getRecordUpdater(root, options);
            values = new String[]{"6", "7", "8"};
            for (i2 = 0; i2 < values.length; ++i2) {
                ru.insert(1L, (Object)new MyRow(values[i2]));
            }
            OrcInputFormat inf = new OrcInputFormat();
            JobConf job = new JobConf();
            job.set("mapred.input.dir", root.toString());
            job.set("bucket_count", "2");
            InputSplit[] splits = inf.getSplits(job, 1);
            Assert.assertEquals((long)2L, (long)splits.length);
            org.apache.hadoop.mapred.RecordReader rr = inf.getRecordReader(splits[0], job, Reporter.NULL);
            NullWritable key = (NullWritable)rr.createKey();
            OrcStruct value = (OrcStruct)rr.createValue();
            System.out.println("Looking at split " + splits[0]);
            for (i = 1; i < 6; ++i) {
                System.out.println("Checking row " + i);
                Assert.assertEquals((Object)true, (Object)rr.next((Object)key, (Object)value));
                Assert.assertEquals((Object)Integer.toString(i), (Object)value.getFieldValue(0).toString());
            }
            Assert.assertEquals((Object)false, (Object)rr.next((Object)key, (Object)value));
            ru.flush();
            ru.flush();
            values = new String[]{"9", "10"};
            for (i = 0; i < values.length; ++i) {
                ru.insert(3L, (Object)new MyRow(values[i]));
            }
            ru.flush();
            splits = inf.getSplits(job, 1);
            Assert.assertEquals((long)2L, (long)splits.length);
            rr = inf.getRecordReader(splits[0], job, Reporter.NULL);
            Path sideFile = new Path(root + "/delta_0000010_0000019/bucket_00001_flush_length");
            Assert.assertEquals((Object)true, (Object)fs.exists(sideFile));
            Assert.assertEquals((long)24L, (long)fs.getFileStatus(sideFile).getLen());
            for (int i3 = 1; i3 < 11; ++i3) {
                Assert.assertEquals((Object)true, (Object)rr.next((Object)key, (Object)value));
                Assert.assertEquals((Object)Integer.toString(i3), (Object)value.getFieldValue(0).toString());
            }
            Assert.assertEquals((Object)false, (Object)rr.next((Object)key, (Object)value));
            return;
        }
    }

    static class BigRow {
        int myint;
        long mylong;
        Text mytext;
        float myfloat;
        double mydouble;
        RecordIdentifier ROW__ID;

        BigRow(int myint, long mylong, String mytext, float myfloat, double mydouble) {
            this.myint = myint;
            this.mylong = mylong;
            this.mytext = new Text(mytext);
            this.myfloat = myfloat;
            this.mydouble = mydouble;
            this.ROW__ID = null;
        }

        BigRow(int myint, long mylong, String mytext, float myfloat, double mydouble, long rowId, long origTxn, int bucket) {
            this.myint = myint;
            this.mylong = mylong;
            this.mytext = new Text(mytext);
            this.myfloat = myfloat;
            this.mydouble = mydouble;
            this.ROW__ID = new RecordIdentifier(origTxn, bucket, rowId);
        }

        BigRow(long rowId, long origTxn, int bucket) {
            this.ROW__ID = new RecordIdentifier(origTxn, bucket, rowId);
        }
    }

    static class MyRow {
        Text col1;
        RecordIdentifier ROW__ID;

        MyRow(String val) {
            this.col1 = new Text(val);
        }

        MyRow(String val, long rowId, long origTxn, int bucket) {
            this.col1 = new Text(val);
            this.ROW__ID = new RecordIdentifier(origTxn, bucket, rowId);
        }
    }
}

