/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.lang.management.ManagementFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.MemoryManager;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestMemoryManager {
    private static final double ERROR = 1.0E-6;

    @Test
    public void testBasics() throws Exception {
        Configuration conf = new Configuration();
        MemoryManager mgr = new MemoryManager(conf);
        NullCallback callback = new NullCallback();
        long poolSize = mgr.getTotalMemoryPool();
        junit.framework.Assert.assertEquals((long)Math.round((double)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * 0.5), (long)poolSize);
        junit.framework.Assert.assertEquals((double)1.0, (double)mgr.getAllocationScale(), (double)1.0E-5);
        mgr.addWriter(new Path("p1"), 1000L, (MemoryManager.Callback)callback);
        junit.framework.Assert.assertEquals((double)1.0, (double)mgr.getAllocationScale(), (double)1.0E-5);
        mgr.addWriter(new Path("p1"), poolSize / 2L, (MemoryManager.Callback)callback);
        junit.framework.Assert.assertEquals((double)1.0, (double)mgr.getAllocationScale(), (double)1.0E-5);
        mgr.addWriter(new Path("p2"), poolSize / 2L, (MemoryManager.Callback)callback);
        junit.framework.Assert.assertEquals((double)1.0, (double)mgr.getAllocationScale(), (double)1.0E-5);
        mgr.addWriter(new Path("p3"), poolSize / 2L, (MemoryManager.Callback)callback);
        junit.framework.Assert.assertEquals((double)0.6666667, (double)mgr.getAllocationScale(), (double)1.0E-5);
        mgr.addWriter(new Path("p4"), poolSize / 2L, (MemoryManager.Callback)callback);
        junit.framework.Assert.assertEquals((double)0.5, (double)mgr.getAllocationScale(), (double)1.0E-6);
        mgr.addWriter(new Path("p4"), 3L * poolSize / 2L, (MemoryManager.Callback)callback);
        junit.framework.Assert.assertEquals((double)0.3333333, (double)mgr.getAllocationScale(), (double)1.0E-6);
        mgr.removeWriter(new Path("p1"));
        mgr.removeWriter(new Path("p2"));
        junit.framework.Assert.assertEquals((double)0.5, (double)mgr.getAllocationScale(), (double)1.0E-5);
        mgr.removeWriter(new Path("p4"));
        junit.framework.Assert.assertEquals((double)1.0, (double)mgr.getAllocationScale(), (double)1.0E-5);
    }

    @Test
    public void testConfig() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hive.exec.orc.memory.pool", "0.9");
        MemoryManager mgr = new MemoryManager(conf);
        long mem = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
        System.err.print("Memory = " + mem);
        long pool = mgr.getTotalMemoryPool();
        Assert.assertTrue((String)("Pool too small: " + pool), ((double)mem * 0.899 < (double)pool ? 1 : 0) != 0);
        Assert.assertTrue((String)("Pool too big: " + pool), ((double)pool < (double)mem * 0.901 ? 1 : 0) != 0);
    }

    private static DoubleMatcher closeTo(double value, double error) {
        return new DoubleMatcher(value, error);
    }

    @Test
    public void testCallback() throws Exception {
        int i;
        Configuration conf = new Configuration();
        MemoryManager mgr = new MemoryManager(conf);
        long pool = mgr.getTotalMemoryPool();
        MemoryManager.Callback[] calls = new MemoryManager.Callback[20];
        for (i = 0; i < calls.length; ++i) {
            calls[i] = (MemoryManager.Callback)Mockito.mock(MemoryManager.Callback.class);
            mgr.addWriter(new Path(Integer.toString(i)), pool / 4L, calls[i]);
        }
        for (i = 0; i < 10000; ++i) {
            mgr.addedRow();
        }
        for (int call = 0; call < calls.length; ++call) {
            ((MemoryManager.Callback)Mockito.verify((Object)calls[call], (VerificationMode)Mockito.times((int)2))).checkMemory(Mockito.doubleThat((Matcher)TestMemoryManager.closeTo(0.2, 1.0E-6)));
        }
    }

    private static class DoubleMatcher
    extends BaseMatcher<Double> {
        final double expected;
        final double error;

        DoubleMatcher(double expected, double error) {
            this.expected = expected;
            this.error = error;
        }

        public boolean matches(Object val) {
            double dbl = (Double)val;
            return Math.abs(dbl - this.expected) <= this.error;
        }

        public void describeTo(Description description) {
            description.appendText("not sufficiently close to ");
            description.appendText(Double.toString(this.expected));
        }
    }

    private static class NullCallback
    implements MemoryManager.Callback {
        private NullCallback() {
        }

        public boolean checkMemory(double newScale) {
            return false;
        }
    }
}

