/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestTxnCommands2 {
    private static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestTxnCommands2.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    private static final String TEST_WAREHOUSE_DIR = TEST_DATA_DIR + "/warehouse";
    private static int BUCKET_COUNT = 2;
    @Rule
    public TestName testName = new TestName();
    private HiveConf hiveConf;
    private Driver d;

    @Before
    public void setUp() throws Exception {
        this.tearDown();
        this.hiveConf = new HiveConf(this.getClass());
        this.hiveConf.set(HiveConf.ConfVars.PREEXECHOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.POSTEXECHOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.varname, "false");
        this.hiveConf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, TEST_WAREHOUSE_DIR);
        TxnDbUtil.setConfValues((HiveConf)this.hiveConf);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVEENFORCEBUCKETING, true);
        TxnDbUtil.prepDb();
        File f = new File(TEST_WAREHOUSE_DIR);
        if (f.exists()) {
            FileUtil.fullyDelete((File)f);
        }
        if (!new File(TEST_WAREHOUSE_DIR).mkdirs()) {
            throw new RuntimeException("Could not create " + TEST_WAREHOUSE_DIR);
        }
        SessionState.start((SessionState)new SessionState(this.hiveConf));
        this.d = new Driver(this.hiveConf);
        this.dropTables();
        this.runStatementOnDriver("create table " + (Object)((Object)Table.ACIDTBL) + "(a int, b int) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.ACIDTBLPART) + "(a int, b int) partitioned by (p string) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.NONACIDORCTBL) + "(a int, b int) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.NONACIDPART) + "(a int, b int) partitioned by (p string) stored as orc TBLPROPERTIES ('transactional'='false')");
    }

    private void dropTables() throws Exception {
        for (Table t : Table.values()) {
            this.runStatementOnDriver("drop table if exists " + (Object)((Object)t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws Exception {
        try {
            if (this.d != null) {
                this.dropTables();
                this.d.destroy();
                this.d.close();
                this.d = null;
            }
            TxnDbUtil.cleanDb();
        }
        finally {
            FileUtils.deleteDirectory((File)new File(TEST_DATA_DIR));
        }
    }

    @Ignore(value="not needed but useful for testing")
    @Test
    public void testNonAcidInsert() throws Exception {
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(1,2)");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(2,3)");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
    }

    @Test
    public void testUpdateMixedCase() throws Exception {
        int[][] tableData = new int[][]{{1, 2}, {3, 3}, {5, 3}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBL) + " set B = 7 where A=1");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] updatedData = new int[][]{{1, 7}, {3, 3}, {5, 3}};
        Assert.assertEquals((String)"Update failed", this.stringifyValues(updatedData), rs);
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBL) + " set B = B + 1 where A=1");
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] updatedData2 = new int[][]{{1, 8}, {3, 3}, {5, 3}};
        Assert.assertEquals((String)"Update failed", this.stringifyValues(updatedData2), rs2);
    }

    @Test
    public void testDeleteIn() throws Exception {
        int[][] tableData = new int[][]{{1, 2}, {3, 2}, {5, 2}, {1, 3}, {3, 3}, {5, 3}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(1,7),(3,7)");
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where a in(select a from " + (Object)((Object)Table.NONACIDORCTBL) + ")");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] updatedData = new int[][]{{1, 7}, {3, 7}, {5, 2}, {5, 3}};
        Assert.assertEquals((String)"Bulk update failed", this.stringifyValues(updatedData), rs);
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBL) + " set b=19 where b in(select b from " + (Object)((Object)Table.NONACIDORCTBL) + " where a = 3)");
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] updatedData2 = new int[][]{{1, 19}, {3, 19}, {5, 2}, {5, 3}};
        Assert.assertEquals((String)"Bulk update2 failed", this.stringifyValues(updatedData2), rs2);
    }

    @Test
    public void testBucketizedInputFormat() throws Exception {
        int[][] tableData = new int[][]{{1, 2}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBLPART) + " partition(p=1) (a,b) " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) select a,b from " + (Object)((Object)Table.ACIDTBLPART) + " where p = 1");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL));
        Assert.assertEquals((String)("Insert into " + (Object)((Object)Table.ACIDTBL) + " didn't match:"), this.stringifyValues(tableData), rs);
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) select a,b from " + (Object)((Object)Table.ACIDTBLPART) + " where p = 1");
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        Assert.assertEquals((String)("Insert into " + (Object)((Object)Table.NONACIDORCTBL) + " didn't match:"), this.stringifyValues(tableData), rs2);
    }

    @Test
    public void testInsertOverwriteWithSelfJoin() throws Exception {
        int[][] part1Data = new int[][]{{1, 7}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) " + this.makeValuesClause(part1Data));
        this.runStatementOnDriver("insert overwrite table " + (Object)((Object)Table.NONACIDORCTBL) + " select 2, 9 from " + (Object)((Object)Table.NONACIDORCTBL) + " T inner join " + (Object)((Object)Table.NONACIDORCTBL) + " S on T.a=S.a");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL) + " order by a,b");
        int[][] joinData = new int[][]{{2, 9}};
        Assert.assertEquals((String)"Self join non-part insert overwrite failed", this.stringifyValues(joinData), rs);
        int[][] part2Data = new int[][]{{1, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDPART) + " partition(p=1) (a,b) " + this.makeValuesClause(part1Data));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDPART) + " partition(p=2) (a,b) " + this.makeValuesClause(part2Data));
        this.runStatementOnDriver("insert overwrite table " + (Object)((Object)Table.NONACIDPART) + " partition(p=1) select a,b from " + (Object)((Object)Table.NONACIDPART));
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDPART) + " order by a,b");
        int[][] updatedData = new int[][]{{1, 7}, {1, 8}, {1, 8}};
        Assert.assertEquals((String)"Insert overwrite partition failed", this.stringifyValues(updatedData), rs2);
    }

    private List<String> stringifyValues(int[][] rowsIn) {
        assert (rowsIn.length > 0);
        int[][] rows = (int[][])rowsIn.clone();
        Arrays.sort(rows, new RowComp());
        ArrayList<String> rs = new ArrayList<String>();
        for (int[] row : rows) {
            assert (row.length > 0);
            StringBuilder sb = new StringBuilder();
            for (int value : row) {
                sb.append(value).append("\t");
            }
            sb.setLength(sb.length() - 1);
            rs.add(sb.toString());
        }
        return rs;
    }

    private String makeValuesClause(int[][] rows) {
        assert (rows.length > 0);
        StringBuilder sb = new StringBuilder("values");
        for (int[] row : rows) {
            assert (row.length > 0);
            if (row.length > 1) {
                sb.append("(");
            }
            for (int value : row) {
                sb.append(value).append(",");
            }
            sb.setLength(sb.length() - 1);
            if (row.length > 1) {
                sb.append(")");
            }
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private List<String> runStatementOnDriver(String stmt) throws Exception {
        CommandProcessorResponse cpr = this.d.run(stmt);
        if (cpr.getResponseCode() != 0) {
            throw new RuntimeException(stmt + " failed: " + cpr);
        }
        ArrayList<String> rs = new ArrayList<String>();
        this.d.getResults(rs);
        return rs;
    }

    private static final class RowComp
    implements Comparator<int[]> {
        private RowComp() {
        }

        @Override
        public int compare(int[] row1, int[] row2) {
            assert (row1 != null && row2 != null && row1.length == row2.length);
            for (int i = 0; i < row1.length; ++i) {
                int comp = Integer.compare(row1[i], row2[i]);
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }
    }

    private static enum Table {
        ACIDTBL("acidTbl"),
        ACIDTBLPART("acidTblPart"),
        NONACIDORCTBL("nonAcidOrcTbl"),
        NONACIDPART("nonAcidPart");

        private final String name;

        public String toString() {
            return this.name;
        }

        private Table(String name) {
            this.name = name;
        }
    }
}

