/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SparkClientUtilities {
    protected static final transient Log LOG = LogFactory.getLog(SparkClientUtilities.class);

    public static void addToClassPath(String[] newPaths) throws Exception {
        ClassLoader cloader = Thread.currentThread().getContextClassLoader();
        URLClassLoader loader = (URLClassLoader)cloader;
        ArrayList<URL> curPath = Lists.newArrayList(loader.getURLs());
        for (String newPath : newPaths) {
            URL newUrl = SparkClientUtilities.urlFromPathString(newPath);
            if (newUrl == null || curPath.contains(newUrl)) continue;
            curPath.add(newUrl);
            LOG.info((Object)("Added jar[" + newUrl + "] to classpath."));
        }
        URLClassLoader newLoader = new URLClassLoader(curPath.toArray(new URL[curPath.size()]), (ClassLoader)loader);
        Thread.currentThread().setContextClassLoader(newLoader);
    }

    private static URL urlFromPathString(String path) {
        URL url = null;
        try {
            url = StringUtils.indexOf(path, "file:/") == 0 ? new URL(path) : new File(path).toURL();
        }
        catch (Exception err) {
            LOG.error((Object)("Bad URL " + path + ", ignoring path"));
        }
        return url;
    }
}

