/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

public abstract class GenericUDFBaseTrim
extends GenericUDF {
    private transient PrimitiveObjectInspectorConverter.TextConverter converter;
    private Text result = new Text();
    private String udfName;

    public GenericUDFBaseTrim(String _udfName) {
        this.udfName = _udfName;
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentException(this.udfName + " requires one value argument. Found :" + arguments.length);
        }
        if (!(arguments[0] instanceof PrimitiveObjectInspector)) {
            throw new UDFArgumentException(this.udfName + " takes only primitive types. found " + arguments[0].getTypeName());
        }
        PrimitiveObjectInspector argumentOI = (PrimitiveObjectInspector)arguments[0];
        switch (argumentOI.getPrimitiveCategory()) {
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                break;
            }
            default: {
                throw new UDFArgumentException(this.udfName + " takes only STRING/CHAR/VARCHAR types. Found " + (Object)((Object)argumentOI.getPrimitiveCategory()));
            }
        }
        this.converter = new PrimitiveObjectInspectorConverter.TextConverter(argumentOI);
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object valObject = arguments[0].get();
        if (valObject == null) {
            return null;
        }
        String val = this.converter.convert(valObject).toString();
        if (val == null) {
            return null;
        }
        this.result.set(this.performOp(val.toString()));
        return this.result;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.udfName + "(" + StringUtils.join((Object[])children, ", ") + ")";
    }

    protected abstract String performOp(String var1);
}

