/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.common.util.HiveStringUtils;

@Explain(displayName="Partition")
public class PartitionDesc
implements Serializable,
Cloneable {
    private static final Interner<String> STRING_INTERNER = Interners.newWeakInterner();
    private static final Interner<Class<?>> CLASS_INTERNER = Interners.newWeakInterner();
    private TableDesc tableDesc;
    private LinkedHashMap<String, String> partSpec;
    private Class<? extends InputFormat> inputFileFormatClass;
    private Class<? extends OutputFormat> outputFileFormatClass;
    private Properties properties;
    private String baseFileName;

    public void setBaseFileName(String baseFileName) {
        this.baseFileName = baseFileName;
    }

    public PartitionDesc() {
    }

    public PartitionDesc(TableDesc table, LinkedHashMap<String, String> partSpec) {
        this.tableDesc = table;
        this.partSpec = partSpec;
    }

    public PartitionDesc(Partition part) throws HiveException {
        this.tableDesc = Utilities.getTableDesc(part.getTable());
        this.setProperties(part.getMetadataFromPartitionSchema());
        this.partSpec = part.getSpec();
        this.setInputFileFormatClass(part.getInputFormatClass());
        this.setOutputFileFormatClass(part.getOutputFormatClass());
    }

    public PartitionDesc(Partition part, TableDesc tblDesc) throws HiveException {
        this.tableDesc = tblDesc;
        this.setProperties(part.getSchemaFromTableSchema(tblDesc.getProperties()));
        this.partSpec = part.getSpec();
        this.setOutputFileFormatClass(part.getInputFormatClass());
        this.setOutputFileFormatClass(part.getOutputFormatClass());
    }

    @Explain(displayName="")
    public TableDesc getTableDesc() {
        return this.tableDesc;
    }

    public void setTableDesc(TableDesc tableDesc) {
        this.tableDesc = tableDesc;
    }

    @Explain(displayName="partition values")
    public LinkedHashMap<String, String> getPartSpec() {
        return this.partSpec;
    }

    public void setPartSpec(LinkedHashMap<String, String> partSpec) {
        this.partSpec = partSpec;
    }

    public Class<? extends InputFormat> getInputFileFormatClass() {
        if (this.inputFileFormatClass == null && this.tableDesc != null) {
            this.setInputFileFormatClass(this.tableDesc.getInputFileFormatClass());
        }
        return this.inputFileFormatClass;
    }

    public String getDeserializerClassName() {
        Properties schema = this.getProperties();
        String clazzName = schema.getProperty("serialization.lib");
        if (clazzName == null) {
            throw new IllegalStateException("Property serialization.lib cannot be null");
        }
        return clazzName;
    }

    public Deserializer getDeserializer(Configuration conf) throws Exception {
        Properties schema = this.getProperties();
        String clazzName = this.getDeserializerClassName();
        Deserializer deserializer = (Deserializer)ReflectionUtils.newInstance(conf.getClassByName(clazzName).asSubclass(Deserializer.class), (Configuration)conf);
        SerDeUtils.initializeSerDe(deserializer, conf, this.getTableDesc().getProperties(), schema);
        return deserializer;
    }

    public void setInputFileFormatClass(Class<? extends InputFormat> inputFileFormatClass) {
        this.inputFileFormatClass = inputFileFormatClass == null ? null : CLASS_INTERNER.intern(inputFileFormatClass);
    }

    public Class<? extends OutputFormat> getOutputFileFormatClass() {
        if (this.outputFileFormatClass == null && this.tableDesc != null) {
            this.setOutputFileFormatClass(this.tableDesc.getOutputFileFormatClass());
        }
        return this.outputFileFormatClass;
    }

    public void setOutputFileFormatClass(Class<?> outputFileFormatClass) {
        Class<? extends OutputFormat> outputClass = outputFileFormatClass == null ? null : HiveFileFormatUtils.getOutputFormatSubstitute(outputFileFormatClass);
        this.outputFileFormatClass = outputClass != null ? CLASS_INTERNER.intern(outputClass) : outputClass;
    }

    public Properties getProperties() {
        if (this.properties == null && this.tableDesc != null) {
            return this.tableDesc.getProperties();
        }
        return this.properties;
    }

    @Explain(displayName="properties", normalExplain=false)
    public Map getPropertiesExplain() {
        return HiveStringUtils.getPropertiesExplain(this.getProperties());
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String oldValue = properties.getProperty(key);
            if (oldValue == null) continue;
            String value = STRING_INTERNER.intern(oldValue);
            properties.setProperty(key, value);
        }
    }

    @Explain(displayName="serde")
    public String getSerdeClassName() {
        return this.getProperties().getProperty("serialization.lib");
    }

    @Explain(displayName="name")
    public String getTableName() {
        return this.getProperties().getProperty("name");
    }

    @Explain(displayName="input format")
    public String getInputFileFormatClassName() {
        return this.getInputFileFormatClass().getName();
    }

    @Explain(displayName="output format")
    public String getOutputFileFormatClassName() {
        return this.getOutputFileFormatClass().getName();
    }

    @Explain(displayName="base file name", normalExplain=false)
    public String getBaseFileName() {
        return this.baseFileName;
    }

    public boolean isPartitioned() {
        return this.partSpec != null && !this.partSpec.isEmpty();
    }

    public PartitionDesc clone() {
        PartitionDesc ret = new PartitionDesc();
        ret.inputFileFormatClass = this.inputFileFormatClass;
        ret.outputFileFormatClass = this.outputFileFormatClass;
        if (this.properties != null) {
            Properties newProp = new Properties();
            Enumeration<Object> keysProp = this.properties.keys();
            while (keysProp.hasMoreElements()) {
                Object key = keysProp.nextElement();
                newProp.put(key, this.properties.get(key));
            }
            ret.setProperties(newProp);
        }
        ret.tableDesc = (TableDesc)this.tableDesc.clone();
        if (this.partSpec != null) {
            ret.partSpec = new LinkedHashMap();
            ret.partSpec.putAll(this.partSpec);
        }
        return ret;
    }

    public void deriveBaseFileName(String path) {
        PlanUtils.configureInputJobPropertiesForStorageHandler(this.tableDesc);
        if (path == null) {
            return;
        }
        try {
            Path p = new Path(path);
            this.baseFileName = p.getName();
        }
        catch (Exception ex) {
            this.baseFileName = path;
        }
    }

    public void intern(Interner<TableDesc> interner) {
        this.tableDesc = interner.intern(this.tableDesc);
    }
}

