/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.CreateFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DropFunctionDesc;
import org.apache.hadoop.hive.ql.plan.FunctionWork;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

public class FunctionSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private static final Log LOG = LogFactory.getLog(FunctionSemanticAnalyzer.class);

    public FunctionSemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        if (ast.getToken().getType() == 636) {
            this.analyzeCreateFunction(ast);
        }
        if (ast.getToken().getType() == 666) {
            this.analyzeDropFunction(ast);
        }
        LOG.info((Object)"analyze done");
    }

    private void analyzeCreateFunction(ASTNode ast) throws SemanticException {
        String functionName = ast.getChild(0).getText().toLowerCase();
        boolean isTemporaryFunction = ast.getFirstChildWithType(869) != null;
        String className = FunctionSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        if (isTemporaryFunction && FunctionUtils.isQualifiedFunctionName(functionName)) {
            throw new SemanticException("Temporary function cannot be created with a qualified name.");
        }
        List<ResourceUri> resources = this.getResourceList(ast);
        CreateFunctionDesc desc = new CreateFunctionDesc(functionName, isTemporaryFunction, className, resources);
        this.rootTasks.add(TaskFactory.get(new FunctionWork(desc), this.conf, new Task[0]));
        this.addEntities(functionName, isTemporaryFunction, resources);
    }

    private void analyzeDropFunction(ASTNode ast) throws SemanticException {
        boolean throwException;
        String functionName = ast.getChild(0).getText();
        boolean ifExists = ast.getFirstChildWithType(700) != null;
        boolean bl = throwException = !ifExists && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROPIGNORESNONEXISTENT);
        if (FunctionRegistry.getFunctionInfo(functionName) == null) {
            if (throwException) {
                throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(functionName));
            }
            return;
        }
        boolean isTemporaryFunction = ast.getFirstChildWithType(869) != null;
        DropFunctionDesc desc = new DropFunctionDesc(functionName, isTemporaryFunction);
        this.rootTasks.add(TaskFactory.get(new FunctionWork(desc), this.conf, new Task[0]));
        this.addEntities(functionName, isTemporaryFunction, null);
    }

    private ResourceType getResourceType(ASTNode token) throws SemanticException {
        switch (token.getType()) {
            case 712: {
                return ResourceType.JAR;
            }
            case 678: {
                return ResourceType.FILE;
            }
            case 625: {
                return ResourceType.ARCHIVE;
            }
        }
        throw new SemanticException("Unexpected token " + token.toString());
    }

    private List<ResourceUri> getResourceList(ASTNode ast) throws SemanticException {
        ArrayList<ResourceUri> resources = null;
        ASTNode resourcesNode = (ASTNode)ast.getFirstChildWithType(782);
        if (resourcesNode != null) {
            resources = new ArrayList<ResourceUri>();
            for (int idx = 0; idx < resourcesNode.getChildCount(); ++idx) {
                ASTNode resNode = (ASTNode)resourcesNode.getChild(idx);
                if (resNode.getToken().getType() != 783) {
                    throw new SemanticException("Expected token type TOK_RESOURCE_URI but found " + resNode.getToken().toString());
                }
                if (resNode.getChildCount() != 2) {
                    throw new SemanticException("Expected 2 child nodes of TOK_RESOURCE_URI but found " + resNode.getChildCount());
                }
                ASTNode resTypeNode = (ASTNode)resNode.getChild(0);
                ASTNode resUriNode = (ASTNode)resNode.getChild(1);
                ResourceType resourceType = this.getResourceType(resTypeNode);
                resources.add(new ResourceUri(resourceType, PlanUtils.stripQuotes(resUriNode.getText())));
            }
        }
        return resources;
    }

    private void addEntities(String functionName, boolean isTemporaryFunction, List<ResourceUri> resources) throws SemanticException {
        Database database = null;
        if (!isTemporaryFunction) {
            try {
                String[] qualifiedNameParts = FunctionUtils.getQualifiedFunctionNameParts(functionName);
                String dbName = qualifiedNameParts[0];
                functionName = qualifiedNameParts[1];
                database = this.getDatabase(dbName);
            }
            catch (HiveException e) {
                LOG.error((Object)e);
                throw new SemanticException(e);
            }
        }
        if (database != null) {
            this.outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_NO_LOCK));
        }
        this.outputs.add(new WriteEntity(database, functionName, Entity.Type.FUNCTION, WriteEntity.WriteType.DDL_NO_LOCK));
        if (resources != null) {
            for (ResourceUri resource : resources) {
                String uriPath = resource.getUri();
                this.outputs.add(this.toWriteEntity(uriPath));
            }
        }
    }
}

