/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.optiq.translator;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import net.hydromatic.avatica.ByteString;
import org.apache.hadoop.hive.ql.optimizer.optiq.RelOptHiveTable;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.sql.type.SqlTypeName;

class ASTBuilder {
    ASTNode curr;

    ASTBuilder() {
    }

    static ASTBuilder construct(int tokenType, String text) {
        ASTBuilder b = new ASTBuilder();
        b.curr = ASTBuilder.createAST(tokenType, text);
        return b;
    }

    static ASTNode createAST(int tokenType, String text) {
        return (ASTNode)ParseDriver.adaptor.create(tokenType, text);
    }

    static ASTNode destNode() {
        return ASTBuilder.construct(656, "TOK_DESTINATION").add(ASTBuilder.construct(657, "TOK_DIR").add(867, "TOK_TMP_FILE")).node();
    }

    static ASTNode table(TableAccessRelBase scan) {
        RelOptHiveTable hTbl = (RelOptHiveTable)scan.getTable();
        ASTBuilder b = ASTBuilder.construct(859, "TOK_TABREF").add(ASTBuilder.construct(858, "TOK_TABNAME").add(26, hTbl.getHiveTableMD().getDbName()).add(26, hTbl.getHiveTableMD().getTableName()));
        b.add(26, hTbl.getTableAlias());
        return b.node();
    }

    static ASTNode join(ASTNode left, ASTNode right, JoinRelType joinType, ASTNode cond, boolean semiJoin) {
        ASTBuilder b = null;
        switch (joinType) {
            case INNER: {
                if (semiJoin) {
                    b = ASTBuilder.construct(713, "TOK_LEFTSEMIJOIN");
                    break;
                }
                b = ASTBuilder.construct(709, "TOK_JOIN");
                break;
            }
            case LEFT: {
                b = ASTBuilder.construct(712, "TOK_LEFTOUTERJOIN");
                break;
            }
            case RIGHT: {
                b = ASTBuilder.construct(783, "TOK_RIGHTOUTERJOIN");
                break;
            }
            case FULL: {
                b = ASTBuilder.construct(678, "TOK_FULLOUTERJOIN");
            }
        }
        b.add(left).add(right).add(cond);
        return b.node();
    }

    static ASTNode subQuery(ASTNode qry, String alias) {
        return ASTBuilder.construct(824, "TOK_SUBQUERY").add(qry).add(26, alias).node();
    }

    static ASTNode qualifiedName(String tableName, String colName) {
        ASTBuilder b = ASTBuilder.construct(17, ".").add(ASTBuilder.construct(855, "TOK_TABLE_OR_COL").add(26, tableName)).add(26, colName);
        return b.node();
    }

    static ASTNode unqualifiedName(String colName) {
        ASTBuilder b = ASTBuilder.construct(855, "TOK_TABLE_OR_COL").add(26, colName);
        return b.node();
    }

    static ASTNode where(ASTNode cond) {
        return ASTBuilder.construct(886, "TOK_WHERE").add(cond).node();
    }

    static ASTNode having(ASTNode cond) {
        return ASTBuilder.construct(691, "TOK_HAVING").add(cond).node();
    }

    static ASTNode limit(Object value) {
        return ASTBuilder.construct(716, "TOK_LIMIT").add(289, value.toString()).node();
    }

    static ASTNode selectExpr(ASTNode expr, String alias) {
        return ASTBuilder.construct(789, "TOK_SELEXPR").add(expr).add(26, alias).node();
    }

    static ASTNode literal(RexLiteral literal) {
        return ASTBuilder.literal(literal, false);
    }

    static ASTNode literal(RexLiteral literal, boolean useTypeQualInLiteral) {
        Object val = null;
        int type = 0;
        SqlTypeName sqlType = literal.getType().getSqlTypeName();
        switch (sqlType) {
            case BINARY: {
                ByteString bs = (ByteString)literal.getValue();
                val = bs.byteAt(0);
                type = 7;
                break;
            }
            case TINYINT: {
                val = useTypeQualInLiteral ? literal.getValue3() + "Y" : literal.getValue3();
                type = 302;
                break;
            }
            case SMALLINT: {
                val = useTypeQualInLiteral ? literal.getValue3() + "S" : literal.getValue3();
                type = 299;
                break;
            }
            case INTEGER: {
                val = literal.getValue3();
                type = 7;
                break;
            }
            case BIGINT: {
                val = useTypeQualInLiteral ? literal.getValue3() + "L" : literal.getValue3();
                type = 7;
                break;
            }
            case DOUBLE: {
                val = literal.getValue3() + "D";
                type = 289;
                break;
            }
            case DECIMAL: {
                val = literal.getValue3() + "BD";
                type = 18;
                break;
            }
            case FLOAT: 
            case REAL: {
                val = literal.getValue3();
                type = 289;
                break;
            }
            case VARCHAR: 
            case CHAR: {
                val = literal.getValue3();
                String escapedVal = BaseSemanticAnalyzer.escapeSQLString(String.valueOf(val));
                type = 300;
                val = "'" + escapedVal + "'";
                break;
            }
            case BOOLEAN: {
                val = literal.getValue3();
                type = (Boolean)val != false ? 254 : 105;
                break;
            }
            case DATE: {
                val = literal.getValue();
                type = 646;
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                val = df.format(((Calendar)val).getTime());
                val = "'" + val + "'";
                break;
            }
            case TIME: 
            case TIMESTAMP: {
                val = literal.getValue();
                type = 865;
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                val = df.format(((Calendar)val).getTime());
                val = "'" + val + "'";
                break;
            }
            case NULL: {
                type = 728;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Type: " + sqlType);
            }
        }
        return (ASTNode)ParseDriver.adaptor.create(type, String.valueOf(val));
    }

    ASTNode node() {
        return this.curr;
    }

    ASTBuilder add(int tokenType, String text) {
        ParseDriver.adaptor.addChild((Object)this.curr, (Object)ASTBuilder.createAST(tokenType, text));
        return this;
    }

    ASTBuilder add(ASTBuilder b) {
        ParseDriver.adaptor.addChild((Object)this.curr, (Object)b.curr);
        return this;
    }

    ASTBuilder add(ASTNode n) {
        if (n != null) {
            ParseDriver.adaptor.addChild((Object)this.curr, (Object)n);
        }
        return this;
    }
}

