/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.optiq.stats;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.util.BitSets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.optimizer.optiq.reloperators.HiveTableScanRel;
import org.apache.hadoop.hive.ql.optimizer.optiq.stats.HiveRelMdUniqueKeys;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelVisitor;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.rel.metadata.ReflectiveRelMetadataProvider;
import org.eigenbase.rel.metadata.RelMdRowCount;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.hep.HepRelVertex;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.util.Holder;
import org.eigenbase.util.Pair;

public class HiveRelMdRowCount
extends RelMdRowCount {
    protected static final Log LOG = LogFactory.getLog((String)HiveRelMdRowCount.class.getName());
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltinMethod.ROW_COUNT.method, (Object)((Object)new HiveRelMdRowCount()));

    protected HiveRelMdRowCount() {
    }

    public Double getRowCount(JoinRelBase join) {
        PKFKRelationInfo pkfk = HiveRelMdRowCount.analyzeJoinForPKFK(join);
        if (pkfk != null) {
            double selectivity = pkfk.pkInfo.selectivity * pkfk.ndvScalingFactor;
            selectivity = Math.min(1.0, selectivity);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Identified Primary - Foreign Key relation:");
                LOG.debug((Object)RelOptUtil.toString((RelNode)join));
                LOG.debug((Object)pkfk);
            }
            return pkfk.fkInfo.rowCount * selectivity;
        }
        return join.getRows();
    }

    public Double getRowCount(SemiJoinRel rel) {
        PKFKRelationInfo pkfk = HiveRelMdRowCount.analyzeJoinForPKFK((JoinRelBase)rel);
        if (pkfk != null) {
            double selectivity = pkfk.pkInfo.selectivity * pkfk.ndvScalingFactor;
            selectivity = Math.min(1.0, selectivity);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Identified Primary - Foreign Key relation:");
                LOG.debug((Object)RelOptUtil.toString((RelNode)rel));
                LOG.debug((Object)pkfk);
            }
            return pkfk.fkInfo.rowCount * selectivity;
        }
        return super.getRowCount(rel);
    }

    public static PKFKRelationInfo analyzeJoinForPKFK(JoinRelBase joinRel) {
        int pkSide;
        boolean rightIsKey;
        RelNode left = (RelNode)joinRel.getInputs().get(0);
        RelNode right = (RelNode)joinRel.getInputs().get(1);
        List initJoinFilters = RelOptUtil.conjunctions((RexNode)joinRel.getCondition());
        if (initJoinFilters.isEmpty()) {
            return null;
        }
        ArrayList<RexNode> leftFilters = new ArrayList<RexNode>();
        ArrayList<RexNode> rightFilters = new ArrayList<RexNode>();
        ArrayList<RexNode> joinFilters = new ArrayList<RexNode>(initJoinFilters);
        Holder joinTypeHolder = Holder.of((Object)joinRel.getJoinType());
        if (joinRel instanceof SemiJoinRel) {
            return null;
        }
        RelOptUtil.classifyFilters((RelNode)joinRel, joinFilters, (JoinRelType)joinRel.getJoinType(), (boolean)false, (!joinRel.getJoinType().generatesNullsOnRight() ? 1 : 0) != 0, (!joinRel.getJoinType().generatesNullsOnLeft() ? 1 : 0) != 0, joinFilters, leftFilters, rightFilters);
        Pair<Integer, Integer> joinCols = HiveRelMdRowCount.canHandleJoin(joinRel, leftFilters, rightFilters, joinFilters);
        if (joinCols == null) {
            return null;
        }
        int leftColIdx = (Integer)joinCols.left;
        int rightColIdx = (Integer)joinCols.right;
        RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
        RexNode leftPred = RexUtil.composeConjunction((RexBuilder)rexBuilder, leftFilters, (boolean)true);
        RexNode rightPred = RexUtil.composeConjunction((RexBuilder)rexBuilder, rightFilters, (boolean)true);
        BitSet lBitSet = BitSets.of((int[])new int[]{leftColIdx});
        BitSet rBitSet = BitSets.of((int[])new int[]{rightColIdx});
        boolean leftIsKey = (joinRel.getJoinType() == JoinRelType.INNER || joinRel.getJoinType() == JoinRelType.RIGHT) && !(joinRel instanceof SemiJoinRel) && HiveRelMdRowCount.isKey(lBitSet, left);
        boolean bl = rightIsKey = (joinRel.getJoinType() == JoinRelType.INNER || joinRel.getJoinType() == JoinRelType.LEFT) && HiveRelMdRowCount.isKey(rBitSet, right);
        if (!leftIsKey && !rightIsKey) {
            return null;
        }
        double leftRowCount = RelMetadataQuery.getRowCount((RelNode)left);
        double rightRowCount = RelMetadataQuery.getRowCount((RelNode)right);
        if (leftIsKey && rightIsKey && rightRowCount < leftRowCount) {
            leftIsKey = false;
        }
        int n = leftIsKey ? 0 : (pkSide = rightIsKey ? 1 : -1);
        boolean isPKSideSimpleTree = pkSide != -1 ? IsSimpleTreeOnJoinKey.check(pkSide == 0 ? left : right, pkSide == 0 ? leftColIdx : rightColIdx) : false;
        double leftNDV = isPKSideSimpleTree ? RelMetadataQuery.getDistinctRowCount((RelNode)left, (BitSet)lBitSet, (RexNode)leftPred) : -1.0;
        double rightNDV = isPKSideSimpleTree ? RelMetadataQuery.getDistinctRowCount((RelNode)right, (BitSet)rBitSet, (RexNode)rightPred) : -1.0;
        double ndvScalingFactor = 1.0;
        if (isPKSideSimpleTree) {
            double d = ndvScalingFactor = pkSide == 0 ? leftNDV / rightNDV : rightNDV / leftNDV;
        }
        if (pkSide == 0) {
            FKSideInfo fkInfo = new FKSideInfo(rightRowCount, rightNDV);
            double pkSelectivity = HiveRelMdRowCount.pkSelectivity(joinRel, true, left, leftRowCount);
            PKSideInfo pkInfo = new PKSideInfo(leftRowCount, leftNDV, joinRel.getJoinType().generatesNullsOnRight() ? 1.0 : pkSelectivity);
            return new PKFKRelationInfo(1, fkInfo, pkInfo, ndvScalingFactor, isPKSideSimpleTree);
        }
        if (pkSide == 1) {
            FKSideInfo fkInfo = new FKSideInfo(leftRowCount, leftNDV);
            double pkSelectivity = HiveRelMdRowCount.pkSelectivity(joinRel, false, right, rightRowCount);
            PKSideInfo pkInfo = new PKSideInfo(rightRowCount, rightNDV, joinRel.getJoinType().generatesNullsOnLeft() ? 1.0 : pkSelectivity);
            return new PKFKRelationInfo(1, fkInfo, pkInfo, ndvScalingFactor, isPKSideSimpleTree);
        }
        return null;
    }

    private static double pkSelectivity(JoinRelBase joinRel, boolean leftChild, RelNode child, double childRowCount) {
        if (leftChild && joinRel.getJoinType().generatesNullsOnRight() || !leftChild && joinRel.getJoinType().generatesNullsOnLeft()) {
            return 1.0;
        }
        HiveTableScanRel tScan = HiveRelMdUniqueKeys.getTableScan(child, true);
        if (tScan != null) {
            double tRowCount = RelMetadataQuery.getRowCount((RelNode)tScan);
            return childRowCount / tRowCount;
        }
        return 1.0;
    }

    private static boolean isKey(BitSet c, RelNode rel) {
        boolean isKey = false;
        Set keys = RelMetadataQuery.getUniqueKeys((RelNode)rel);
        if (keys != null) {
            for (BitSet key : keys) {
                if (!key.equals(c)) continue;
                isKey = true;
                break;
            }
        }
        return isKey;
    }

    private static Pair<Integer, Integer> canHandleJoin(JoinRelBase joinRel, List<RexNode> leftFilters, List<RexNode> rightFilters, List<RexNode> joinFilters) {
        if (joinFilters.size() != 1) {
            return null;
        }
        RexNode joinCond = joinFilters.get(0);
        if (!(joinCond instanceof RexCall)) {
            return null;
        }
        if (((RexCall)joinCond).getOperator() != SqlStdOperatorTable.EQUALS) {
            return null;
        }
        BitSet leftCols = RelOptUtil.InputFinder.bits((RexNode)((RexNode)((RexCall)joinCond).getOperands().get(0)));
        BitSet rightCols = RelOptUtil.InputFinder.bits((RexNode)((RexNode)((RexCall)joinCond).getOperands().get(1)));
        if (leftCols.cardinality() != 1 || rightCols.cardinality() != 1) {
            return null;
        }
        int nFieldsLeft = joinRel.getLeft().getRowType().getFieldList().size();
        int nFieldsRight = joinRel.getRight().getRowType().getFieldList().size();
        int nSysFields = joinRel.getSystemFieldList().size();
        BitSet rightFieldsBitSet = BitSets.range((int)(nSysFields + nFieldsLeft), (int)(nSysFields + nFieldsLeft + nFieldsRight));
        if (BitSets.contains((BitSet)rightFieldsBitSet, (BitSet)leftCols)) {
            BitSet t = leftCols;
            leftCols = rightCols;
            rightCols = t;
        }
        int leftColIdx = leftCols.nextSetBit(0) - nSysFields;
        int rightColIdx = rightCols.nextSetBit(0) - (nSysFields + nFieldsLeft);
        return new Pair((Object)leftColIdx, (Object)rightColIdx);
    }

    private static class IsSimpleTreeOnJoinKey
    extends RelVisitor {
        int joinKey;
        boolean simpleTree;

        static boolean check(RelNode r, int joinKey) {
            IsSimpleTreeOnJoinKey v = new IsSimpleTreeOnJoinKey(joinKey);
            v.go(r);
            return v.simpleTree;
        }

        IsSimpleTreeOnJoinKey(int joinKey) {
            this.joinKey = joinKey;
            this.simpleTree = true;
        }

        public void visit(RelNode node, int ordinal, RelNode parent) {
            if (node instanceof HepRelVertex) {
                node = ((HepRelVertex)node).getCurrentRel();
            }
            this.simpleTree = node instanceof TableAccessRelBase ? true : (node instanceof ProjectRelBase ? this.isSimple((ProjectRelBase)node) : (node instanceof FilterRelBase ? this.isSimple((FilterRelBase)node) : false));
            if (this.simpleTree) {
                super.visit(node, ordinal, parent);
            }
        }

        private boolean isSimple(ProjectRelBase project) {
            RexNode r = (RexNode)project.getProjects().get(this.joinKey);
            if (r instanceof RexInputRef) {
                this.joinKey = ((RexInputRef)r).getIndex();
                return true;
            }
            return false;
        }

        private boolean isSimple(FilterRelBase filter) {
            BitSet condBits = RelOptUtil.InputFinder.bits((RexNode)filter.getCondition());
            return HiveRelMdRowCount.isKey(condBits, (RelNode)filter);
        }
    }

    static class PKSideInfo
    extends FKSideInfo {
        public final double selectivity;

        public PKSideInfo(double rowCount, double distinctCount, double selectivity) {
            super(rowCount, distinctCount);
            this.selectivity = selectivity;
        }

        @Override
        public String toString() {
            return String.format("PKInfo(rowCount=%.2f,ndv=%.2f,selectivity=%.2f)", this.rowCount, this.distinctCount, this.selectivity);
        }
    }

    static class FKSideInfo {
        public final double rowCount;
        public final double distinctCount;

        public FKSideInfo(double rowCount, double distinctCount) {
            this.rowCount = rowCount;
            this.distinctCount = distinctCount;
        }

        public String toString() {
            return String.format("FKInfo(rowCount=%.2f,ndv=%.2f)", this.rowCount, this.distinctCount);
        }
    }

    static class PKFKRelationInfo {
        public final int fkSide;
        public final double ndvScalingFactor;
        public final FKSideInfo fkInfo;
        public final PKSideInfo pkInfo;
        public final boolean isPKSideSimple;

        PKFKRelationInfo(int fkSide, FKSideInfo fkInfo, PKSideInfo pkInfo, double ndvScalingFactor, boolean isPKSideSimple) {
            this.fkSide = fkSide;
            this.fkInfo = fkInfo;
            this.pkInfo = pkInfo;
            this.ndvScalingFactor = ndvScalingFactor;
            this.isPKSideSimple = isPKSideSimple;
        }

        public String toString() {
            return String.format("Primary - Foreign Key join:\n\tfkSide = %d\n\tFKInfo:%s\n\tPKInfo:%s\n\tisPKSideSimple:%s\n\tNDV Scaling Factor:%.2f\n", this.fkSide, this.fkInfo, this.pkInfo, this.isPKSideSimple, this.ndvScalingFactor);
        }
    }
}

