/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.optiq.stats;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.List;
import net.hydromatic.optiq.BuiltinMethod;
import org.apache.hadoop.hive.ql.optimizer.optiq.HiveOptiqUtil;
import org.apache.hadoop.hive.ql.optimizer.optiq.cost.HiveCost;
import org.apache.hadoop.hive.ql.optimizer.optiq.reloperators.HiveJoinRel;
import org.apache.hadoop.hive.ql.optimizer.optiq.reloperators.HiveTableScanRel;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.ChainedRelMetadataProvider;
import org.eigenbase.rel.metadata.ReflectiveRelMetadataProvider;
import org.eigenbase.rel.metadata.RelMdDistinctRowCount;
import org.eigenbase.rel.metadata.RelMdUtil;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.rex.RexNode;

public class HiveRelMdDistinctRowCount
extends RelMdDistinctRowCount {
    private static final HiveRelMdDistinctRowCount INSTANCE = new HiveRelMdDistinctRowCount();
    public static final RelMetadataProvider SOURCE = ChainedRelMetadataProvider.of(ImmutableList.of(ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltinMethod.DISTINCT_ROW_COUNT.method, (Object)((Object)INSTANCE)), ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltinMethod.CUMULATIVE_COST.method, (Object)((Object)INSTANCE))));

    private HiveRelMdDistinctRowCount() {
    }

    public Double getDistinctRowCount(RelNode rel, BitSet groupKey, RexNode predicate) {
        if (rel instanceof HiveTableScanRel) {
            return this.getDistinctRowCount((HiveTableScanRel)rel, groupKey, predicate);
        }
        return super.getDistinctRowCount(rel, groupKey, predicate);
    }

    private Double getDistinctRowCount(HiveTableScanRel htRel, BitSet groupKey, RexNode predicate) {
        List<Integer> projIndxLst = HiveOptiqUtil.translateBitSetToProjIndx(groupKey);
        List<ColStatistics> colStats = htRel.getColStat(projIndxLst);
        Double noDistinctRows = 1.0;
        for (ColStatistics cStat : colStats) {
            noDistinctRows = noDistinctRows * (double)cStat.getCountDistint();
        }
        return Math.min(noDistinctRows, htRel.getRows());
    }

    public static Double getDistinctRowCount(RelNode r, int indx) {
        BitSet bitSetOfRqdProj = new BitSet();
        bitSetOfRqdProj.set(indx);
        return RelMetadataQuery.getDistinctRowCount((RelNode)r, (BitSet)bitSetOfRqdProj, (RexNode)r.getCluster().getRexBuilder().makeLiteral(true));
    }

    public Double getDistinctRowCount(JoinRelBase rel, BitSet groupKey, RexNode predicate) {
        if (rel instanceof HiveJoinRel) {
            HiveJoinRel hjRel = (HiveJoinRel)rel;
            if (hjRel.isLeftSemiJoin()) {
                return RelMetadataQuery.getDistinctRowCount((RelNode)hjRel.getLeft(), (BitSet)groupKey, (RexNode)rel.getCluster().getRexBuilder().makeLiteral(true));
            }
            return RelMdUtil.getJoinDistinctRowCount((RelNode)rel, (JoinRelType)rel.getJoinType(), (BitSet)groupKey, (RexNode)predicate, (boolean)true);
        }
        return RelMetadataQuery.getDistinctRowCount((RelNode)rel, (BitSet)groupKey, (RexNode)predicate);
    }

    public RelOptCost getCumulativeCost(HiveJoinRel rel) {
        RelOptCost cost = RelMetadataQuery.getNonCumulativeCost((RelNode)rel);
        List inputs = rel.getInputs();
        HiveCost maxICost = HiveCost.ZERO;
        for (RelNode input : inputs) {
            RelOptCost iCost = RelMetadataQuery.getCumulativeCost((RelNode)input);
            if (!maxICost.isLt(iCost)) continue;
            maxICost = iCost;
        }
        return cost.plus((RelOptCost)maxICost);
    }
}

