/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.type.SqlTypeName;

public class HiveTypeSystemImpl
extends RelDataTypeSystemImpl {
    private static final int MAX_DECIMAL_PRECISION = 38;
    private static final int MAX_DECIMAL_SCALE = 38;
    private static final int DEFAULT_DECIMAL_PRECISION = 10;
    private static final int MAX_VARCHAR_PRECISION = 65535;
    private static final int MAX_CHAR_PRECISION = 255;
    private static final int MAX_BINARY_PRECISION = Integer.MAX_VALUE;
    private static final int MAX_TIMESTAMP_PRECISION = 9;

    public int getMaxScale(SqlTypeName typeName) {
        switch (typeName) {
            case DECIMAL: {
                return this.getMaxNumericScale();
            }
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return 9;
            }
        }
        return -1;
    }

    public int getDefaultPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: 
            case TIME: 
            case TIMESTAMP: {
                return this.getMaxPrecision(typeName);
            }
            case DECIMAL: {
                return 10;
            }
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return 2;
            }
        }
        return -1;
    }

    public int getMaxPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case DECIMAL: {
                return this.getMaxNumericPrecision();
            }
            case VARCHAR: {
                return 65535;
            }
            case CHAR: {
                return 255;
            }
            case BINARY: 
            case VARBINARY: {
                return Integer.MAX_VALUE;
            }
            case TIME: 
            case TIMESTAMP: {
                return 9;
            }
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return 10;
            }
        }
        return -1;
    }

    public int getMaxNumericScale() {
        return 38;
    }

    public int getMaxNumericPrecision() {
        return 38;
    }
}

