/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.CommonMergeJoinOperator;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.GenTezProcContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MergeJoinWork;
import org.apache.hadoop.hive.ql.plan.TezEdgeProperty;
import org.apache.hadoop.hive.ql.plan.TezWork;

public class MergeJoinProc
implements NodeProcessor {
    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        TezEdgeProperty edgeProp;
        GenTezProcContext context = (GenTezProcContext)procCtx;
        CommonMergeJoinOperator mergeJoinOp = (CommonMergeJoinOperator)nd;
        if (stack.size() < 2 || !(stack.get(stack.size() - 2) instanceof DummyStoreOperator)) {
            context.currentMergeJoinOperator = mergeJoinOp;
            return null;
        }
        TezWork tezWork = (TezWork)context.currentTask.getWork();
        Operator parentOp = (Operator)stack.get(stack.size() - 2);
        BaseWork parentWork = context.childToWorkMap.get(parentOp).get(0);
        MergeJoinWork mergeWork = null;
        if (context.opMergeJoinWorkMap.containsKey(mergeJoinOp)) {
            mergeWork = context.opMergeJoinWorkMap.get(mergeJoinOp);
        } else {
            mergeWork = new MergeJoinWork();
            tezWork.add(mergeWork);
            context.opMergeJoinWorkMap.put(mergeJoinOp, mergeWork);
        }
        mergeWork.setMergeJoinOperator(mergeJoinOp);
        mergeWork.addMergedWork(null, parentWork);
        tezWork.setVertexType(mergeWork, TezWork.VertexType.MULTI_INPUT_UNINITIALIZED_EDGES);
        for (BaseWork grandParentWork : tezWork.getParents(parentWork)) {
            parentWork.setName(grandParentWork.getName());
            edgeProp = tezWork.getEdgeProperty(grandParentWork, parentWork);
            tezWork.disconnect(grandParentWork, parentWork);
            tezWork.connect(grandParentWork, mergeWork, edgeProp);
        }
        for (BaseWork childWork : tezWork.getChildren(parentWork)) {
            edgeProp = tezWork.getEdgeProperty(parentWork, childWork);
            tezWork.disconnect(parentWork, childWork);
            tezWork.connect(mergeWork, childWork, edgeProp);
        }
        tezWork.remove(parentWork);
        DummyStoreOperator dummyOp = (DummyStoreOperator)stack.get(stack.size() - 2);
        parentWork.setTag(mergeJoinOp.getTagForOperator(dummyOp));
        mergeJoinOp.getParentOperators().remove(dummyOp);
        dummyOp.getChildOperators().clear();
        return true;
    }
}

