/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnAssign;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnAssignFactory;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapperBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class VectorMapJoinOperator
extends MapJoinOperator
implements VectorizationContextRegion {
    private static final Log LOG = LogFactory.getLog((String)VectorMapJoinOperator.class.getName());
    private static final long serialVersionUID = 1L;
    private VectorExpression[] keyExpressions;
    private VectorExpression[] bigTableFilterExpressions;
    private VectorExpression[] bigTableValueExpressions;
    private VectorizationContext vOutContext;
    private transient VectorizedRowBatch outputBatch;
    private transient VectorExpressionWriter[] valueWriters;
    private transient Map<ObjectInspector, VectorColumnAssign[]> outputVectorAssigners;
    private transient int batchIndex;
    private transient VectorHashKeyWrapper[] keyValues;
    private transient VectorHashKeyWrapperBatch keyWrapperBatch;
    private transient VectorExpressionWriter[] keyOutputWriters;
    private transient VectorizedRowBatchCtx vrbCtx = null;

    public VectorMapJoinOperator() {
    }

    public VectorMapJoinOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        this();
        MapJoinDesc desc = (MapJoinDesc)conf;
        this.conf = desc;
        this.order = desc.getTagOrder();
        this.numAliases = desc.getExprs().size();
        this.posBigTable = (byte)desc.getPosBigTable();
        this.filterMaps = desc.getFilterMap();
        this.noOuterJoin = desc.isNoOuterJoin();
        Map<Byte, List<ExprNodeDesc>> filterExpressions = desc.getFilters();
        this.bigTableFilterExpressions = vContext.getVectorExpressions(filterExpressions.get(this.posBigTable), VectorExpressionDescriptor.Mode.FILTER);
        List<ExprNodeDesc> keyDesc = desc.getKeys().get(this.posBigTable);
        this.keyExpressions = vContext.getVectorExpressions(keyDesc);
        Map<Byte, List<ExprNodeDesc>> exprs = desc.getExprs();
        this.bigTableValueExpressions = vContext.getVectorExpressions(exprs.get(this.posBigTable));
        this.vOutContext = new VectorizationContext(desc.getOutputColumnNames());
        this.vOutContext.setFileKey(vContext.getFileKey() + "/MAP_JOIN_" + desc.getBigTableAlias());
    }

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        List<ExprNodeDesc> keyDesc = ((MapJoinDesc)this.conf).getKeys().get(this.posBigTable);
        this.keyOutputWriters = VectorExpressionWriterFactory.getExpressionWriters(keyDesc);
        this.vrbCtx = new VectorizedRowBatchCtx();
        this.vrbCtx.init(this.vOutContext.getScratchColumnTypeMap(), (StructObjectInspector)this.outputObjInspector);
        this.outputBatch = this.vrbCtx.createVectorizedRowBatch();
        this.keyWrapperBatch = VectorHashKeyWrapperBatch.compileKeyWrapperBatch(this.keyExpressions);
        Map<Byte, List<ExprNodeDesc>> valueExpressions = ((MapJoinDesc)this.conf).getExprs();
        List<ExprNodeDesc> bigTableExpressions = valueExpressions.get(this.posBigTable);
        VectorExpressionWriterFactory.processVectorExpressions(bigTableExpressions, new VectorExpressionWriterFactory.ListOIDClosure(){

            @Override
            public void assign(VectorExpressionWriter[] writers, List<ObjectInspector> oids) {
                VectorMapJoinOperator.access$002(VectorMapJoinOperator.this, writers);
                ((VectorMapJoinOperator)VectorMapJoinOperator.this).joinValuesObjectInspectors[((VectorMapJoinOperator)VectorMapJoinOperator.this).posBigTable] = oids;
            }
        });
        ArrayList<ExprNodeEvaluator> vectorNodeEvaluators = new ArrayList<ExprNodeEvaluator>(bigTableExpressions.size());
        for (int i = 0; i < bigTableExpressions.size(); ++i) {
            ExprNodeDesc desc = bigTableExpressions.get(i);
            VectorExpression vectorExpr = this.bigTableValueExpressions[i];
            ExprNodeEvaluator eval = new ExprNodeEvaluator<ExprNodeDesc>(desc){
                int columnIndex;
                int writerIndex;

                public ExprNodeEvaluator initVectorExpr(int columnIndex, int writerIndex) {
                    this.columnIndex = columnIndex;
                    this.writerIndex = writerIndex;
                    return this;
                }

                @Override
                public ObjectInspector initialize(ObjectInspector rowInspector) throws HiveException {
                    throw new HiveException("should never reach here");
                }

                @Override
                protected Object _evaluate(Object row, int version) throws HiveException {
                    VectorizedRowBatch inBatch = (VectorizedRowBatch)row;
                    int rowIndex = inBatch.selectedInUse ? inBatch.selected[VectorMapJoinOperator.this.batchIndex] : VectorMapJoinOperator.this.batchIndex;
                    return VectorMapJoinOperator.this.valueWriters[this.writerIndex].writeValue(inBatch.cols[this.columnIndex], rowIndex);
                }
            }.initVectorExpr(vectorExpr.getOutputColumn(), i);
            vectorNodeEvaluators.add(eval);
        }
        this.joinValues[this.posBigTable] = vectorNodeEvaluators;
        this.filterMaps[this.posBigTable] = null;
        this.outputVectorAssigners = new HashMap<ObjectInspector, VectorColumnAssign[]>();
    }

    @Override
    protected void internalForward(Object row, ObjectInspector outputOI) throws HiveException {
        Object[] values = (Object[])row;
        VectorColumnAssign[] vcas = this.outputVectorAssigners.get(outputOI);
        if (null == vcas) {
            vcas = VectorColumnAssignFactory.buildAssigners(this.outputBatch, outputOI, this.vOutContext.getProjectionColumnMap(), ((MapJoinDesc)this.conf).getOutputColumnNames());
            this.outputVectorAssigners.put(outputOI, vcas);
        }
        for (int i = 0; i < values.length; ++i) {
            vcas[i].assignObjectValue(values[i], this.outputBatch.size);
        }
        ++this.outputBatch.size;
        if (this.outputBatch.size == 1024) {
            this.flushOutput();
        }
    }

    private void flushOutput() throws HiveException {
        this.forward(this.outputBatch, null);
        this.outputBatch.reset();
    }

    @Override
    public void closeOp(boolean aborted) throws HiveException {
        if (!aborted && 0 < this.outputBatch.size) {
            this.flushOutput();
        }
    }

    @Override
    protected void setMapJoinKey(MapJoinTableContainer.ReusableGetAdaptor dest, Object row, byte alias) throws HiveException {
        dest.setFromVector(this.keyValues[this.batchIndex], this.keyOutputWriters, this.keyWrapperBatch);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        byte alias = (byte)tag;
        VectorizedRowBatch inBatch = (VectorizedRowBatch)row;
        if (null != this.bigTableFilterExpressions) {
            for (VectorExpression ve : this.bigTableFilterExpressions) {
                ve.evaluate(inBatch);
            }
        }
        if (null != this.bigTableValueExpressions) {
            for (VectorExpression ve : this.bigTableValueExpressions) {
                ve.evaluate(inBatch);
            }
        }
        this.keyWrapperBatch.evaluateBatch(inBatch);
        this.keyValues = this.keyWrapperBatch.getVectorHashKeyWrappers();
        this.batchIndex = 0;
        while (this.batchIndex < inBatch.size) {
            super.processOp(row, tag);
            ++this.batchIndex;
        }
        this.batchIndex = -1;
        this.keyValues = null;
    }

    @Override
    public VectorizationContext getOuputVectorizationContext() {
        return this.vOutContext;
    }

    static /* synthetic */ VectorExpressionWriter[] access$002(VectorMapJoinOperator x0, VectorExpressionWriter[] x1) {
        x0.valueWriters = x1;
        return x1;
    }
}

