/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hive.com.esotericsoftware.kryo.io.Input;
import org.apache.hive.com.esotericsoftware.kryo.io.Output;

public class KryoSerializer {
    private static final Log LOG = LogFactory.getLog(KryoSerializer.class);

    public static byte[] serialize(Object object) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Output output = new Output(stream);
        Utilities.runtimeSerializationKryo.get().writeObject(output, object);
        output.close();
        return stream.toByteArray();
    }

    public static <T> T deserialize(byte[] buffer, Class<T> clazz) {
        return Utilities.runtimeSerializationKryo.get().readObject(new Input(new ByteArrayInputStream(buffer)), clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializeJobConf(JobConf jobConf) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            jobConf.write((DataOutput)new DataOutputStream(out));
        }
        catch (IOException e) {
            LOG.error((Object)("Error serializing job configuration: " + e), (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                LOG.error((Object)("Error closing output stream: " + e), (Throwable)e);
            }
        }
        return out.toByteArray();
    }

    public static JobConf deserializeJobConf(byte[] buffer) {
        JobConf conf = new JobConf();
        try {
            conf.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(buffer)));
        }
        catch (IOException e) {
            String msg = "Error de-serializing job configuration: " + e;
            throw new IllegalStateException(msg, e);
        }
        return conf;
    }
}

