/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;

public class LazyFlatRowContainer
extends AbstractCollection<Object>
implements MapJoinRowContainer,
AbstractRowContainer.RowIterator<List<Object>>,
List<Object> {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final int UNKNOWN = Integer.MAX_VALUE;
    private static Log LOG = LogFactory.getLog(LazyFlatRowContainer.class);
    private Object[] array;
    private int rowLength = Integer.MAX_VALUE;
    private byte aliasFilter = (byte)-1;

    public LazyFlatRowContainer() {
        this.array = EMPTY_OBJECT_ARRAY;
    }

    public void add(MapJoinObjectSerDeContext context, BytesWritable value, boolean allowLazy) throws HiveException {
        if (allowLazy) {
            this.addLazy(context, value);
            return;
        }
        SerDe serde = context.getSerDe();
        boolean hasValues = this.isLazy() ? this.setRowLength(serde, 0) : this.rowLength > 0;
        int rowCount = this.rowCount();
        if (hasValues) {
            this.listRealloc(this.array.length + this.rowLength);
            this.read(serde, (Writable)value, rowCount);
        } else {
            --this.rowLength;
        }
    }

    private void addLazy(MapJoinObjectSerDeContext valueContext, BytesWritable currentValue) {
        if (!this.isLazy()) {
            throw new AssertionError((Object)"Not in lazy mode");
        }
        int size = this.array.length;
        if (size == 0) {
            this.listRealloc(2);
            this.array[0] = valueContext;
            ++size;
        } else {
            if (this.array[0] != valueContext) {
                throw new AssertionError((Object)"Different valueContext for the same table");
            }
            this.listRealloc(size + 1);
        }
        byte[] rawData = new byte[currentValue.getSize()];
        System.arraycopy(currentValue.getBytes(), 0, rawData, 0, rawData.length);
        this.array[size] = rawData;
    }

    @Override
    public void addRow(List<Object> t) throws HiveException {
        LOG.debug((Object)("Add is called with " + t.size() + " objects"));
        int offset = this.prepareForAdd(t.size());
        if (offset < 0) {
            return;
        }
        for (int i = 0; i < t.size(); ++i) {
            this.array[offset + i] = t.get(i);
        }
    }

    @Override
    public void addRow(Object[] value) throws HiveException {
        LOG.debug((Object)("Add is called with " + value.length + " objects"));
        int offset = this.prepareForAdd(value.length);
        if (offset < 0) {
            return;
        }
        System.arraycopy(value, 0, this.array, offset, value.length);
    }

    private int prepareForAdd(int len) throws HiveException {
        if (this.isLazy()) {
            throw new AssertionError((Object)"Cannot add in lazy mode");
        }
        if (this.rowLength < 0) {
            if (len != 0) {
                throw new HiveException("Different size rows: 0 and " + len);
            }
            --this.rowLength;
            return -1;
        }
        if (this.rowLength != len) {
            throw new HiveException("Different size rows: " + this.rowLength + " and " + len);
        }
        int oldLen = this.array.length;
        this.listRealloc(oldLen + len);
        return oldLen;
    }

    @Override
    public void write(MapJoinObjectSerDeContext valueContext, ObjectOutputStream out) {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot be serialized");
    }

    @Override
    public AbstractRowContainer.RowIterator<List<Object>> rowIter() throws HiveException {
        this.ensureEager();
        if (this.array.length == this.rowLength) {
            return this;
        }
        return this.rowLength > 0 ? new RowIterator() : new EmptyRowIterator(-this.rowLength);
    }

    @Override
    public List<Object> first() throws HiveException {
        if (this.isLazy()) {
            throw new AssertionError((Object)"In lazy mode");
        }
        if (this.array.length != this.rowLength) {
            throw new AssertionError((Object)"Incorrect iterator usage, not single-row");
        }
        return this;
    }

    @Override
    public List<Object> next() {
        return null;
    }

    private void ensureEager() throws HiveException {
        int rowCount;
        if (!this.isLazy()) {
            return;
        }
        if (this.array.length == 0) {
            this.rowLength = 0;
            return;
        }
        Object[] lazyObjs = this.array;
        assert (lazyObjs.length > 1);
        MapJoinObjectSerDeContext context = (MapJoinObjectSerDeContext)lazyObjs[0];
        SerDe serde = context.getSerDe();
        if (!this.setRowLength(serde, rowCount = lazyObjs.length - 1)) {
            return;
        }
        this.array = new Object[this.rowLength * rowCount];
        ByteBufferWritable writable = new ByteBufferWritable();
        for (int i = 0; i < rowCount; ++i) {
            writable.setBytes((byte[])lazyObjs[i + 1]);
            this.read(serde, writable, i);
        }
        this.setAliasFilter(context);
    }

    private boolean setRowLength(SerDe serde, int rowCount) throws HiveException {
        try {
            this.rowLength = ObjectInspectorUtils.getStructSize(serde.getObjectInspector());
        }
        catch (SerDeException ex) {
            throw new HiveException("Get structure size error", ex);
        }
        if (this.rowLength == 0) {
            this.rowLength = -rowCount;
            this.array = EMPTY_OBJECT_ARRAY;
            return false;
        }
        return true;
    }

    private void read(SerDe serde, Writable writable, int rowOffset) throws HiveException {
        try {
            ObjectInspectorUtils.copyStructToArray(serde.deserialize(writable), serde.getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE, this.array, rowOffset * this.rowLength);
        }
        catch (SerDeException ex) {
            throw new HiveException("Lazy deserialize error", ex);
        }
    }

    private boolean isLazy() {
        return this.rowLength == Integer.MAX_VALUE;
    }

    @Override
    public int rowCount() throws HiveException {
        this.ensureEager();
        return this.rowLength > 0 ? this.array.length / this.rowLength : -this.rowLength;
    }

    @Override
    public void clearRows() {
        assert (!this.isLazy());
        this.array = EMPTY_OBJECT_ARRAY;
        this.rowLength = 0;
    }

    @Override
    public byte getAliasFilter() throws HiveException {
        this.ensureEager();
        return this.aliasFilter;
    }

    private void setAliasFilter(MapJoinObjectSerDeContext context) throws HiveException {
        if (this.isLazy()) {
            throw new AssertionError((Object)"In lazy mode");
        }
        if (this.rowLength <= 0 || !context.hasFilterTag()) {
            return;
        }
        for (int offset = this.rowLength - 1; offset < this.array.length; offset += this.rowLength) {
            this.aliasFilter = (byte)(this.aliasFilter & ((ShortWritable)this.array[offset]).get());
        }
    }

    @Override
    public MapJoinRowContainer copy() throws HiveException {
        this.ensureEager();
        LazyFlatRowContainer result = new LazyFlatRowContainer();
        result.array = new Object[this.array.length];
        System.arraycopy(this.array, 0, result.array, 0, this.array.length);
        result.rowLength = this.rowLength;
        result.aliasFilter = this.aliasFilter;
        return result;
    }

    private void listRealloc(int length) {
        Object[] array = new Object[length];
        if (this.array.length > 0) {
            System.arraycopy(this.array, 0, array, 0, this.array.length);
        }
        this.array = array;
    }

    @Override
    public int size() {
        this.checkSingleRow();
        return this.array.length;
    }

    @Override
    public Object get(int index) {
        return this.array[index];
    }

    @Override
    public Object[] toArray() {
        this.checkSingleRow();
        return this.array;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        this.checkSingleRow();
        return this.listIteratorInternal(index, 0, this.array.length);
    }

    private ListIterator<Object> listIteratorInternal(final int index, final int iterMinPos, final int iterMaxPos) {
        return new ListIterator<Object>(){
            private int pos;
            {
                this.pos = index - 1;
            }

            @Override
            public int nextIndex() {
                return this.pos + 1;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex() < iterMaxPos;
            }

            @Override
            public boolean hasPrevious() {
                return this.previousIndex() >= iterMinPos;
            }

            @Override
            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return LazyFlatRowContainer.this.get(++this.pos);
            }

            @Override
            public Object previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return LazyFlatRowContainer.this.get(--this.pos);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Object e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Object e) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int indexOf(Object o) {
        this.checkSingleRow();
        for (int i = 0; i < this.array.length; ++i) {
            if (!(o == null ? this.array[i] == null : o.equals(this.array[i]))) continue;
            return i;
        }
        return -1;
    }

    private void checkSingleRow() throws AssertionError {
        if (this.array.length != this.rowLength) {
            throw new AssertionError((Object)"Incorrect list usage, not single-row");
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        this.checkSingleRow();
        for (int i = this.array.length - 1; i >= 0; --i) {
            if (!(o == null ? this.array[i] == null : o.equals(this.array[i]))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        this.checkSingleRow();
        return new ReadOnlySubList(fromIndex, toIndex - fromIndex);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    private static class ByteBufferWritable
    extends BinaryComparable
    implements Writable {
        byte[] bytes = null;

        private ByteBufferWritable() {
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public int getLength() {
            return this.bytes.length;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public void readFields(DataInput arg0) {
            throw new UnsupportedOperationException();
        }

        public void write(DataOutput arg0) {
            throw new UnsupportedOperationException();
        }
    }

    private class ReadOnlySubList
    extends AbstractList<Object> {
        private int offset;
        private int size;

        ReadOnlySubList(int from, int size) {
            this.offset = from;
            this.size = size;
        }

        @Override
        public Object get(int index) {
            return LazyFlatRowContainer.this.array[index + this.offset];
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<Object> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<Object> listIterator(int index) {
            return LazyFlatRowContainer.this.listIteratorInternal(this.offset + index, this.offset, this.offset + this.size);
        }

        @Override
        public List<Object> subList(int fromIndex, int toIndex) {
            return new ReadOnlySubList(this.offset + fromIndex, toIndex - fromIndex);
        }

        @Override
        public Object[] toArray() {
            Object[] result = new Object[this.size];
            System.arraycopy(LazyFlatRowContainer.this.array, this.offset, result, 0, this.size);
            return result;
        }
    }

    private class RowIterator
    implements AbstractRowContainer.RowIterator<List<Object>> {
        private int index = 0;

        private RowIterator() {
        }

        @Override
        public List<Object> first() throws HiveException {
            assert (!LazyFlatRowContainer.this.isLazy());
            this.index = 0;
            if (LazyFlatRowContainer.this.array.length > 0) {
                return new ReadOnlySubList(0, LazyFlatRowContainer.this.rowLength);
            }
            return null;
        }

        @Override
        public List<Object> next() {
            assert (!LazyFlatRowContainer.this.isLazy());
            this.index += LazyFlatRowContainer.this.rowLength;
            if (this.index < LazyFlatRowContainer.this.array.length) {
                return new ReadOnlySubList(this.index, LazyFlatRowContainer.this.rowLength);
            }
            return null;
        }
    }

    private static class EmptyRowIterator
    implements AbstractRowContainer.RowIterator<List<Object>> {
        private static final List<Object> EMPTY_ROW = new ArrayList<Object>();
        private int rowCount;

        public EmptyRowIterator(int rowCount) {
            this.rowCount = rowCount;
        }

        @Override
        public List<Object> first() throws HiveException {
            return this.next();
        }

        @Override
        public List<Object> next() throws HiveException {
            return --this.rowCount < 0 ? null : EMPTY_ROW;
        }
    }
}

