/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.exec.AmbiguousMethodException;
import org.apache.hadoop.hive.ql.exec.CommonFunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionTask;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.NoMatchingMethodException;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.exec.WindowFunctionInfo;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.SettableUDF;
import org.apache.hadoop.hive.ql.udf.UDAFPercentile;
import org.apache.hadoop.hive.ql.udf.UDFAcos;
import org.apache.hadoop.hive.ql.udf.UDFAscii;
import org.apache.hadoop.hive.ql.udf.UDFAsin;
import org.apache.hadoop.hive.ql.udf.UDFAtan;
import org.apache.hadoop.hive.ql.udf.UDFBase64;
import org.apache.hadoop.hive.ql.udf.UDFBin;
import org.apache.hadoop.hive.ql.udf.UDFConv;
import org.apache.hadoop.hive.ql.udf.UDFCos;
import org.apache.hadoop.hive.ql.udf.UDFDayOfMonth;
import org.apache.hadoop.hive.ql.udf.UDFDegrees;
import org.apache.hadoop.hive.ql.udf.UDFE;
import org.apache.hadoop.hive.ql.udf.UDFExp;
import org.apache.hadoop.hive.ql.udf.UDFFindInSet;
import org.apache.hadoop.hive.ql.udf.UDFFromUnixTime;
import org.apache.hadoop.hive.ql.udf.UDFHex;
import org.apache.hadoop.hive.ql.udf.UDFHour;
import org.apache.hadoop.hive.ql.udf.UDFJson;
import org.apache.hadoop.hive.ql.udf.UDFLength;
import org.apache.hadoop.hive.ql.udf.UDFLike;
import org.apache.hadoop.hive.ql.udf.UDFLn;
import org.apache.hadoop.hive.ql.udf.UDFLog;
import org.apache.hadoop.hive.ql.udf.UDFLog10;
import org.apache.hadoop.hive.ql.udf.UDFLog2;
import org.apache.hadoop.hive.ql.udf.UDFMinute;
import org.apache.hadoop.hive.ql.udf.UDFMonth;
import org.apache.hadoop.hive.ql.udf.UDFOPBitAnd;
import org.apache.hadoop.hive.ql.udf.UDFOPBitNot;
import org.apache.hadoop.hive.ql.udf.UDFOPBitOr;
import org.apache.hadoop.hive.ql.udf.UDFOPBitXor;
import org.apache.hadoop.hive.ql.udf.UDFOPLongDivide;
import org.apache.hadoop.hive.ql.udf.UDFPI;
import org.apache.hadoop.hive.ql.udf.UDFParseUrl;
import org.apache.hadoop.hive.ql.udf.UDFRadians;
import org.apache.hadoop.hive.ql.udf.UDFRand;
import org.apache.hadoop.hive.ql.udf.UDFRegExp;
import org.apache.hadoop.hive.ql.udf.UDFRegExpExtract;
import org.apache.hadoop.hive.ql.udf.UDFRegExpReplace;
import org.apache.hadoop.hive.ql.udf.UDFRepeat;
import org.apache.hadoop.hive.ql.udf.UDFReverse;
import org.apache.hadoop.hive.ql.udf.UDFSecond;
import org.apache.hadoop.hive.ql.udf.UDFSign;
import org.apache.hadoop.hive.ql.udf.UDFSin;
import org.apache.hadoop.hive.ql.udf.UDFSpace;
import org.apache.hadoop.hive.ql.udf.UDFSqrt;
import org.apache.hadoop.hive.ql.udf.UDFSubstr;
import org.apache.hadoop.hive.ql.udf.UDFTan;
import org.apache.hadoop.hive.ql.udf.UDFToBoolean;
import org.apache.hadoop.hive.ql.udf.UDFToByte;
import org.apache.hadoop.hive.ql.udf.UDFToDouble;
import org.apache.hadoop.hive.ql.udf.UDFToFloat;
import org.apache.hadoop.hive.ql.udf.UDFToInteger;
import org.apache.hadoop.hive.ql.udf.UDFToLong;
import org.apache.hadoop.hive.ql.udf.UDFToShort;
import org.apache.hadoop.hive.ql.udf.UDFToString;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.UDFUnbase64;
import org.apache.hadoop.hive.ql.udf.UDFUnhex;
import org.apache.hadoop.hive.ql.udf.UDFWeekOfYear;
import org.apache.hadoop.hive.ql.udf.UDFYear;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFAverage;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCollectList;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCollectSet;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFComputeStats;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFContextNGrams;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCorrelation;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCount;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCovariance;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCovarianceSample;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCumeDist;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFDenseRank;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEWAHBitmap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFFirstValue;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFHistogramNumeric;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFLag;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFLastValue;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFLead;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMax;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMin;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFNTile;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFPercentRank;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFPercentileApprox;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFRank;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver2;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFRowNumber;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStdSample;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSum;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFVariance;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFVarianceSample;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFnGrams;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAbs;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAddMonths;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFArray;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFArrayContains;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAssertTrue;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCeil;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCoalesce;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcat;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcatWS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateAdd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateDiff;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateSub;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDecode;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFEWAHBitmapAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFEWAHBitmapEmpty;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFEWAHBitmapOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFElt;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFEncode;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFField;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFloor;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFormatNumber;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFromUtcTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFGreatest;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFHash;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInFile;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIndex;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInitCap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInstr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLag;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLastDay;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLead;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLeast;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLocate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLpad;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMacro;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMapKeys;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMapValues;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFNamedStruct;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFNvl;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPDivide;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMinus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMultiply;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNegative;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPlus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPositive;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPosMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPrintf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFReflect;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFReflect2;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRpad;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSentences;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSize;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSortArray;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSplit;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFStringToMap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFStruct;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUtcTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTranslate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUnion;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFExplode;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFInline;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFJSONTuple;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFParseUrlTuple;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFPosExplode;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFStack;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.UDFCurrentDB;
import org.apache.hadoop.hive.ql.udf.ptf.MatchPath;
import org.apache.hadoop.hive.ql.udf.ptf.Noop;
import org.apache.hadoop.hive.ql.udf.ptf.NoopStreaming;
import org.apache.hadoop.hive.ql.udf.ptf.NoopWithMap;
import org.apache.hadoop.hive.ql.udf.ptf.NoopWithMapStreaming;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionResolver;
import org.apache.hadoop.hive.ql.udf.ptf.WindowingTableFunction;
import org.apache.hadoop.hive.ql.udf.xml.GenericUDFXPath;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathBoolean;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathDouble;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathFloat;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathInteger;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathLong;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathShort;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathString;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.common.util.AnnotationUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class FunctionRegistry {
    private static Log LOG = LogFactory.getLog(FunctionRegistry.class);
    static Map<String, FunctionInfo> mFunctions = Collections.synchronizedMap(new LinkedHashMap());
    static Set<Class<?>> nativeUdfs = Collections.synchronizedSet(new HashSet());
    public static final String LEAD_FUNC_NAME = "lead";
    public static final String LAG_FUNC_NAME = "lag";
    public static final String LAST_VALUE_FUNC_NAME = "last_value";
    public static final String UNARY_PLUS_FUNC_NAME = "positive";
    public static final String UNARY_MINUS_FUNC_NAME = "negative";
    public static final String WINDOWING_TABLE_FUNCTION = "windowingtablefunction";
    private static final String NOOP_TABLE_FUNCTION = "noop";
    private static final String NOOP_MAP_TABLE_FUNCTION = "noopwithmap";
    private static final String NOOP_STREAMING_TABLE_FUNCTION = "noopstreaming";
    private static final String NOOP_STREAMING_MAP_TABLE_FUNCTION = "noopwithmapstreaming";
    static Map<String, WindowFunctionInfo> windowFunctions = Collections.synchronizedMap(new LinkedHashMap());
    static EnumMap<PrimitiveObjectInspector.PrimitiveCategory, Integer> numericTypes;
    static List<PrimitiveObjectInspector.PrimitiveCategory> numericTypeList;

    public static void registerTemporaryUDF(String functionName, Class<? extends UDF> UDFClass, boolean isOperator) {
        FunctionRegistry.registerUDF(false, functionName, UDFClass, isOperator);
    }

    static void registerUDF(String functionName, Class<? extends UDF> UDFClass, boolean isOperator) {
        FunctionRegistry.registerUDF(true, functionName, UDFClass, isOperator);
    }

    public static void registerUDF(boolean isNative, String functionName, Class<? extends UDF> UDFClass, boolean isOperator) {
        FunctionRegistry.registerUDF(isNative, functionName, UDFClass, isOperator, functionName.toLowerCase());
    }

    public static void registerUDF(String functionName, Class<? extends UDF> UDFClass, boolean isOperator, String displayName) {
        FunctionRegistry.registerUDF(true, functionName, UDFClass, isOperator, displayName);
    }

    public static void registerUDF(boolean isNative, String functionName, Class<? extends UDF> UDFClass, boolean isOperator, String displayName) {
        if (!UDF.class.isAssignableFrom(UDFClass)) {
            throw new RuntimeException("Registering UDF Class " + UDFClass + " which does not extend " + UDF.class);
        }
        FunctionInfo fI = new FunctionInfo(isNative, displayName, new GenericUDFBridge(displayName, isOperator, UDFClass.getName()));
        mFunctions.put(functionName.toLowerCase(), fI);
        FunctionRegistry.registerNativeStatus(fI);
    }

    public static void registerTemporaryGenericUDF(String functionName, Class<? extends GenericUDF> genericUDFClass) {
        FunctionRegistry.registerGenericUDF(false, functionName, genericUDFClass);
    }

    static void registerGenericUDF(String functionName, Class<? extends GenericUDF> genericUDFClass) {
        FunctionRegistry.registerGenericUDF(true, functionName, genericUDFClass);
    }

    public static void registerGenericUDF(boolean isNative, String functionName, Class<? extends GenericUDF> genericUDFClass) {
        if (!GenericUDF.class.isAssignableFrom(genericUDFClass)) {
            throw new RuntimeException("Registering GenericUDF Class " + genericUDFClass + " which does not extend " + GenericUDF.class);
        }
        FunctionInfo fI = new FunctionInfo(isNative, functionName, (GenericUDF)ReflectionUtils.newInstance(genericUDFClass, null));
        mFunctions.put(functionName.toLowerCase(), fI);
        FunctionRegistry.registerNativeStatus(fI);
    }

    public static void registerTemporaryGenericUDTF(String functionName, Class<? extends GenericUDTF> genericUDTFClass) {
        FunctionRegistry.registerGenericUDTF(false, functionName, genericUDTFClass);
    }

    static void registerGenericUDTF(String functionName, Class<? extends GenericUDTF> genericUDTFClass) {
        FunctionRegistry.registerGenericUDTF(true, functionName, genericUDTFClass);
    }

    public static void registerGenericUDTF(boolean isNative, String functionName, Class<? extends GenericUDTF> genericUDTFClass) {
        if (!GenericUDTF.class.isAssignableFrom(genericUDTFClass)) {
            throw new RuntimeException("Registering GenericUDTF Class " + genericUDTFClass + " which does not extend " + GenericUDTF.class);
        }
        FunctionInfo fI = new FunctionInfo(isNative, functionName, (GenericUDTF)ReflectionUtils.newInstance(genericUDTFClass, null));
        mFunctions.put(functionName.toLowerCase(), fI);
        FunctionRegistry.registerNativeStatus(fI);
    }

    private static FunctionInfo getFunctionInfoFromMetastore(String functionName) {
        FunctionInfo ret;
        block10: {
            ret = null;
            try {
                String fName;
                String dbName;
                if (FunctionUtils.isQualifiedFunctionName(functionName)) {
                    String[] parts = FunctionUtils.splitQualifiedFunctionName(functionName);
                    dbName = parts[0];
                    fName = parts[1];
                } else {
                    dbName = SessionState.get().getCurrentDatabase().toLowerCase();
                    fName = functionName;
                }
                HiveConf conf = SessionState.get().getConf();
                Function func = Hive.get(conf).getFunction(dbName, fName);
                if (func == null) break block10;
                try {
                    FunctionTask.addFunctionResources(func.getResourceUris());
                }
                catch (Exception e) {
                    LOG.error((Object)("Unable to load resources for " + dbName + "." + fName + ":" + e.getMessage()), (Throwable)e);
                    return null;
                }
                Class<?> udfClass = Class.forName(func.getClassName(), true, Utilities.getSessionSpecifiedClassLoader());
                if (FunctionRegistry.registerTemporaryFunction(functionName, udfClass)) {
                    ret = mFunctions.get(functionName);
                } else {
                    LOG.error((Object)(func.getClassName() + " is not a valid UDF class and was not registered."));
                }
            }
            catch (HiveException e) {
                if ((e.getCause() == null || !(e.getCause() instanceof MetaException)) && e.getCause().getCause() != null && e.getCause().getCause() instanceof NoSuchObjectException) {
                    LOG.info((Object)("Unable to lookup UDF in metastore: " + e));
                }
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("Unable to load UDF class: " + e));
            }
        }
        return ret;
    }

    private static <T extends CommonFunctionInfo> T getQualifiedFunctionInfo(Map<String, T> mFunctions, String functionName) {
        FunctionInfo fi;
        CommonFunctionInfo functionInfo = (CommonFunctionInfo)mFunctions.get(functionName);
        if (functionInfo == null && (fi = FunctionRegistry.getFunctionInfoFromMetastore(functionName)) != null) {
            functionInfo = (CommonFunctionInfo)mFunctions.get(functionName);
        }
        if (functionInfo != null) {
            FunctionRegistry.loadFunctionResourcesIfNecessary(functionName, functionInfo);
        }
        return (T)functionInfo;
    }

    private static void checkFunctionClass(CommonFunctionInfo cfi) throws ClassNotFoundException {
        Class<?> udfClass = cfi.getFunctionClass();
        Class.forName(udfClass.getName(), true, Utilities.getSessionSpecifiedClassLoader());
    }

    private static void loadFunctionResourcesIfNecessary(String functionName, CommonFunctionInfo cfi) {
        try {
            FunctionRegistry.checkFunctionClass(cfi);
        }
        catch (Exception e) {
            LOG.debug((Object)("Attempting to reload resources for " + functionName));
            try {
                String[] parts = FunctionUtils.getQualifiedFunctionNameParts(functionName);
                HiveConf conf = SessionState.get().getConf();
                Function func = Hive.get(conf).getFunction(parts[0], parts[1]);
                if (func == null) {
                    LOG.error((Object)("Unable to reload resources for " + functionName));
                    throw e;
                }
                FunctionTask.addFunctionResources(func.getResourceUris());
                FunctionRegistry.checkFunctionClass(cfi);
            }
            catch (Exception err) {
                throw new RuntimeException(err);
            }
        }
    }

    public static String getNormalizedFunctionName(String fn) {
        return FunctionUtils.isQualifiedFunctionName(fn = fn.toLowerCase()) || mFunctions.get(fn) != null ? fn : FunctionUtils.qualifyFunctionName(fn, SessionState.get().getCurrentDatabase().toLowerCase());
    }

    private static <T extends CommonFunctionInfo> T getFunctionInfo(Map<String, T> mFunctions, String functionName) {
        functionName = functionName.toLowerCase();
        CommonFunctionInfo functionInfo = null;
        if (FunctionUtils.isQualifiedFunctionName(functionName)) {
            functionInfo = (CommonFunctionInfo)FunctionRegistry.getQualifiedFunctionInfo(mFunctions, functionName);
        } else {
            functionInfo = (CommonFunctionInfo)mFunctions.get(functionName);
            if (functionInfo == null && !FunctionUtils.isQualifiedFunctionName(functionName)) {
                String qualifiedName = FunctionUtils.qualifyFunctionName(functionName, SessionState.get().getCurrentDatabase().toLowerCase());
                functionInfo = FunctionRegistry.getQualifiedFunctionInfo(mFunctions, qualifiedName);
            }
        }
        return (T)functionInfo;
    }

    public static FunctionInfo getFunctionInfo(String functionName) throws SemanticException {
        FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo(mFunctions, functionName);
        if (functionInfo != null && functionInfo.isBlockedFunction()) {
            throw new SemanticException("UDF " + functionName + " is not allowed");
        }
        return functionInfo;
    }

    public static Set<String> getFunctionNames() {
        return FunctionRegistry.getFunctionNames(true);
    }

    private static Set<String> getFunctionNames(boolean searchMetastore) {
        Set<String> functionNames = mFunctions.keySet();
        if (searchMetastore) {
            functionNames = new HashSet<String>(functionNames);
            try {
                Hive db = FunctionRegistry.getHive();
                List<String> dbNames = db.getAllDatabases();
                for (String dbName : dbNames) {
                    List<String> funcNames = db.getFunctions(dbName, "*");
                    for (String funcName : funcNames) {
                        functionNames.add(FunctionUtils.qualifyFunctionName(funcName, dbName));
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        return functionNames;
    }

    public static Hive getHive() throws HiveException {
        return Hive.get(SessionState.get().getConf());
    }

    public static Set<String> getFunctionNames(String funcPatternStr) {
        TreeSet<String> funcNames = new TreeSet<String>();
        Pattern funcPattern = null;
        try {
            funcPattern = Pattern.compile(funcPatternStr);
        }
        catch (PatternSyntaxException e) {
            return funcNames;
        }
        for (String funcName : mFunctions.keySet()) {
            if (!funcPattern.matcher(funcName).matches()) continue;
            funcNames.add(funcName);
        }
        return funcNames;
    }

    public static Set<String> getFunctionNamesByLikePattern(String funcPatternStr) {
        String[] subpatterns;
        TreeSet<String> funcNames = new TreeSet<String>();
        Set<String> allFuncs = FunctionRegistry.getFunctionNames(true);
        for (String subpattern : subpatterns = funcPatternStr.trim().split("\\|")) {
            subpattern = "(?i)" + subpattern.replaceAll("\\*", ".*");
            try {
                Pattern patternObj = Pattern.compile(subpattern);
                for (String funcName : allFuncs) {
                    if (!patternObj.matcher(funcName).matches()) continue;
                    funcNames.add(funcName);
                }
            }
            catch (PatternSyntaxException e) {
                // empty catch block
            }
        }
        return funcNames;
    }

    public static Set<String> getFunctionSynonyms(String funcName) {
        FunctionInfo funcInfo;
        LinkedHashSet<String> synonyms = new LinkedHashSet<String>();
        try {
            funcInfo = FunctionRegistry.getFunctionInfo(funcName);
        }
        catch (SemanticException e) {
            LOG.warn((Object)("Failed to load " + funcName));
            funcInfo = null;
        }
        if (null == funcInfo) {
            return synonyms;
        }
        Class<?> funcClass = funcInfo.getFunctionClass();
        for (String name : mFunctions.keySet()) {
            if (name.equals(funcName) || !mFunctions.get(name).getFunctionClass().equals(funcClass)) continue;
            synonyms.add(name);
        }
        return synonyms;
    }

    static void registerNumericType(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory, int level) {
        numericTypeList.add(primitiveCategory);
        numericTypes.put(primitiveCategory, level);
    }

    public static boolean isNumericType(PrimitiveTypeInfo typeInfo) {
        switch (typeInfo.getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case DECIMAL: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case VARCHAR: 
            case CHAR: 
            case VOID: {
                return true;
            }
        }
        return false;
    }

    public static boolean isExactNumericType(PrimitiveTypeInfo typeInfo) {
        switch (typeInfo.getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    static int getCommonLength(int aLen, int bLen) {
        int maxLength = aLen < 0 || bLen < 0 ? -1 : Math.max(aLen, bLen);
        return maxLength;
    }

    public static TypeInfo getTypeInfoForPrimitiveCategory(PrimitiveTypeInfo a, PrimitiveTypeInfo b, PrimitiveObjectInspector.PrimitiveCategory typeCategory) {
        switch (typeCategory) {
            case CHAR: {
                int maxLength = FunctionRegistry.getCommonLength(TypeInfoUtils.getCharacterLengthForType(a), TypeInfoUtils.getCharacterLengthForType(b));
                return TypeInfoFactory.getCharTypeInfo(maxLength);
            }
            case VARCHAR: {
                int maxLength = FunctionRegistry.getCommonLength(TypeInfoUtils.getCharacterLengthForType(a), TypeInfoUtils.getCharacterLengthForType(b));
                return TypeInfoFactory.getVarcharTypeInfo(maxLength);
            }
            case DECIMAL: {
                return HiveDecimalUtils.getDecimalTypeForPrimitiveCategories(a, b);
            }
        }
        return TypeInfoFactory.getPrimitiveTypeInfo(PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveCategory((PrimitiveObjectInspector.PrimitiveCategory)typeCategory).typeName);
    }

    public static TypeInfo getCommonClassForUnionAll(TypeInfo a, TypeInfo b) {
        PrimitiveObjectInspector.PrimitiveCategory pcB;
        if (a.equals(b)) {
            return a;
        }
        if (a.getCategory() != ObjectInspector.Category.PRIMITIVE || b.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return null;
        }
        PrimitiveObjectInspector.PrimitiveCategory pcA = ((PrimitiveTypeInfo)a).getPrimitiveCategory();
        if (pcA == (pcB = ((PrimitiveTypeInfo)b).getPrimitiveCategory())) {
            return FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)a, (PrimitiveTypeInfo)b, pcA);
        }
        PrimitiveObjectInspectorUtils.PrimitiveGrouping pgA = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(pcA);
        PrimitiveObjectInspectorUtils.PrimitiveGrouping pgB = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(pcB);
        if (pgA == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP && pgB == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
            return FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)a, (PrimitiveTypeInfo)b, PrimitiveObjectInspector.PrimitiveCategory.STRING);
        }
        if (FunctionRegistry.implicitConvertible(a, b)) {
            return FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)a, (PrimitiveTypeInfo)b, pcB);
        }
        if (FunctionRegistry.implicitConvertible(b, a)) {
            return FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)a, (PrimitiveTypeInfo)b, pcA);
        }
        for (PrimitiveObjectInspector.PrimitiveCategory t : numericTypeList) {
            if (!FunctionRegistry.implicitConvertible(pcA, t) || !FunctionRegistry.implicitConvertible(pcB, t)) continue;
            return FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)a, (PrimitiveTypeInfo)b, t);
        }
        return null;
    }

    public static TypeInfo getCommonClassForComparison(TypeInfo a, TypeInfo b) {
        PrimitiveObjectInspector.PrimitiveCategory pcB;
        if (a.equals(b)) {
            return a;
        }
        if (a.getCategory() != ObjectInspector.Category.PRIMITIVE || b.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return null;
        }
        PrimitiveObjectInspector.PrimitiveCategory pcA = ((PrimitiveTypeInfo)a).getPrimitiveCategory();
        if (pcA == (pcB = ((PrimitiveTypeInfo)b).getPrimitiveCategory())) {
            return FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)a, (PrimitiveTypeInfo)b, pcA);
        }
        PrimitiveObjectInspectorUtils.PrimitiveGrouping pgA = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(pcA);
        PrimitiveObjectInspectorUtils.PrimitiveGrouping pgB = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(pcB);
        if (pgA == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP && pgB == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
            return FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)a, (PrimitiveTypeInfo)b, PrimitiveObjectInspector.PrimitiveCategory.STRING);
        }
        if (!(pgA != PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP && pgB != PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP || pcA != PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP && pcB != PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP)) {
            return TypeInfoFactory.doubleTypeInfo;
        }
        for (PrimitiveObjectInspector.PrimitiveCategory t : numericTypeList) {
            if (!FunctionRegistry.implicitConvertible(pcA, t) || !FunctionRegistry.implicitConvertible(pcB, t)) continue;
            return FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)a, (PrimitiveTypeInfo)b, t);
        }
        return null;
    }

    public static PrimitiveObjectInspector.PrimitiveCategory getCommonCategory(TypeInfo a, TypeInfo b) {
        if (a.getCategory() != ObjectInspector.Category.PRIMITIVE || b.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return null;
        }
        PrimitiveObjectInspector.PrimitiveCategory pcA = ((PrimitiveTypeInfo)a).getPrimitiveCategory();
        PrimitiveObjectInspector.PrimitiveCategory pcB = ((PrimitiveTypeInfo)b).getPrimitiveCategory();
        PrimitiveObjectInspectorUtils.PrimitiveGrouping pgA = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(pcA);
        PrimitiveObjectInspectorUtils.PrimitiveGrouping pgB = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(pcB);
        if (pgA == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP && pgB == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
            return PrimitiveObjectInspector.PrimitiveCategory.STRING;
        }
        Integer ai = numericTypes.get((Object)pcA);
        Integer bi = numericTypes.get((Object)pcB);
        if (ai == null || bi == null) {
            return null;
        }
        return ai > bi ? pcA : pcB;
    }

    public static TypeInfo getCommonClass(TypeInfo a, TypeInfo b) {
        if (a.equals(b)) {
            return a;
        }
        PrimitiveObjectInspector.PrimitiveCategory commonCat = FunctionRegistry.getCommonCategory(a, b);
        if (commonCat == null) {
            return null;
        }
        return FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)a, (PrimitiveTypeInfo)b, commonCat);
    }

    public static boolean implicitConvertible(PrimitiveObjectInspector.PrimitiveCategory from, PrimitiveObjectInspector.PrimitiveCategory to) {
        if (from == to) {
            return true;
        }
        PrimitiveObjectInspectorUtils.PrimitiveGrouping fromPg = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(from);
        PrimitiveObjectInspectorUtils.PrimitiveGrouping toPg = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(to);
        if (fromPg == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP && to == PrimitiveObjectInspector.PrimitiveCategory.DOUBLE) {
            return true;
        }
        if (fromPg == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP && to == PrimitiveObjectInspector.PrimitiveCategory.DECIMAL) {
            return true;
        }
        if (from == PrimitiveObjectInspector.PrimitiveCategory.VOID) {
            return true;
        }
        if (fromPg == PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP && toPg == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
            return true;
        }
        if (fromPg == PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP && toPg == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
            return true;
        }
        if (fromPg == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP && toPg == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
            return true;
        }
        Integer f = numericTypes.get((Object)from);
        Integer t = numericTypes.get((Object)to);
        if (f == null || t == null) {
            return false;
        }
        return f <= t;
    }

    public static boolean implicitConvertible(TypeInfo from, TypeInfo to) {
        if (from.equals(to)) {
            return true;
        }
        if (from.getCategory() == ObjectInspector.Category.PRIMITIVE && to.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            return FunctionRegistry.implicitConvertible(((PrimitiveTypeInfo)from).getPrimitiveCategory(), ((PrimitiveTypeInfo)to).getPrimitiveCategory());
        }
        return false;
    }

    public static GenericUDAFEvaluator getGenericUDAFEvaluator(String name, List<ObjectInspector> argumentOIs, boolean isDistinct, boolean isAllColumns) throws SemanticException {
        GenericUDAFResolver udafResolver = FunctionRegistry.getGenericUDAFResolver(name);
        if (udafResolver == null) {
            return null;
        }
        GenericUDAFEvaluator udafEvaluator = null;
        ObjectInspector[] args = new ObjectInspector[argumentOIs.size()];
        for (int ii = 0; ii < argumentOIs.size(); ++ii) {
            args[ii] = argumentOIs.get(ii);
        }
        SimpleGenericUDAFParameterInfo paramInfo = new SimpleGenericUDAFParameterInfo(args, isDistinct, isAllColumns);
        udafEvaluator = udafResolver instanceof GenericUDAFResolver2 ? ((GenericUDAFResolver2)udafResolver).getEvaluator(paramInfo) : udafResolver.getEvaluator(paramInfo.getParameters());
        return udafEvaluator;
    }

    public static GenericUDAFEvaluator getGenericWindowingEvaluator(String name, List<ObjectInspector> argumentOIs, boolean isDistinct, boolean isAllColumns) throws SemanticException {
        WindowFunctionInfo finfo = windowFunctions.get(name.toLowerCase());
        if (finfo == null) {
            return null;
        }
        if (!name.toLowerCase().equals(LEAD_FUNC_NAME) && !name.toLowerCase().equals(LAG_FUNC_NAME)) {
            return FunctionRegistry.getGenericUDAFEvaluator(name, argumentOIs, isDistinct, isAllColumns);
        }
        ObjectInspector[] args = new ObjectInspector[argumentOIs.size()];
        GenericUDAFResolver udafResolver = finfo.getfInfo().getGenericUDAFResolver();
        SimpleGenericUDAFParameterInfo paramInfo = new SimpleGenericUDAFParameterInfo(argumentOIs.toArray(args), isDistinct, isAllColumns);
        return ((GenericUDAFResolver2)udafResolver).getEvaluator(paramInfo);
    }

    public static <T> Method getMethodInternal(Class<? extends T> udfClass, String methodName, boolean exact, List<TypeInfo> argumentClasses) throws UDFArgumentException {
        ArrayList<Method> mlist = new ArrayList<Method>();
        for (Method m : udfClass.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            mlist.add(m);
        }
        return FunctionRegistry.getMethodInternal(udfClass, mlist, exact, argumentClasses);
    }

    public static void registerTemporaryGenericUDAF(String functionName, GenericUDAFResolver genericUDAFResolver) {
        FunctionRegistry.registerGenericUDAF(false, functionName, genericUDAFResolver);
    }

    static void registerGenericUDAF(String functionName, GenericUDAFResolver genericUDAFResolver) {
        FunctionRegistry.registerGenericUDAF(true, functionName, genericUDAFResolver);
    }

    public static void registerGenericUDAF(boolean isNative, String functionName, GenericUDAFResolver genericUDAFResolver) {
        FunctionInfo fi = new FunctionInfo(isNative, functionName.toLowerCase(), genericUDAFResolver);
        mFunctions.put(functionName.toLowerCase(), fi);
        FunctionRegistry.addFunctionInfoToWindowFunctions(functionName, fi);
        FunctionRegistry.registerNativeStatus(fi);
    }

    public static void registerTemporaryUDAF(String functionName, Class<? extends UDAF> udafClass) {
        FunctionRegistry.registerUDAF(false, functionName, udafClass);
    }

    static void registerUDAF(String functionName, Class<? extends UDAF> udafClass) {
        FunctionRegistry.registerUDAF(true, functionName, udafClass);
    }

    public static void registerUDAF(boolean isNative, String functionName, Class<? extends UDAF> udafClass) {
        FunctionInfo fi = new FunctionInfo(isNative, functionName.toLowerCase(), new GenericUDAFBridge((UDAF)ReflectionUtils.newInstance(udafClass, null)));
        mFunctions.put(functionName.toLowerCase(), fi);
        FunctionRegistry.addFunctionInfoToWindowFunctions(functionName, fi);
        FunctionRegistry.registerNativeStatus(fi);
    }

    public static void unregisterTemporaryUDF(String functionName) throws HiveException {
        FunctionInfo fi = mFunctions.get(functionName.toLowerCase());
        if (fi != null) {
            if (!fi.isNative()) {
                mFunctions.remove(functionName.toLowerCase());
            } else {
                throw new HiveException("Function " + functionName + " is hive native, it can't be dropped");
            }
        }
    }

    public static GenericUDAFResolver getGenericUDAFResolver(String functionName) throws SemanticException {
        FunctionInfo finfo;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Looking up GenericUDAF: " + functionName));
        }
        if ((finfo = FunctionRegistry.getFunctionInfo(functionName)) == null) {
            return null;
        }
        GenericUDAFResolver result = finfo.getGenericUDAFResolver();
        return result;
    }

    public static Object invoke(Method m, Object thisObject, Object ... arguments) throws HiveException {
        Object o;
        try {
            o = m.invoke(thisObject, arguments);
        }
        catch (Exception e) {
            String thisObjectString = "" + thisObject + " of class " + (thisObject == null ? "null" : thisObject.getClass().getName());
            StringBuilder argumentString = new StringBuilder();
            if (arguments == null) {
                argumentString.append("null");
            } else {
                argumentString.append("{");
                for (int i = 0; i < arguments.length; ++i) {
                    if (i > 0) {
                        argumentString.append(", ");
                    }
                    if (arguments[i] == null) {
                        argumentString.append("null");
                        continue;
                    }
                    argumentString.append("" + arguments[i] + ":" + arguments[i].getClass().getName());
                }
                argumentString.append("} of size " + arguments.length);
            }
            throw new HiveException("Unable to execute method " + m + " " + " on object " + thisObjectString + " with arguments " + argumentString.toString(), e);
        }
        return o;
    }

    public static int matchCost(TypeInfo argumentPassed, TypeInfo argumentAccepted, boolean exact) {
        if (argumentAccepted.equals(argumentPassed) || TypeInfoUtils.doPrimitiveCategoriesMatch(argumentPassed, argumentAccepted)) {
            return 0;
        }
        if (argumentPassed.equals(TypeInfoFactory.voidTypeInfo)) {
            return 0;
        }
        if (argumentPassed.getCategory().equals((Object)ObjectInspector.Category.LIST) && argumentAccepted.getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            TypeInfo argumentPassedElement = ((ListTypeInfo)argumentPassed).getListElementTypeInfo();
            TypeInfo argumentAcceptedElement = ((ListTypeInfo)argumentAccepted).getListElementTypeInfo();
            return FunctionRegistry.matchCost(argumentPassedElement, argumentAcceptedElement, exact);
        }
        if (argumentPassed.getCategory().equals((Object)ObjectInspector.Category.MAP) && argumentAccepted.getCategory().equals((Object)ObjectInspector.Category.MAP)) {
            TypeInfo argumentPassedKey = ((MapTypeInfo)argumentPassed).getMapKeyTypeInfo();
            TypeInfo argumentAcceptedKey = ((MapTypeInfo)argumentAccepted).getMapKeyTypeInfo();
            TypeInfo argumentPassedValue = ((MapTypeInfo)argumentPassed).getMapValueTypeInfo();
            TypeInfo argumentAcceptedValue = ((MapTypeInfo)argumentAccepted).getMapValueTypeInfo();
            int cost1 = FunctionRegistry.matchCost(argumentPassedKey, argumentAcceptedKey, exact);
            int cost2 = FunctionRegistry.matchCost(argumentPassedValue, argumentAcceptedValue, exact);
            if (cost1 < 0 || cost2 < 0) {
                return -1;
            }
            return Math.max(cost1, cost2);
        }
        if (argumentAccepted.equals(TypeInfoFactory.unknownTypeInfo)) {
            return 1;
        }
        if (!exact && FunctionRegistry.implicitConvertible(argumentPassed, argumentAccepted)) {
            return 1;
        }
        return -1;
    }

    static void filterMethodsByTypeAffinity(List<Method> udfMethods, List<TypeInfo> argumentsPassed) {
        if (udfMethods.size() > 1) {
            int currentScore = 0;
            int bestMatchScore = 0;
            Method bestMatch = null;
            for (Method m : udfMethods) {
                currentScore = 0;
                List<TypeInfo> argumentsAccepted = TypeInfoUtils.getParameterTypeInfos(m, argumentsPassed.size());
                Iterator<TypeInfo> argsPassedIter = argumentsPassed.iterator();
                for (TypeInfo acceptedType : argumentsAccepted) {
                    PrimitiveObjectInspectorUtils.PrimitiveGrouping passedPg;
                    PrimitiveObjectInspectorUtils.PrimitiveGrouping acceptedPg;
                    TypeInfo passedType = argsPassedIter.next();
                    if (acceptedType.getCategory() != ObjectInspector.Category.PRIMITIVE || passedType.getCategory() != ObjectInspector.Category.PRIMITIVE || (acceptedPg = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(((PrimitiveTypeInfo)acceptedType).getPrimitiveCategory())) != (passedPg = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(((PrimitiveTypeInfo)passedType).getPrimitiveCategory()))) continue;
                    ++currentScore;
                }
                if (currentScore > bestMatchScore) {
                    bestMatchScore = currentScore;
                    bestMatch = m;
                    continue;
                }
                if (currentScore != bestMatchScore) continue;
                bestMatch = null;
            }
            if (bestMatch != null) {
                udfMethods.clear();
                udfMethods.add(bestMatch);
            }
        }
    }

    public static Method getMethodInternal(Class<?> udfClass, List<Method> mlist, boolean exact, List<TypeInfo> argumentsPassed) throws UDFArgumentException {
        ArrayList<Method> udfMethods = new ArrayList<Method>();
        int leastConversionCost = Integer.MAX_VALUE;
        for (Method m : mlist) {
            List<TypeInfo> argumentsAccepted = TypeInfoUtils.getParameterTypeInfos(m, argumentsPassed.size());
            if (argumentsAccepted == null) continue;
            boolean match = argumentsAccepted.size() == argumentsPassed.size();
            int conversionCost = 0;
            for (int i = 0; i < argumentsPassed.size() && match; ++i) {
                int cost = FunctionRegistry.matchCost(argumentsPassed.get(i), argumentsAccepted.get(i), exact);
                if (cost == -1) {
                    match = false;
                    continue;
                }
                conversionCost += cost;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Method " + (match ? "did" : "didn't") + " match: passed = " + argumentsPassed + " accepted = " + argumentsAccepted + " method = " + m));
            }
            if (!match) continue;
            if (conversionCost < leastConversionCost) {
                udfMethods.clear();
                udfMethods.add(m);
                leastConversionCost = conversionCost;
                if (leastConversionCost != 0) continue;
                break;
            }
            if (conversionCost != leastConversionCost) continue;
            udfMethods.add(m);
        }
        if (udfMethods.size() == 0) {
            throw new NoMatchingMethodException(udfClass, argumentsPassed, mlist);
        }
        if (udfMethods.size() > 1) {
            FunctionRegistry.filterMethodsByTypeAffinity(udfMethods, argumentsPassed);
        }
        if (udfMethods.size() > 1) {
            int lowestNumericType = Integer.MAX_VALUE;
            boolean multiple = true;
            Method candidate = null;
            List<TypeInfo> referenceArguments = null;
            for (Method m : udfMethods) {
                int maxNumericType = 0;
                List<TypeInfo> argumentsAccepted = TypeInfoUtils.getParameterTypeInfos(m, argumentsPassed.size());
                if (referenceArguments == null) {
                    referenceArguments = argumentsAccepted;
                }
                Iterator<TypeInfo> referenceIterator = referenceArguments.iterator();
                for (TypeInfo accepted : argumentsAccepted) {
                    TypeInfo reference = referenceIterator.next();
                    boolean acceptedIsPrimitive = false;
                    PrimitiveObjectInspector.PrimitiveCategory acceptedPrimCat = PrimitiveObjectInspector.PrimitiveCategory.UNKNOWN;
                    if (accepted.getCategory() == ObjectInspector.Category.PRIMITIVE) {
                        acceptedIsPrimitive = true;
                        acceptedPrimCat = ((PrimitiveTypeInfo)accepted).getPrimitiveCategory();
                    }
                    if (acceptedIsPrimitive && numericTypes.containsKey((Object)acceptedPrimCat)) {
                        int typeValue = numericTypes.get((Object)acceptedPrimCat);
                        maxNumericType = typeValue > maxNumericType ? typeValue : maxNumericType;
                        continue;
                    }
                    if (accepted.equals(reference)) continue;
                    throw new AmbiguousMethodException(udfClass, argumentsPassed, mlist);
                }
                if (lowestNumericType > maxNumericType) {
                    multiple = false;
                    lowestNumericType = maxNumericType;
                    candidate = m;
                    continue;
                }
                if (maxNumericType != lowestNumericType) continue;
                multiple = true;
            }
            if (!multiple) {
                return candidate;
            }
            throw new AmbiguousMethodException(udfClass, argumentsPassed, mlist);
        }
        return (Method)udfMethods.get(0);
    }

    public static GenericUDF getGenericUDFForIndex() {
        return FunctionRegistry.getFunctionInfo(mFunctions, "index").getGenericUDF();
    }

    public static GenericUDF getGenericUDFForAnd() {
        return FunctionRegistry.getFunctionInfo(mFunctions, "and").getGenericUDF();
    }

    public static GenericUDF cloneGenericUDF(GenericUDF genericUDF) {
        GenericUDF bridge;
        if (null == genericUDF) {
            return null;
        }
        GenericUDF clonedUDF = null;
        if (genericUDF instanceof GenericUDFBridge) {
            bridge = (GenericUDFBridge)genericUDF;
            clonedUDF = new GenericUDFBridge(((GenericUDFBridge)bridge).getUdfName(), ((GenericUDFBridge)bridge).isOperator(), ((GenericUDFBridge)bridge).getUdfClassName());
        } else if (genericUDF instanceof GenericUDFMacro) {
            bridge = (GenericUDFMacro)genericUDF;
            clonedUDF = new GenericUDFMacro(((GenericUDFMacro)bridge).getMacroName(), ((GenericUDFMacro)bridge).getBody(), ((GenericUDFMacro)bridge).getColNames(), ((GenericUDFMacro)bridge).getColTypes());
        } else {
            clonedUDF = (GenericUDF)ReflectionUtils.newInstance(genericUDF.getClass(), null);
        }
        if (clonedUDF != null) {
            try {
                genericUDF.copyToNewInstance(clonedUDF);
            }
            catch (UDFArgumentException err) {
                throw new IllegalArgumentException(err);
            }
            if (genericUDF instanceof SettableUDF) {
                try {
                    TypeInfo typeInfo = ((SettableUDF)((Object)genericUDF)).getTypeInfo();
                    if (typeInfo != null) {
                        ((SettableUDF)((Object)clonedUDF)).setTypeInfo(typeInfo);
                    }
                }
                catch (UDFArgumentException err) {
                    LOG.error((Object)("Unable to add settable data to UDF " + genericUDF.getClass()));
                    throw new IllegalArgumentException(err);
                }
            }
        }
        return clonedUDF;
    }

    public static GenericUDTF cloneGenericUDTF(GenericUDTF genericUDTF) {
        if (null == genericUDTF) {
            return null;
        }
        return (GenericUDTF)ReflectionUtils.newInstance(genericUDTF.getClass(), null);
    }

    private static Class<? extends GenericUDF> getGenericUDFClassFromExprDesc(ExprNodeDesc desc) {
        if (!(desc instanceof ExprNodeGenericFuncDesc)) {
            return null;
        }
        ExprNodeGenericFuncDesc genericFuncDesc = (ExprNodeGenericFuncDesc)desc;
        return genericFuncDesc.getGenericUDF().getClass();
    }

    private static Class<? extends GenericUDF> getUDFClassFromExprDesc(ExprNodeDesc desc) {
        if (!(desc instanceof ExprNodeGenericFuncDesc)) {
            return null;
        }
        ExprNodeGenericFuncDesc genericFuncDesc = (ExprNodeGenericFuncDesc)desc;
        return genericFuncDesc.getGenericUDF().getClass();
    }

    public static boolean isDeterministic(GenericUDF genericUDF) {
        GenericUDFBridge bridge;
        UDFType bridgeUDFType;
        if (FunctionRegistry.isStateful(genericUDF)) {
            return false;
        }
        UDFType genericUDFType = AnnotationUtils.getAnnotation(genericUDF.getClass(), UDFType.class);
        if (genericUDFType != null && !genericUDFType.deterministic()) {
            return false;
        }
        if (genericUDF instanceof GenericUDFBridge && (bridgeUDFType = AnnotationUtils.getAnnotation((bridge = (GenericUDFBridge)genericUDF).getUdfClass(), UDFType.class)) != null && !bridgeUDFType.deterministic()) {
            return false;
        }
        if (genericUDF instanceof GenericUDFMacro) {
            GenericUDFMacro macro = (GenericUDFMacro)genericUDF;
            return macro.isDeterministic();
        }
        return true;
    }

    public static boolean isStateful(GenericUDF genericUDF) {
        GenericUDFBridge bridge;
        UDFType bridgeUDFType;
        UDFType genericUDFType = AnnotationUtils.getAnnotation(genericUDF.getClass(), UDFType.class);
        if (genericUDFType != null && genericUDFType.stateful()) {
            return true;
        }
        if (genericUDF instanceof GenericUDFBridge && (bridgeUDFType = AnnotationUtils.getAnnotation((bridge = (GenericUDFBridge)genericUDF).getUdfClass(), UDFType.class)) != null && bridgeUDFType.stateful()) {
            return true;
        }
        if (genericUDF instanceof GenericUDFMacro) {
            GenericUDFMacro macro = (GenericUDFMacro)genericUDF;
            return macro.isStateful();
        }
        return false;
    }

    public static boolean isOpAndOrNot(ExprNodeDesc desc) {
        Class<? extends GenericUDF> genericUdfClass = FunctionRegistry.getGenericUDFClassFromExprDesc(desc);
        return GenericUDFOPAnd.class == genericUdfClass || GenericUDFOPOr.class == genericUdfClass || GenericUDFOPNot.class == genericUdfClass;
    }

    public static boolean isOpAnd(ExprNodeDesc desc) {
        return GenericUDFOPAnd.class == FunctionRegistry.getGenericUDFClassFromExprDesc(desc);
    }

    public static boolean isOpOr(ExprNodeDesc desc) {
        return GenericUDFOPOr.class == FunctionRegistry.getGenericUDFClassFromExprDesc(desc);
    }

    public static boolean isOpNot(ExprNodeDesc desc) {
        return GenericUDFOPNot.class == FunctionRegistry.getGenericUDFClassFromExprDesc(desc);
    }

    public static boolean isOpPositive(ExprNodeDesc desc) {
        Class<? extends GenericUDF> udfClass = FunctionRegistry.getUDFClassFromExprDesc(desc);
        return GenericUDFOPPositive.class == udfClass;
    }

    public static boolean isOpCast(ExprNodeDesc desc) {
        if (!(desc instanceof ExprNodeGenericFuncDesc)) {
            return false;
        }
        return FunctionRegistry.isOpCast(((ExprNodeGenericFuncDesc)desc).getGenericUDF());
    }

    public static boolean isOpCast(GenericUDF genericUDF) {
        Class<Object> udfClass = genericUDF instanceof GenericUDFBridge ? ((GenericUDFBridge)genericUDF).getUdfClass() : genericUDF.getClass();
        return udfClass == UDFToBoolean.class || udfClass == UDFToByte.class || udfClass == UDFToDouble.class || udfClass == UDFToFloat.class || udfClass == UDFToInteger.class || udfClass == UDFToLong.class || udfClass == UDFToShort.class || udfClass == UDFToString.class || udfClass == GenericUDFToVarchar.class || udfClass == GenericUDFToChar.class || udfClass == GenericUDFTimestamp.class || udfClass == GenericUDFToBinary.class || udfClass == GenericUDFToDate.class || udfClass == GenericUDFToDecimal.class;
    }

    public static boolean isOpPreserveInputName(ExprNodeDesc desc) {
        return FunctionRegistry.isOpCast(desc);
    }

    public static boolean registerTemporaryFunction(String functionName, Class<?> udfClass) {
        FunctionUtils.UDFClassType udfClassType = FunctionUtils.getUDFClassType(udfClass);
        switch (udfClassType) {
            case UDF: {
                FunctionRegistry.registerTemporaryUDF(functionName, udfClass, false);
                break;
            }
            case GENERIC_UDF: {
                FunctionRegistry.registerTemporaryGenericUDF(functionName, udfClass);
                break;
            }
            case GENERIC_UDTF: {
                FunctionRegistry.registerTemporaryGenericUDTF(functionName, udfClass);
                break;
            }
            case UDAF: {
                FunctionRegistry.registerTemporaryUDAF(functionName, udfClass);
                break;
            }
            case GENERIC_UDAF_RESOLVER: {
                FunctionRegistry.registerTemporaryGenericUDAF(functionName, (GenericUDAFResolver)ReflectionUtils.newInstance(udfClass, null));
                break;
            }
            case TABLE_FUNCTION_RESOLVER: {
                FunctionRegistry.registerTableFunction(functionName, udfClass);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static void registerTemporaryMacro(String macroName, ExprNodeDesc body, List<String> colNames, List<TypeInfo> colTypes) {
        FunctionInfo fI = new FunctionInfo(false, macroName, new GenericUDFMacro(macroName, body, colNames, colTypes));
        mFunctions.put(macroName.toLowerCase(), fI);
        FunctionRegistry.registerNativeStatus(fI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerFunctionsFromPluginJar(URL jarLocation, ClassLoader classLoader) throws Exception {
        URL url = new URL("jar:" + jarLocation + "!/META-INF/class-info.xml");
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            Document doc = docBuilder.parse(inputStream);
            Element root = doc.getDocumentElement();
            if (!root.getTagName().equals("ClassList")) {
                return;
            }
            NodeList children = root.getElementsByTagName("Class");
            for (int i = 0; i < children.getLength(); ++i) {
                Class<?> udfClass;
                Element child = (Element)children.item(i);
                String javaName = child.getAttribute("javaname");
                String sqlName = child.getAttribute("sqlname");
                boolean registered = FunctionRegistry.registerTemporaryFunction(sqlName, udfClass = Class.forName(javaName, true, classLoader));
                if (registered) continue;
                throw new RuntimeException("Class " + udfClass + " is not a Hive function implementation");
            }
        }
        finally {
            IOUtils.closeStream((Closeable)inputStream);
        }
    }

    private FunctionRegistry() {
    }

    public static void registerWindowFunction(String name, GenericUDAFResolver wFn) {
        FunctionRegistry.registerWindowFunction(name, wFn, true);
    }

    public static void registerWindowFunction(String name, GenericUDAFResolver wFn, boolean registerAsUDAF) {
        FunctionInfo fInfo = null;
        if (registerAsUDAF) {
            FunctionRegistry.registerGenericUDAF(true, name, wFn);
        } else {
            name = name.toLowerCase();
            fInfo = new FunctionInfo(true, name, wFn);
            FunctionRegistry.addFunctionInfoToWindowFunctions(name, fInfo);
        }
    }

    public static WindowFunctionInfo getWindowFunctionInfo(String functionName) {
        return FunctionRegistry.getFunctionInfo(windowFunctions, functionName);
    }

    public static boolean impliesOrder(String functionName) throws SemanticException {
        UDFType type;
        FunctionInfo info = FunctionRegistry.getFunctionInfo(functionName);
        if (info != null && info.isGenericUDF() && (type = AnnotationUtils.getAnnotation(info.getGenericUDF().getClass(), UDFType.class)) != null) {
            return type.impliesOrder();
        }
        WindowFunctionInfo windowInfo = FunctionRegistry.getWindowFunctionInfo(functionName);
        if (windowInfo != null) {
            return windowInfo.isImpliesOrder();
        }
        return false;
    }

    private static void addFunctionInfoToWindowFunctions(String functionName, FunctionInfo functionInfo) {
        WindowFunctionInfo wInfo = new WindowFunctionInfo(functionInfo);
        windowFunctions.put(functionName.toLowerCase(), wInfo);
    }

    public static boolean isTableFunction(String name) throws SemanticException {
        FunctionInfo tFInfo = FunctionRegistry.getFunctionInfo(name);
        return tFInfo != null && !tFInfo.isInternalTableFunction() && tFInfo.isTableFunction();
    }

    public static TableFunctionResolver getTableFunctionResolver(String name) throws SemanticException {
        FunctionInfo tfInfo = FunctionRegistry.getFunctionInfo(name);
        if (tfInfo.isTableFunction()) {
            return (TableFunctionResolver)ReflectionUtils.newInstance(tfInfo.getFunctionClass(), null);
        }
        return null;
    }

    public static TableFunctionResolver getWindowingTableFunction() throws SemanticException {
        return FunctionRegistry.getTableFunctionResolver(WINDOWING_TABLE_FUNCTION);
    }

    public static boolean isNoopFunction(String fnName) {
        return (fnName = fnName.toLowerCase()).equals(NOOP_MAP_TABLE_FUNCTION) || fnName.equals(NOOP_STREAMING_MAP_TABLE_FUNCTION) || fnName.equals(NOOP_TABLE_FUNCTION) || fnName.equals(NOOP_STREAMING_TABLE_FUNCTION);
    }

    public static void registerTableFunction(String name, Class<? extends TableFunctionResolver> tFnCls) {
        FunctionInfo tInfo = new FunctionInfo(name, tFnCls);
        mFunctions.put(name.toLowerCase(), tInfo);
        FunctionRegistry.registerNativeStatus(tInfo);
    }

    public static boolean isRankingFunction(String name) throws SemanticException {
        FunctionInfo info = FunctionRegistry.getFunctionInfo(name);
        if (info == null) {
            return false;
        }
        GenericUDAFResolver res = info.getGenericUDAFResolver();
        if (res == null) {
            return false;
        }
        WindowFunctionDescription desc = AnnotationUtils.getAnnotation(res.getClass(), WindowFunctionDescription.class);
        return desc != null && desc.rankingFunction();
    }

    public static boolean isNativeFuncExpr(ExprNodeGenericFuncDesc fnExpr) {
        Class<? extends GenericUDF> udfClass = FunctionRegistry.getUDFClassFromExprDesc(fnExpr);
        if (udfClass == null) {
            udfClass = FunctionRegistry.getGenericUDFClassFromExprDesc(fnExpr);
        }
        return nativeUdfs.contains(udfClass);
    }

    private static void registerNativeStatus(FunctionInfo fi) {
        if (!fi.isNative()) {
            return;
        }
        nativeUdfs.add(fi.getFunctionClass());
    }

    public static void setupPermissionsForBuiltinUDFs(String whiteListStr, String blackListStr) {
        ArrayList<String> whiteList = Lists.newArrayList(Splitter.on(",").trimResults().omitEmptyStrings().split(whiteListStr));
        ArrayList<String> blackList = Lists.newArrayList(Splitter.on(",").trimResults().omitEmptyStrings().split(blackListStr));
        for (Map.Entry<String, FunctionInfo> funcEntry : mFunctions.entrySet()) {
            funcEntry.getValue().setBlockedFunction(FunctionRegistry.isUdfBlocked(funcEntry.getKey(), whiteList, blackList));
        }
    }

    private static boolean isUdfBlocked(String functionName, List<String> whiteList, List<String> blackList) {
        boolean inWhiteList = false;
        boolean inBlackList = false;
        if (whiteList.isEmpty()) {
            inWhiteList = true;
        } else {
            for (String allowedFunction : whiteList) {
                if (!functionName.equalsIgnoreCase(allowedFunction)) continue;
                inWhiteList = true;
                break;
            }
        }
        for (String blockedFunction : blackList) {
            if (!functionName.equalsIgnoreCase(blockedFunction)) continue;
            inBlackList = true;
            break;
        }
        return !inWhiteList || inBlackList;
    }

    static {
        FunctionRegistry.registerGenericUDF("concat", GenericUDFConcat.class);
        FunctionRegistry.registerUDF("substr", UDFSubstr.class, false);
        FunctionRegistry.registerUDF("substring", UDFSubstr.class, false);
        FunctionRegistry.registerUDF("space", UDFSpace.class, false);
        FunctionRegistry.registerUDF("repeat", UDFRepeat.class, false);
        FunctionRegistry.registerUDF("ascii", UDFAscii.class, false);
        FunctionRegistry.registerGenericUDF("lpad", GenericUDFLpad.class);
        FunctionRegistry.registerGenericUDF("rpad", GenericUDFRpad.class);
        FunctionRegistry.registerGenericUDF("size", GenericUDFSize.class);
        FunctionRegistry.registerGenericUDF("round", GenericUDFRound.class);
        FunctionRegistry.registerGenericUDF("floor", GenericUDFFloor.class);
        FunctionRegistry.registerUDF("sqrt", UDFSqrt.class, false);
        FunctionRegistry.registerGenericUDF("ceil", GenericUDFCeil.class);
        FunctionRegistry.registerGenericUDF("ceiling", GenericUDFCeil.class);
        FunctionRegistry.registerUDF("rand", UDFRand.class, false);
        FunctionRegistry.registerGenericUDF("abs", GenericUDFAbs.class);
        FunctionRegistry.registerGenericUDF("pmod", GenericUDFPosMod.class);
        FunctionRegistry.registerUDF("ln", UDFLn.class, false);
        FunctionRegistry.registerUDF("log2", UDFLog2.class, false);
        FunctionRegistry.registerUDF("sin", UDFSin.class, false);
        FunctionRegistry.registerUDF("asin", UDFAsin.class, false);
        FunctionRegistry.registerUDF("cos", UDFCos.class, false);
        FunctionRegistry.registerUDF("acos", UDFAcos.class, false);
        FunctionRegistry.registerUDF("log10", UDFLog10.class, false);
        FunctionRegistry.registerUDF("log", UDFLog.class, false);
        FunctionRegistry.registerUDF("exp", UDFExp.class, false);
        FunctionRegistry.registerGenericUDF("power", GenericUDFPower.class);
        FunctionRegistry.registerGenericUDF("pow", GenericUDFPower.class);
        FunctionRegistry.registerUDF("sign", UDFSign.class, false);
        FunctionRegistry.registerUDF("pi", UDFPI.class, false);
        FunctionRegistry.registerUDF("degrees", UDFDegrees.class, false);
        FunctionRegistry.registerUDF("radians", UDFRadians.class, false);
        FunctionRegistry.registerUDF("atan", UDFAtan.class, false);
        FunctionRegistry.registerUDF("tan", UDFTan.class, false);
        FunctionRegistry.registerUDF("e", UDFE.class, false);
        FunctionRegistry.registerUDF("conv", UDFConv.class, false);
        FunctionRegistry.registerUDF("bin", UDFBin.class, false);
        FunctionRegistry.registerUDF("hex", UDFHex.class, false);
        FunctionRegistry.registerUDF("unhex", UDFUnhex.class, false);
        FunctionRegistry.registerUDF("base64", UDFBase64.class, false);
        FunctionRegistry.registerUDF("unbase64", UDFUnbase64.class, false);
        FunctionRegistry.registerGenericUDF("encode", GenericUDFEncode.class);
        FunctionRegistry.registerGenericUDF("decode", GenericUDFDecode.class);
        FunctionRegistry.registerGenericUDF("upper", GenericUDFUpper.class);
        FunctionRegistry.registerGenericUDF("lower", GenericUDFLower.class);
        FunctionRegistry.registerGenericUDF("ucase", GenericUDFUpper.class);
        FunctionRegistry.registerGenericUDF("lcase", GenericUDFLower.class);
        FunctionRegistry.registerGenericUDF("trim", GenericUDFTrim.class);
        FunctionRegistry.registerGenericUDF("ltrim", GenericUDFLTrim.class);
        FunctionRegistry.registerGenericUDF("rtrim", GenericUDFRTrim.class);
        FunctionRegistry.registerUDF("length", UDFLength.class, false);
        FunctionRegistry.registerUDF("reverse", UDFReverse.class, false);
        FunctionRegistry.registerGenericUDF("field", GenericUDFField.class);
        FunctionRegistry.registerUDF("find_in_set", UDFFindInSet.class, false);
        FunctionRegistry.registerGenericUDF("initcap", GenericUDFInitCap.class);
        FunctionRegistry.registerUDF("like", UDFLike.class, true);
        FunctionRegistry.registerUDF("rlike", UDFRegExp.class, true);
        FunctionRegistry.registerUDF("regexp", UDFRegExp.class, true);
        FunctionRegistry.registerUDF("regexp_replace", UDFRegExpReplace.class, false);
        FunctionRegistry.registerUDF("regexp_extract", UDFRegExpExtract.class, false);
        FunctionRegistry.registerUDF("parse_url", UDFParseUrl.class, false);
        FunctionRegistry.registerGenericUDF("nvl", GenericUDFNvl.class);
        FunctionRegistry.registerGenericUDF("split", GenericUDFSplit.class);
        FunctionRegistry.registerGenericUDF("str_to_map", GenericUDFStringToMap.class);
        FunctionRegistry.registerGenericUDF("translate", GenericUDFTranslate.class);
        FunctionRegistry.registerGenericUDF(UNARY_PLUS_FUNC_NAME, GenericUDFOPPositive.class);
        FunctionRegistry.registerGenericUDF(UNARY_MINUS_FUNC_NAME, GenericUDFOPNegative.class);
        FunctionRegistry.registerUDF("day", UDFDayOfMonth.class, false);
        FunctionRegistry.registerUDF("dayofmonth", UDFDayOfMonth.class, false);
        FunctionRegistry.registerUDF("month", UDFMonth.class, false);
        FunctionRegistry.registerUDF("year", UDFYear.class, false);
        FunctionRegistry.registerUDF("hour", UDFHour.class, false);
        FunctionRegistry.registerUDF("minute", UDFMinute.class, false);
        FunctionRegistry.registerUDF("second", UDFSecond.class, false);
        FunctionRegistry.registerUDF("from_unixtime", UDFFromUnixTime.class, false);
        FunctionRegistry.registerGenericUDF("to_date", GenericUDFDate.class);
        FunctionRegistry.registerUDF("weekofyear", UDFWeekOfYear.class, false);
        FunctionRegistry.registerGenericUDF("last_day", GenericUDFLastDay.class);
        FunctionRegistry.registerGenericUDF("date_add", GenericUDFDateAdd.class);
        FunctionRegistry.registerGenericUDF("date_sub", GenericUDFDateSub.class);
        FunctionRegistry.registerGenericUDF("datediff", GenericUDFDateDiff.class);
        FunctionRegistry.registerGenericUDF("add_months", GenericUDFAddMonths.class);
        FunctionRegistry.registerUDF("get_json_object", UDFJson.class, false);
        FunctionRegistry.registerUDF("xpath_string", UDFXPathString.class, false);
        FunctionRegistry.registerUDF("xpath_boolean", UDFXPathBoolean.class, false);
        FunctionRegistry.registerUDF("xpath_number", UDFXPathDouble.class, false);
        FunctionRegistry.registerUDF("xpath_double", UDFXPathDouble.class, false);
        FunctionRegistry.registerUDF("xpath_float", UDFXPathFloat.class, false);
        FunctionRegistry.registerUDF("xpath_long", UDFXPathLong.class, false);
        FunctionRegistry.registerUDF("xpath_int", UDFXPathInteger.class, false);
        FunctionRegistry.registerUDF("xpath_short", UDFXPathShort.class, false);
        FunctionRegistry.registerGenericUDF("xpath", GenericUDFXPath.class);
        FunctionRegistry.registerGenericUDF("+", GenericUDFOPPlus.class);
        FunctionRegistry.registerGenericUDF("-", GenericUDFOPMinus.class);
        FunctionRegistry.registerGenericUDF("*", GenericUDFOPMultiply.class);
        FunctionRegistry.registerGenericUDF("/", GenericUDFOPDivide.class);
        FunctionRegistry.registerGenericUDF("%", GenericUDFOPMod.class);
        FunctionRegistry.registerUDF("div", UDFOPLongDivide.class, true);
        FunctionRegistry.registerUDF("&", UDFOPBitAnd.class, true);
        FunctionRegistry.registerUDF("|", UDFOPBitOr.class, true);
        FunctionRegistry.registerUDF("^", UDFOPBitXor.class, true);
        FunctionRegistry.registerUDF("~", UDFOPBitNot.class, true);
        FunctionRegistry.registerGenericUDF("current_database", UDFCurrentDB.class);
        FunctionRegistry.registerGenericUDF("isnull", GenericUDFOPNull.class);
        FunctionRegistry.registerGenericUDF("isnotnull", GenericUDFOPNotNull.class);
        FunctionRegistry.registerGenericUDF("if", GenericUDFIf.class);
        FunctionRegistry.registerGenericUDF("in", GenericUDFIn.class);
        FunctionRegistry.registerGenericUDF("and", GenericUDFOPAnd.class);
        FunctionRegistry.registerGenericUDF("or", GenericUDFOPOr.class);
        FunctionRegistry.registerGenericUDF("=", GenericUDFOPEqual.class);
        FunctionRegistry.registerGenericUDF("==", GenericUDFOPEqual.class);
        FunctionRegistry.registerGenericUDF("<=>", GenericUDFOPEqualNS.class);
        FunctionRegistry.registerGenericUDF("!=", GenericUDFOPNotEqual.class);
        FunctionRegistry.registerGenericUDF("<>", GenericUDFOPNotEqual.class);
        FunctionRegistry.registerGenericUDF("<", GenericUDFOPLessThan.class);
        FunctionRegistry.registerGenericUDF("<=", GenericUDFOPEqualOrLessThan.class);
        FunctionRegistry.registerGenericUDF(">", GenericUDFOPGreaterThan.class);
        FunctionRegistry.registerGenericUDF(">=", GenericUDFOPEqualOrGreaterThan.class);
        FunctionRegistry.registerGenericUDF("not", GenericUDFOPNot.class);
        FunctionRegistry.registerGenericUDF("!", GenericUDFOPNot.class);
        FunctionRegistry.registerGenericUDF("between", GenericUDFBetween.class);
        FunctionRegistry.registerGenericUDF("ewah_bitmap_and", GenericUDFEWAHBitmapAnd.class);
        FunctionRegistry.registerGenericUDF("ewah_bitmap_or", GenericUDFEWAHBitmapOr.class);
        FunctionRegistry.registerGenericUDF("ewah_bitmap_empty", GenericUDFEWAHBitmapEmpty.class);
        FunctionRegistry.registerUDF("boolean", UDFToBoolean.class, false, UDFToBoolean.class.getSimpleName());
        FunctionRegistry.registerUDF("tinyint", UDFToByte.class, false, UDFToByte.class.getSimpleName());
        FunctionRegistry.registerUDF("smallint", UDFToShort.class, false, UDFToShort.class.getSimpleName());
        FunctionRegistry.registerUDF("int", UDFToInteger.class, false, UDFToInteger.class.getSimpleName());
        FunctionRegistry.registerUDF("bigint", UDFToLong.class, false, UDFToLong.class.getSimpleName());
        FunctionRegistry.registerUDF("float", UDFToFloat.class, false, UDFToFloat.class.getSimpleName());
        FunctionRegistry.registerUDF("double", UDFToDouble.class, false, UDFToDouble.class.getSimpleName());
        FunctionRegistry.registerUDF("string", UDFToString.class, false, UDFToString.class.getSimpleName());
        FunctionRegistry.registerGenericUDF("date", GenericUDFToDate.class);
        FunctionRegistry.registerGenericUDF("timestamp", GenericUDFTimestamp.class);
        FunctionRegistry.registerGenericUDF("binary", GenericUDFToBinary.class);
        FunctionRegistry.registerGenericUDF("decimal", GenericUDFToDecimal.class);
        FunctionRegistry.registerGenericUDF("varchar", GenericUDFToVarchar.class);
        FunctionRegistry.registerGenericUDF("char", GenericUDFToChar.class);
        FunctionRegistry.registerGenericUDAF("max", new GenericUDAFMax());
        FunctionRegistry.registerGenericUDAF("min", new GenericUDAFMin());
        FunctionRegistry.registerGenericUDAF("sum", new GenericUDAFSum());
        FunctionRegistry.registerGenericUDAF("count", new GenericUDAFCount());
        FunctionRegistry.registerGenericUDAF("avg", new GenericUDAFAverage());
        FunctionRegistry.registerGenericUDAF("std", new GenericUDAFStd());
        FunctionRegistry.registerGenericUDAF("stddev", new GenericUDAFStd());
        FunctionRegistry.registerGenericUDAF("stddev_pop", new GenericUDAFStd());
        FunctionRegistry.registerGenericUDAF("stddev_samp", new GenericUDAFStdSample());
        FunctionRegistry.registerGenericUDAF("variance", new GenericUDAFVariance());
        FunctionRegistry.registerGenericUDAF("var_pop", new GenericUDAFVariance());
        FunctionRegistry.registerGenericUDAF("var_samp", new GenericUDAFVarianceSample());
        FunctionRegistry.registerGenericUDAF("covar_pop", new GenericUDAFCovariance());
        FunctionRegistry.registerGenericUDAF("covar_samp", new GenericUDAFCovarianceSample());
        FunctionRegistry.registerGenericUDAF("corr", new GenericUDAFCorrelation());
        FunctionRegistry.registerGenericUDAF("histogram_numeric", new GenericUDAFHistogramNumeric());
        FunctionRegistry.registerGenericUDAF("percentile_approx", new GenericUDAFPercentileApprox());
        FunctionRegistry.registerGenericUDAF("collect_set", new GenericUDAFCollectSet());
        FunctionRegistry.registerGenericUDAF("collect_list", new GenericUDAFCollectList());
        FunctionRegistry.registerGenericUDAF("ngrams", new GenericUDAFnGrams());
        FunctionRegistry.registerGenericUDAF("context_ngrams", new GenericUDAFContextNGrams());
        FunctionRegistry.registerGenericUDAF("ewah_bitmap", new GenericUDAFEWAHBitmap());
        FunctionRegistry.registerGenericUDAF("compute_stats", new GenericUDAFComputeStats());
        FunctionRegistry.registerUDAF("percentile", UDAFPercentile.class);
        FunctionRegistry.registerGenericUDF("reflect", GenericUDFReflect.class);
        FunctionRegistry.registerGenericUDF("reflect2", GenericUDFReflect2.class);
        FunctionRegistry.registerGenericUDF("java_method", GenericUDFReflect.class);
        FunctionRegistry.registerGenericUDF("array", GenericUDFArray.class);
        FunctionRegistry.registerGenericUDF("assert_true", GenericUDFAssertTrue.class);
        FunctionRegistry.registerGenericUDF("map", GenericUDFMap.class);
        FunctionRegistry.registerGenericUDF("struct", GenericUDFStruct.class);
        FunctionRegistry.registerGenericUDF("named_struct", GenericUDFNamedStruct.class);
        FunctionRegistry.registerGenericUDF("create_union", GenericUDFUnion.class);
        FunctionRegistry.registerGenericUDF("case", GenericUDFCase.class);
        FunctionRegistry.registerGenericUDF("when", GenericUDFWhen.class);
        FunctionRegistry.registerGenericUDF("hash", GenericUDFHash.class);
        FunctionRegistry.registerGenericUDF("coalesce", GenericUDFCoalesce.class);
        FunctionRegistry.registerGenericUDF("index", GenericUDFIndex.class);
        FunctionRegistry.registerGenericUDF("in_file", GenericUDFInFile.class);
        FunctionRegistry.registerGenericUDF("instr", GenericUDFInstr.class);
        FunctionRegistry.registerGenericUDF("locate", GenericUDFLocate.class);
        FunctionRegistry.registerGenericUDF("elt", GenericUDFElt.class);
        FunctionRegistry.registerGenericUDF("concat_ws", GenericUDFConcatWS.class);
        FunctionRegistry.registerGenericUDF("sort_array", GenericUDFSortArray.class);
        FunctionRegistry.registerGenericUDF("array_contains", GenericUDFArrayContains.class);
        FunctionRegistry.registerGenericUDF("sentences", GenericUDFSentences.class);
        FunctionRegistry.registerGenericUDF("map_keys", GenericUDFMapKeys.class);
        FunctionRegistry.registerGenericUDF("map_values", GenericUDFMapValues.class);
        FunctionRegistry.registerGenericUDF("format_number", GenericUDFFormatNumber.class);
        FunctionRegistry.registerGenericUDF("printf", GenericUDFPrintf.class);
        FunctionRegistry.registerGenericUDF("greatest", GenericUDFGreatest.class);
        FunctionRegistry.registerGenericUDF("least", GenericUDFLeast.class);
        FunctionRegistry.registerGenericUDF("from_utc_timestamp", GenericUDFFromUtcTimestamp.class);
        FunctionRegistry.registerGenericUDF("to_utc_timestamp", GenericUDFToUtcTimestamp.class);
        FunctionRegistry.registerGenericUDF("unix_timestamp", GenericUDFUnixTimeStamp.class);
        FunctionRegistry.registerGenericUDF("to_unix_timestamp", GenericUDFToUnixTimeStamp.class);
        FunctionRegistry.registerGenericUDTF("explode", GenericUDTFExplode.class);
        FunctionRegistry.registerGenericUDTF("inline", GenericUDTFInline.class);
        FunctionRegistry.registerGenericUDTF("json_tuple", GenericUDTFJSONTuple.class);
        FunctionRegistry.registerGenericUDTF("parse_url_tuple", GenericUDTFParseUrlTuple.class);
        FunctionRegistry.registerGenericUDTF("posexplode", GenericUDTFPosExplode.class);
        FunctionRegistry.registerGenericUDTF("stack", GenericUDTFStack.class);
        FunctionRegistry.registerGenericUDF(LEAD_FUNC_NAME, GenericUDFLead.class);
        FunctionRegistry.registerGenericUDF(LAG_FUNC_NAME, GenericUDFLag.class);
        FunctionRegistry.registerWindowFunction("row_number", new GenericUDAFRowNumber());
        FunctionRegistry.registerWindowFunction("rank", new GenericUDAFRank());
        FunctionRegistry.registerWindowFunction("dense_rank", new GenericUDAFDenseRank());
        FunctionRegistry.registerWindowFunction("percent_rank", new GenericUDAFPercentRank());
        FunctionRegistry.registerWindowFunction("cume_dist", new GenericUDAFCumeDist());
        FunctionRegistry.registerWindowFunction("ntile", new GenericUDAFNTile());
        FunctionRegistry.registerWindowFunction("first_value", new GenericUDAFFirstValue());
        FunctionRegistry.registerWindowFunction(LAST_VALUE_FUNC_NAME, new GenericUDAFLastValue());
        FunctionRegistry.registerWindowFunction(LEAD_FUNC_NAME, new GenericUDAFLead(), false);
        FunctionRegistry.registerWindowFunction(LAG_FUNC_NAME, new GenericUDAFLag(), false);
        FunctionRegistry.registerTableFunction(NOOP_TABLE_FUNCTION, Noop.NoopResolver.class);
        FunctionRegistry.registerTableFunction(NOOP_MAP_TABLE_FUNCTION, NoopWithMap.NoopWithMapResolver.class);
        FunctionRegistry.registerTableFunction(NOOP_STREAMING_TABLE_FUNCTION, NoopStreaming.NoopStreamingResolver.class);
        FunctionRegistry.registerTableFunction(NOOP_STREAMING_MAP_TABLE_FUNCTION, NoopWithMapStreaming.NoopWithMapStreamingResolver.class);
        FunctionRegistry.registerTableFunction(WINDOWING_TABLE_FUNCTION, WindowingTableFunction.WindowingTableFunctionResolver.class);
        FunctionRegistry.registerTableFunction("matchpath", MatchPath.MatchPathResolver.class);
        numericTypes = new EnumMap(PrimitiveObjectInspector.PrimitiveCategory.class);
        numericTypeList = new ArrayList<PrimitiveObjectInspector.PrimitiveCategory>();
        FunctionRegistry.registerNumericType(PrimitiveObjectInspector.PrimitiveCategory.BYTE, 1);
        FunctionRegistry.registerNumericType(PrimitiveObjectInspector.PrimitiveCategory.SHORT, 2);
        FunctionRegistry.registerNumericType(PrimitiveObjectInspector.PrimitiveCategory.INT, 3);
        FunctionRegistry.registerNumericType(PrimitiveObjectInspector.PrimitiveCategory.LONG, 4);
        FunctionRegistry.registerNumericType(PrimitiveObjectInspector.PrimitiveCategory.FLOAT, 5);
        FunctionRegistry.registerNumericType(PrimitiveObjectInspector.PrimitiveCategory.DOUBLE, 6);
        FunctionRegistry.registerNumericType(PrimitiveObjectInspector.PrimitiveCategory.DECIMAL, 7);
        FunctionRegistry.registerNumericType(PrimitiveObjectInspector.PrimitiveCategory.STRING, 8);
    }
}

