/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.serde;

import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.AccumuloDefaultIndexScanner;
import org.apache.hadoop.hive.accumulo.AccumuloIndexScanner;
import org.apache.hadoop.hive.accumulo.AccumuloIndexScannerException;

public class AccumuloIndexParameters {
    public static final int DEFAULT_MAX_ROWIDS = 20000;
    public static final String INDEX_SCANNER = "accumulo.index.scanner";
    public static final String MAX_INDEX_ROWS = "accumulo.index.rows.max";
    public static final String INDEXED_COLUMNS = "accumulo.indexed.columns";
    public static final String INDEXTABLE_NAME = "accumulo.indextable.name";
    private static final Set<String> EMPTY_SET = new HashSet<String>();
    private Configuration conf;

    public AccumuloIndexParameters(Configuration conf) {
        this.conf = conf;
    }

    public String getIndexTable() {
        return this.conf.get(INDEXTABLE_NAME);
    }

    public int getMaxIndexRows() {
        return this.conf.getInt(MAX_INDEX_ROWS, 20000);
    }

    public final Set<String> getIndexColumns() {
        String colmap = this.conf.get(INDEXED_COLUMNS);
        if (colmap != null) {
            HashSet<String> cols = new HashSet<String>();
            for (String col : colmap.split(",")) {
                cols.add(col.trim());
            }
            return cols;
        }
        return EMPTY_SET;
    }

    public final Authorizations getTableAuths() {
        String auths = this.conf.get("accumulo.authorizations");
        if (auths != null && !auths.isEmpty()) {
            return new Authorizations(auths.trim().getBytes(StandardCharsets.UTF_8));
        }
        return new Authorizations();
    }

    public Configuration getConf() {
        return this.conf;
    }

    public final AccumuloIndexScanner createScanner() throws AccumuloIndexScannerException {
        AccumuloIndexScanner handler;
        String classname = this.conf.get(INDEX_SCANNER);
        if (classname != null) {
            try {
                handler = (AccumuloIndexScanner)Class.forName(classname).newInstance();
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new AccumuloIndexScannerException("Cannot use index scanner class: " + classname, e);
            }
        } else {
            handler = new AccumuloDefaultIndexScanner();
        }
        if (handler != null) {
            handler.init(this.conf);
        }
        return handler;
    }
}

