/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.archetypes.exemplars.shaded_client;

import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;

public final class HelloHBase {
    static final String MY_NAMESPACE_NAME = "myTestNamespace";
    static final TableName MY_TABLE_NAME = TableName.valueOf((String)"myTestTable");
    static final byte[] MY_COLUMN_FAMILY_NAME = Bytes.toBytes((String)"cf");
    static final byte[] MY_FIRST_COLUMN_QUALIFIER = Bytes.toBytes((String)"myFirstColumn");
    static final byte[] MY_SECOND_COLUMN_QUALIFIER = Bytes.toBytes((String)"mySecondColumn");
    static final byte[] MY_ROW_ID = Bytes.toBytes((String)"rowId01");

    private HelloHBase() {
    }

    public static void main(String[] args) throws IOException {
        boolean deleteAllAtEOJ = true;
        try (Connection connection = ConnectionFactory.createConnection();
             Admin admin = connection.getAdmin();){
            admin.getClusterStatus();
            System.out.println("\n*** Hello HBase! -- Connection has been established via ZooKeeper!!\n");
            HelloHBase.createNamespaceAndTable(admin);
            System.out.println("Getting a Table object for [" + MY_TABLE_NAME + "] with which to perform CRUD operations in HBase.");
            try (Table table = connection.getTable(MY_TABLE_NAME);){
                HelloHBase.putRowToTable(table);
                HelloHBase.getAndPrintRowContents(table);
                HelloHBase.deleteRow(table);
            }
            HelloHBase.deleteNamespaceAndTable(admin);
        }
    }

    static void createNamespaceAndTable(Admin admin) throws IOException {
        if (!HelloHBase.namespaceExists(admin, MY_NAMESPACE_NAME)) {
            System.out.println("Creating Namespace [myTestNamespace].");
            admin.createNamespace(NamespaceDescriptor.create((String)MY_NAMESPACE_NAME).build());
        }
        if (!admin.tableExists(MY_TABLE_NAME)) {
            System.out.println("Creating Table [" + MY_TABLE_NAME.getNameAsString() + "], with one Column Family [" + Bytes.toString((byte[])MY_COLUMN_FAMILY_NAME) + "].");
            admin.createTable((TableDescriptor)new HTableDescriptor(MY_TABLE_NAME).addFamily(new HColumnDescriptor(MY_COLUMN_FAMILY_NAME)));
        }
    }

    static void putRowToTable(Table table) throws IOException {
        table.put(new Put(MY_ROW_ID).addColumn(MY_COLUMN_FAMILY_NAME, MY_FIRST_COLUMN_QUALIFIER, Bytes.toBytes((String)"Hello")).addColumn(MY_COLUMN_FAMILY_NAME, MY_SECOND_COLUMN_QUALIFIER, Bytes.toBytes((String)"World!")));
        System.out.println("Row [" + Bytes.toString((byte[])MY_ROW_ID) + "] was put into Table [" + table.getName().getNameAsString() + "] in HBase;\n  the row's two columns (created 'on the fly') are: [" + Bytes.toString((byte[])MY_COLUMN_FAMILY_NAME) + ":" + Bytes.toString((byte[])MY_FIRST_COLUMN_QUALIFIER) + "] and [" + Bytes.toString((byte[])MY_COLUMN_FAMILY_NAME) + ":" + Bytes.toString((byte[])MY_SECOND_COLUMN_QUALIFIER) + "]");
    }

    static void getAndPrintRowContents(Table table) throws IOException {
        Result row = table.get(new Get(MY_ROW_ID));
        System.out.println("Row [" + Bytes.toString((byte[])row.getRow()) + "] was retrieved from Table [" + table.getName().getNameAsString() + "] in HBase, with the following content:");
        for (Map.Entry colFamilyEntry : row.getNoVersionMap().entrySet()) {
            String columnFamilyName = Bytes.toString((byte[])((byte[])colFamilyEntry.getKey()));
            System.out.println("  Columns in Column Family [" + columnFamilyName + "]:");
            for (Map.Entry columnNameAndValueMap : ((NavigableMap)colFamilyEntry.getValue()).entrySet()) {
                System.out.println("    Value of Column [" + columnFamilyName + ":" + Bytes.toString((byte[])((byte[])columnNameAndValueMap.getKey())) + "] == " + Bytes.toString((byte[])((byte[])columnNameAndValueMap.getValue())));
            }
        }
    }

    static boolean namespaceExists(Admin admin, String namespaceName) throws IOException {
        try {
            admin.getNamespaceDescriptor(namespaceName);
        }
        catch (NamespaceNotFoundException e) {
            return false;
        }
        return true;
    }

    static void deleteRow(Table table) throws IOException {
        System.out.println("Deleting row [" + Bytes.toString((byte[])MY_ROW_ID) + "] from Table [" + table.getName().getNameAsString() + "].");
        table.delete(new Delete(MY_ROW_ID));
    }

    static void deleteNamespaceAndTable(Admin admin) throws IOException {
        if (admin.tableExists(MY_TABLE_NAME)) {
            System.out.println("Disabling/deleting Table [" + MY_TABLE_NAME.getNameAsString() + "].");
            admin.disableTable(MY_TABLE_NAME);
            admin.deleteTable(MY_TABLE_NAME);
        }
        if (HelloHBase.namespaceExists(admin, MY_NAMESPACE_NAME)) {
            System.out.println("Deleting Namespace [myTestNamespace].");
            admin.deleteNamespace(MY_NAMESPACE_NAME);
        }
    }
}

