/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.master.balancer.BalanceAction;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.CandidateGenerator;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class LoadCandidateGenerator
extends CandidateGenerator {
    LoadCandidateGenerator() {
    }

    @Override
    BalanceAction generate(BalancerClusterState cluster) {
        cluster.sortServersByRegionCount();
        int thisServer = this.pickMostLoadedServer(cluster, -1);
        int otherServer = this.pickLeastLoadedServer(cluster, thisServer);
        return this.pickRandomRegions(cluster, thisServer, otherServer);
    }

    private int pickLeastLoadedServer(BalancerClusterState cluster, int thisServer) {
        Integer[] servers = cluster.serverIndicesSortedByRegionCount;
        int selectedIndex = -1;
        double currentLargestRandom = -1.0;
        for (int i = 0; i < servers.length; ++i) {
            if (servers[i] == null || servers[i] == thisServer) continue;
            if (selectedIndex != -1 && cluster.getNumRegionsComparator().compare(servers[i], servers[selectedIndex]) != 0) break;
            double currentRandom = ThreadLocalRandom.current().nextDouble();
            if (!(currentRandom > currentLargestRandom)) continue;
            selectedIndex = i;
            currentLargestRandom = currentRandom;
        }
        return selectedIndex == -1 ? -1 : servers[selectedIndex];
    }

    private int pickMostLoadedServer(BalancerClusterState cluster, int thisServer) {
        Integer[] servers = cluster.serverIndicesSortedByRegionCount;
        int selectedIndex = -1;
        double currentLargestRandom = -1.0;
        for (int i = servers.length - 1; i >= 0; --i) {
            if (servers[i] == null || servers[i] == thisServer) continue;
            if (selectedIndex != -1 && cluster.getNumRegionsComparator().compare(servers[i], servers[selectedIndex]) != 0) break;
            double currentRandom = ThreadLocalRandom.current().nextDouble();
            if (!(currentRandom > currentLargestRandom)) continue;
            selectedIndex = i;
            currentLargestRandom = currentRandom;
        }
        return selectedIndex == -1 ? -1 : servers[selectedIndex];
    }
}

