/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.master.balancer.BalanceAction;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.CandidateGenerator;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class LocalityBasedCandidateGenerator
extends CandidateGenerator {
    LocalityBasedCandidateGenerator() {
    }

    @Override
    BalanceAction generate(BalancerClusterState cluster) {
        if (cluster.numRegions > 0) {
            int startIndex = ThreadLocalRandom.current().nextInt(cluster.numRegions);
            for (int i = 0; i < cluster.numRegions; ++i) {
                Optional<BalanceAction> potential;
                int region = (startIndex + i) % cluster.numRegions;
                int currentServer = cluster.regionIndexToServerIndex[region];
                if (currentServer == cluster.getOrComputeRegionsToMostLocalEntities(BalancerClusterState.LocalityType.SERVER)[region] || !(potential = this.tryMoveOrSwap(cluster, currentServer, region, cluster.getOrComputeRegionsToMostLocalEntities(BalancerClusterState.LocalityType.SERVER)[region])).isPresent()) continue;
                return potential.get();
            }
        }
        return BalanceAction.NULL_ACTION;
    }

    private Optional<BalanceAction> tryMoveOrSwap(BalancerClusterState cluster, int fromServer, int fromRegion, int toServer) {
        if (cluster.serverHasTooFewRegions(toServer)) {
            return Optional.of(this.getAction(fromServer, fromRegion, toServer, -1));
        }
        double fromRegionLocalityDelta = this.getWeightedLocality(cluster, fromRegion, toServer) - this.getWeightedLocality(cluster, fromRegion, fromServer);
        int toServertotalRegions = cluster.regionsPerServer[toServer].length;
        if (toServertotalRegions > 0) {
            int startIndex = ThreadLocalRandom.current().nextInt(toServertotalRegions);
            for (int i = 0; i < toServertotalRegions; ++i) {
                int toRegionIndex = (startIndex + i) % toServertotalRegions;
                int toRegion = cluster.regionsPerServer[toServer][toRegionIndex];
                double toRegionLocalityDelta = this.getWeightedLocality(cluster, toRegion, fromServer) - this.getWeightedLocality(cluster, toRegion, toServer);
                if (!(fromRegionLocalityDelta + toRegionLocalityDelta >= 0.0)) continue;
                return Optional.of(this.getAction(fromServer, fromRegion, toServer, toRegion));
            }
        }
        return Optional.empty();
    }

    private double getWeightedLocality(BalancerClusterState cluster, int region, int server) {
        return cluster.getOrComputeWeightedLocality(region, server, BalancerClusterState.LocalityType.SERVER);
    }
}

