/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.coordination.SplitLogWorkerCoordination;
import org.apache.hadoop.hbase.master.SplitLogManager;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.LastSequenceId;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.RecoverLeaseFSUtils;
import org.apache.hadoop.hbase.wal.BoundedEntryBuffers;
import org.apache.hadoop.hbase.wal.BoundedRecoveredEditsOutputSink;
import org.apache.hadoop.hbase.wal.BoundedRecoveredHFilesOutputSink;
import org.apache.hadoop.hbase.wal.EntryBuffers;
import org.apache.hadoop.hbase.wal.OutputSink;
import org.apache.hadoop.hbase.wal.RecoveredEditsOutputSink;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.wal.WALSplitUtil;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class WALSplitter {
    private static final Logger LOG = LoggerFactory.getLogger(WALSplitter.class);
    public static final boolean SPLIT_SKIP_ERRORS_DEFAULT = false;
    protected final Path walDir;
    protected final FileSystem walFS;
    protected final Configuration conf;
    final Path rootDir;
    final FileSystem rootFS;
    final RegionServerServices rsServices;
    OutputSink outputSink;
    private EntryBuffers entryBuffers;
    private SplitLogWorkerCoordination splitLogWorkerCoordination;
    private final WALFactory walFactory;
    private MonitoredTask status;
    protected final LastSequenceId sequenceIdChecker;
    protected Map<String, Long> lastFlushedSequenceIds = new ConcurrentHashMap<String, Long>();
    protected Map<String, Map<byte[], Long>> regionMaxSeqIdInStores = new ConcurrentHashMap<String, Map<byte[], Long>>();
    private FileStatus fileBeingSplit;
    private final String tmpDirName;
    public static final String WAL_SPLIT_TO_HFILE = "hbase.wal.split.to.hfile";
    public static final boolean DEFAULT_WAL_SPLIT_TO_HFILE = false;
    public static final String SPLIT_WRITER_CREATION_BOUNDED = "hbase.split.writer.creation.bounded";
    public static final String SPLIT_WAL_BUFFER_SIZE = "hbase.regionserver.hlog.splitlog.buffersize";
    public static final String SPLIT_WAL_WRITER_THREADS = "hbase.regionserver.hlog.splitlog.writer.threads";

    @VisibleForTesting
    WALSplitter(WALFactory factory, Configuration conf, Path walDir, FileSystem walFS, Path rootDir, FileSystem rootFS, LastSequenceId idChecker, SplitLogWorkerCoordination splitLogWorkerCoordination, RegionServerServices rsServices) {
        this.conf = HBaseConfiguration.create((Configuration)conf);
        String codecClassName = conf.get("hbase.regionserver.wal.codec", WALCellCodec.class.getName());
        this.conf.set("hbase.client.rpc.codec", codecClassName);
        this.walDir = walDir;
        this.walFS = walFS;
        this.rootDir = rootDir;
        this.rootFS = rootFS;
        this.sequenceIdChecker = idChecker;
        this.splitLogWorkerCoordination = splitLogWorkerCoordination;
        this.rsServices = rsServices;
        this.walFactory = factory;
        PipelineController controller = new PipelineController();
        this.tmpDirName = conf.get("hbase.fs.tmp.dir", HConstants.DEFAULT_TEMPORARY_HDFS_DIRECTORY);
        boolean splitWriterCreationBounded = conf.getBoolean(SPLIT_WRITER_CREATION_BOUNDED, false);
        boolean splitToHFile = conf.getBoolean(WAL_SPLIT_TO_HFILE, false);
        long bufferSize = this.conf.getLong(SPLIT_WAL_BUFFER_SIZE, 0x8000000L);
        int numWriterThreads = this.conf.getInt(SPLIT_WAL_WRITER_THREADS, 3);
        if (splitToHFile) {
            this.entryBuffers = new BoundedEntryBuffers(controller, bufferSize);
            this.outputSink = new BoundedRecoveredHFilesOutputSink(this, controller, this.entryBuffers, numWriterThreads);
        } else if (splitWriterCreationBounded) {
            this.entryBuffers = new BoundedEntryBuffers(controller, bufferSize);
            this.outputSink = new BoundedRecoveredEditsOutputSink(this, controller, this.entryBuffers, numWriterThreads);
        } else {
            this.entryBuffers = new EntryBuffers(controller, bufferSize);
            this.outputSink = new RecoveredEditsOutputSink(this, controller, this.entryBuffers, numWriterThreads);
        }
    }

    WALFactory getWalFactory() {
        return this.walFactory;
    }

    FileStatus getFileBeingSplit() {
        return this.fileBeingSplit;
    }

    String getTmpDirName() {
        return this.tmpDirName;
    }

    Map<String, Map<byte[], Long>> getRegionMaxSeqIdInStores() {
        return this.regionMaxSeqIdInStores;
    }

    public static boolean splitLogFile(Path walDir, FileStatus logfile, FileSystem walFS, Configuration conf, CancelableProgressable reporter, LastSequenceId idChecker, SplitLogWorkerCoordination splitLogWorkerCoordination, WALFactory factory, RegionServerServices rsServices) throws IOException {
        Path rootDir = CommonFSUtils.getRootDir((Configuration)conf);
        FileSystem rootFS = rootDir.getFileSystem(conf);
        WALSplitter s = new WALSplitter(factory, conf, walDir, walFS, rootDir, rootFS, idChecker, splitLogWorkerCoordination, rsServices);
        return s.splitLogFile(logfile, reporter);
    }

    @VisibleForTesting
    public static List<Path> split(Path walDir, Path logDir, Path oldLogDir, FileSystem walFS, Configuration conf, WALFactory factory) throws IOException {
        Path rootDir = CommonFSUtils.getRootDir((Configuration)conf);
        FileSystem rootFS = rootDir.getFileSystem(conf);
        Object[] logfiles = SplitLogManager.getFileList(conf, Collections.singletonList(logDir), null);
        ArrayList<Path> splits = new ArrayList<Path>();
        if (ArrayUtils.isNotEmpty((Object[])logfiles)) {
            Object[] objectArray = logfiles;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                WALSplitter s = new WALSplitter(factory, conf, walDir, walFS, rootDir, rootFS, null, null, null);
                Object logfile = objectArray[i];
                if (!s.splitLogFile((FileStatus)logfile, null)) continue;
                WALSplitUtil.finishSplitLogFile(walDir, oldLogDir, logfile.getPath(), conf);
                if (s.outputSink.splits == null) continue;
                splits.addAll(s.outputSink.splits);
            }
        }
        if (!walFS.delete(logDir, true)) {
            throw new IOException("Unable to delete src dir: " + logDir);
        }
        return splits;
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    boolean splitLogFile(FileStatus logfile, CancelableProgressable reporter) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 40[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isRegionDirPresentUnderRoot(TableName tableName, String regionName) throws IOException {
        Path regionDirPath = CommonFSUtils.getRegionDir((Path)this.rootDir, (TableName)tableName, (String)regionName);
        return this.rootFS.exists(regionDirPath);
    }

    private WAL.Reader getReader(FileStatus file, boolean skipErrors, CancelableProgressable reporter) throws IOException, CorruptedLogFileException {
        WAL.Reader in;
        Path path = file.getPath();
        long length = file.getLen();
        if (length <= 0L) {
            LOG.warn("File {} might be still open, length is 0", (Object)path);
        }
        try {
            RecoverLeaseFSUtils.recoverFileLease((FileSystem)this.walFS, (Path)path, (Configuration)this.conf, (CancelableProgressable)reporter);
            try {
                in = this.getReader(path, reporter);
            }
            catch (EOFException e) {
                if (length <= 0L) {
                    LOG.warn("Could not open {} for reading. File is empty", (Object)path, (Object)e);
                }
                return null;
            }
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                LOG.warn("File {} does not exist anymore", (Object)path, (Object)e);
                return null;
            }
            if (!skipErrors || e instanceof InterruptedIOException) {
                throw e;
            }
            throw new CorruptedLogFileException("skipErrors=true Could not open wal " + path + " ignoring", e);
        }
        return in;
    }

    private WAL.Entry getNextLogLine(WAL.Reader in, Path path, boolean skipErrors) throws CorruptedLogFileException, IOException {
        try {
            return in.next();
        }
        catch (EOFException eof) {
            LOG.info("EOF from wal {}. Continuing.", (Object)path);
            return null;
        }
        catch (IOException e) {
            if (e.getCause() != null && (e.getCause() instanceof ParseException || e.getCause() instanceof ChecksumException)) {
                LOG.warn("Parse exception from wal {}. Continuing", (Object)path, (Object)e);
                return null;
            }
            if (!skipErrors) {
                throw e;
            }
            throw new CorruptedLogFileException("skipErrors=true Ignoring exception while parsing wal " + path + ". Marking as corrupted", e);
        }
    }

    protected WALProvider.Writer createWriter(Path logfile) throws IOException {
        return this.walFactory.createRecoveredEditsWriter(this.walFS, logfile);
    }

    protected WAL.Reader getReader(Path curLogFile, CancelableProgressable reporter) throws IOException {
        return this.walFactory.createReader(this.walFS, curLogFile, reporter);
    }

    private int getNumOpenWriters() {
        int result = 0;
        if (this.outputSink != null) {
            result += this.outputSink.getNumOpenWriters();
        }
        return result;
    }

    static class CorruptedLogFileException
    extends Exception {
        private static final long serialVersionUID = 1L;

        CorruptedLogFileException(String s) {
            super(s);
        }

        CorruptedLogFileException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class PipelineController {
        AtomicReference<Throwable> thrown = new AtomicReference();
        final Object dataAvailable = new Object();

        void writerThreadError(Throwable t) {
            this.thrown.compareAndSet(null, t);
        }

        void checkForErrors() throws IOException {
            Throwable thrown = this.thrown.get();
            if (thrown == null) {
                return;
            }
            this.thrown.set(null);
            if (thrown instanceof IOException) {
                throw new IOException(thrown);
            }
            throw new RuntimeException(thrown);
        }
    }
}

