/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.slowlog;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.slowlog.RpcLogDetails;
import org.apache.hadoop.hbase.regionserver.slowlog.SlowLogRecorder;
import org.apache.hadoop.hbase.regionserver.slowlog.TestSlowLogRecorder;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.slowlog.SlowLogTableAccessor;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.Uninterruptibles;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSlowLogAccessor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSlowLogAccessor.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSlowLogRecorder.class);
    private static final HBaseTestingUtility HBASE_TESTING_UTILITY = new HBaseTestingUtility();
    private SlowLogRecorder slowLogRecorder;

    @BeforeClass
    public static void setup() throws Exception {
        try {
            HBASE_TESTING_UTILITY.shutdownMiniHBaseCluster();
        }
        catch (IOException e) {
            LOG.debug("No worries.");
        }
        Configuration conf = HBASE_TESTING_UTILITY.getConfiguration();
        conf.setBoolean("hbase.regionserver.slowlog.buffer.enabled", true);
        conf.setBoolean("hbase.regionserver.slowlog.systable.enabled", true);
        conf.setInt("hbase.slowlog.systable.chore.duration", 900);
        conf.setInt("hbase.regionserver.slowlog.ringbuffer.size", 50000);
        HBASE_TESTING_UTILITY.startMiniCluster();
    }

    @AfterClass
    public static void teardown() throws Exception {
        HBASE_TESTING_UTILITY.shutdownMiniHBaseCluster();
    }

    @Before
    public void setUp() throws Exception {
        HRegionServer hRegionServer = HBASE_TESTING_UTILITY.getMiniHBaseCluster().getRegionServer(0);
        Field slowLogRecorder = HRegionServer.class.getDeclaredField("slowLogRecorder");
        slowLogRecorder.setAccessible(true);
        this.slowLogRecorder = (SlowLogRecorder)slowLogRecorder.get(hRegionServer);
    }

    @Test
    public void testSlowLogRecords() throws Exception {
        RpcLogDetails rpcLogDetails;
        int i;
        AdminProtos.SlowLogResponseRequest request = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(15).build();
        this.slowLogRecorder.clearSlowLogPayloads();
        Assert.assertEquals((long)this.slowLogRecorder.getSlowLogPayloads(request).size(), (long)0L);
        Connection connection = this.waitForSlowLogTableCreation();
        for (i = 0; i < 5; ++i) {
            rpcLogDetails = TestSlowLogRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
            this.slowLogRecorder.addSlowLogPayload(rpcLogDetails);
        }
        while (i < 7) {
            rpcLogDetails = TestSlowLogRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
            this.slowLogRecorder.addSlowLogPayload(rpcLogDetails);
            ++i;
        }
        while (i < 10) {
            rpcLogDetails = TestSlowLogRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
            this.slowLogRecorder.addSlowLogPayload(rpcLogDetails);
            ++i;
        }
        while (i < 14) {
            rpcLogDetails = TestSlowLogRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
            this.slowLogRecorder.addSlowLogPayload(rpcLogDetails);
            ++i;
        }
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> this.slowLogRecorder.getSlowLogPayloads(request).size() == 14));
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> this.getTableCount(connection) == 14));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getTableCount(Connection connection) {
        try (Table table = connection.getTable(SlowLogTableAccessor.SLOW_LOG_TABLE_NAME);){
            ResultScanner resultScanner = table.getScanner(new Scan().setReadType(Scan.ReadType.STREAM));
            int count = 0;
            for (Result result : resultScanner) {
                ++count;
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private Connection waitForSlowLogTableCreation() {
        Connection connection = HBASE_TESTING_UTILITY.getMiniHBaseCluster().getRegionServer(0).getConnection();
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(2000L, () -> {
            try {
                return MetaTableAccessor.tableExists((Connection)connection, (TableName)SlowLogTableAccessor.SLOW_LOG_TABLE_NAME);
            }
            catch (IOException e) {
                return false;
            }
        }));
        return connection;
    }

    @Test
    public void testHigherSlowLogs() throws Exception {
        Connection connection = this.waitForSlowLogTableCreation();
        this.slowLogRecorder.clearSlowLogPayloads();
        AdminProtos.SlowLogResponseRequest request = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(500000).build();
        Assert.assertEquals((long)this.slowLogRecorder.getSlowLogPayloads(request).size(), (long)0L);
        for (int j = 0; j < 100; ++j) {
            CompletableFuture.runAsync(() -> {
                for (int i = 0; i < 350; ++i) {
                    if (i == 300) {
                        Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                    }
                    RpcLogDetails rpcLogDetails = TestSlowLogRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
                    this.slowLogRecorder.addSlowLogPayload(rpcLogDetails);
                }
            });
        }
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(7000L, () -> {
            int count = this.slowLogRecorder.getSlowLogPayloads(request).size();
            LOG.debug("RingBuffer records count: {}", (Object)count);
            return count > 2000;
        }));
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(7000L, () -> {
            int count = this.getTableCount(connection);
            LOG.debug("SlowLog Table records count: {}", (Object)count);
            return count > 2000;
        }));
    }
}

