/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.util.Date;
import java.util.TimeZone;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.compactions.CurrentHourProvider;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestCurrentHourProvider {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCurrentHourProvider.class);

    @Test
    public void testWithEnvironmentEdge() {
        for (String zoneID : TimeZone.getAvailableIDs()) {
            TimeZone timezone = TimeZone.getTimeZone(zoneID);
            TimeZone.setDefault(timezone);
            long deltaFor11 = TimeZone.getDefault().getRawOffset() - 28800000;
            long timeFor11 = 1597895561000L - deltaFor11;
            EnvironmentEdgeManager.injectEdge(() -> timeFor11);
            CurrentHourProvider.tick = CurrentHourProvider.nextTick();
            int hour11 = CurrentHourProvider.getCurrentHour();
            if (TimeZone.getDefault().inDaylightTime(new Date(timeFor11))) {
                hour11 = "Antarctica/Troll".equals(zoneID) ? CurrentHourProvider.getCurrentHour() - 2 : CurrentHourProvider.getCurrentHour() - 1;
            }
            Assert.assertEquals((long)11L, (long)hour11);
            long deltaFor15 = TimeZone.getDefault().getRawOffset() - 28800000;
            long timeFor15 = 1597907081000L - deltaFor15;
            EnvironmentEdgeManager.injectEdge(() -> timeFor15);
            CurrentHourProvider.tick = CurrentHourProvider.nextTick();
            int hour15 = CurrentHourProvider.getCurrentHour();
            if (TimeZone.getDefault().inDaylightTime(new Date(timeFor15))) {
                hour15 = "Antarctica/Troll".equals(zoneID) ? CurrentHourProvider.getCurrentHour() - 2 : CurrentHourProvider.getCurrentHour() - 1;
            }
            Assert.assertEquals((long)15L, (long)hour15);
        }
    }
}

