/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StorefileRefresherChore;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.StoppableImplementation;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestStoreFileRefresherChore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStoreFileRefresherChore.class);
    private HBaseTestingUtility TEST_UTIL;
    private Path testDir;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws IOException {
        this.TEST_UTIL = new HBaseTestingUtility();
        this.testDir = this.TEST_UTIL.getDataTestDir("TestStoreFileRefresherChore");
        CommonFSUtils.setRootDir((Configuration)this.TEST_UTIL.getConfiguration(), (Path)this.testDir);
    }

    private TableDescriptor getTableDesc(TableName tableName, int regionReplication, byte[] ... families) {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionReplication(regionReplication);
        Arrays.stream(families).map(family -> ColumnFamilyDescriptorBuilder.newBuilder((byte[])family).setMaxVersions(Integer.MAX_VALUE).build()).forEachOrdered(arg_0 -> ((TableDescriptorBuilder)builder).setColumnFamily(arg_0));
        return builder.build();
    }

    private HRegion initHRegion(TableDescriptor htd, byte[] startKey, byte[] stopKey, int replicaId) throws IOException {
        Configuration conf = this.TEST_UTIL.getConfiguration();
        Path tableDir = CommonFSUtils.getTableDir((Path)this.testDir, (TableName)htd.getTableName());
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).setStartKey(startKey).setEndKey(stopKey).setRegionId(0L).setReplicaId(replicaId).build();
        FailingHRegionFileSystem fs = new FailingHRegionFileSystem(conf, tableDir.getFileSystem(conf), tableDir, info);
        Configuration walConf = new Configuration(conf);
        CommonFSUtils.setRootDir((Configuration)walConf, (Path)tableDir);
        WALFactory wals = new WALFactory(walConf, "log_" + replicaId);
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        HRegion region = new HRegion((HRegionFileSystem)fs, wals.getWAL(info), conf, htd, null);
        region.initialize();
        return region;
    }

    private void putData(Region region, int startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        for (int i = startRow; i < startRow + numRows; ++i) {
            Put put = new Put(Bytes.toBytes((String)("" + i)));
            put.setDurability(Durability.SKIP_WAL);
            for (byte[] family : families) {
                put.addColumn(family, qf, null);
            }
            region.put(put);
        }
    }

    private void verifyDataExpectFail(Region newReg, int startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        boolean threw = false;
        try {
            this.verifyData(newReg, startRow, numRows, qf, families);
        }
        catch (AssertionError e) {
            threw = true;
        }
        if (!threw) {
            Assert.fail((String)"Expected data verification to fail");
        }
    }

    private void verifyData(Region newReg, int startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        for (int i = startRow; i < startRow + numRows; ++i) {
            byte[] row = Bytes.toBytes((String)("" + i));
            Get get = new Get(row);
            for (byte[] family : families) {
                get.addColumn(family, qf);
            }
            Result result = newReg.get(get);
            Cell[] raw = result.rawCells();
            Assert.assertEquals((long)families.length, (long)result.size());
            for (int j = 0; j < families.length; ++j) {
                Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)raw[j], (byte[])row));
                Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)raw[j], (byte[])families[j]));
                Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)raw[j], (byte[])qf));
            }
        }
    }

    @Test
    public void testIsStale() throws IOException {
        int period = 0;
        byte[][] families = new byte[][]{Bytes.toBytes((String)"cf")};
        byte[] qf = Bytes.toBytes((String)"cq");
        HRegionServer regionServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        ArrayList<HRegion> regions = new ArrayList<HRegion>();
        Mockito.when((Object)regionServer.getOnlineRegionsLocalContext()).thenReturn(regions);
        Mockito.when((Object)regionServer.getConfiguration()).thenReturn((Object)this.TEST_UTIL.getConfiguration());
        TableDescriptor htd = this.getTableDesc(TableName.valueOf((String)this.name.getMethodName()), 2, families);
        HRegion primary = this.initHRegion(htd, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, 0);
        HRegion replica1 = this.initHRegion(htd, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, 1);
        regions.add(primary);
        regions.add(replica1);
        StaleStorefileRefresherChore chore = new StaleStorefileRefresherChore(period, regionServer, new StoppableImplementation());
        this.putData((Region)primary, 0, 100, qf, families);
        primary.flush(true);
        this.verifyData((Region)primary, 0, 100, qf, families);
        this.verifyDataExpectFail((Region)replica1, 0, 100, qf, families);
        chore.chore();
        this.verifyData((Region)replica1, 0, 100, qf, families);
        ((FailingHRegionFileSystem)replica1.getRegionFileSystem()).fail = true;
        this.putData((Region)primary, 100, 100, qf, families);
        primary.flush(true);
        this.verifyData((Region)primary, 0, 200, qf, families);
        chore.chore();
        this.verifyData((Region)replica1, 0, 100, qf, families);
        this.verifyDataExpectFail((Region)replica1, 100, 100, qf, families);
        chore.isStale = true;
        chore.chore();
        try {
            this.verifyData((Region)replica1, 0, 100, qf, families);
            Assert.fail((String)"should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class StaleStorefileRefresherChore
    extends StorefileRefresherChore {
        boolean isStale = false;

        public StaleStorefileRefresherChore(int period, HRegionServer regionServer, Stoppable stoppable) {
            super(period, false, regionServer, stoppable);
        }

        protected boolean isRegionStale(String encodedName, long time) {
            return this.isStale;
        }
    }

    static class FailingHRegionFileSystem
    extends HRegionFileSystem {
        boolean fail = false;

        FailingHRegionFileSystem(Configuration conf, FileSystem fs, Path tableDir, RegionInfo regionInfo) {
            super(conf, fs, tableDir, regionInfo);
        }

        public Collection<StoreFileInfo> getStoreFiles(String familyName) throws IOException {
            if (this.fail) {
                throw new IOException("simulating FS failure");
            }
            return super.getStoreFiles(familyName);
        }
    }
}

