/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MultithreadedTestUtil;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MemStoreLABImpl;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.primitives.Ints;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestMemStoreLAB {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMemStoreLAB.class);
    private static final Configuration conf = new Configuration();
    private static final byte[] rk = Bytes.toBytes((String)"r1");
    private static final byte[] cf = Bytes.toBytes((String)"f");
    private static final byte[] q = Bytes.toBytes((String)"q");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        ChunkCreator.initialize((int)1024, (boolean)false, (long)51200000L, (float)0.2f, (float)0.0f, null, (float)0.1f);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        long globalMemStoreLimit = (long)((float)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * MemorySizeUtil.getGlobalMemStoreHeapPercent((Configuration)conf, (boolean)false));
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)globalMemStoreLimit, (float)0.2f, (float)0.0f, null, (float)0.1f);
    }

    @Test
    public void testLABRandomAllocation() {
        Random rand = new Random();
        MemStoreLABImpl mslab = new MemStoreLABImpl();
        int expectedOff = 0;
        ByteBuffer lastBuffer = null;
        int lastChunkId = -1;
        for (int i = 0; i < 100000; ++i) {
            int valSize = rand.nextInt(3);
            KeyValue kv = new KeyValue(rk, cf, q, new byte[valSize]);
            int size = kv.getSerializedSize();
            ByteBufferKeyValue newKv = (ByteBufferKeyValue)mslab.copyCellInto((Cell)kv);
            if (newKv.getBuffer() != lastBuffer) {
                expectedOff = 4;
                lastBuffer = newKv.getBuffer();
                int chunkId = newKv.getBuffer().getInt(0);
                Assert.assertTrue((String)"chunkid should be different", (chunkId != lastChunkId ? 1 : 0) != 0);
                lastChunkId = chunkId;
            }
            Assert.assertEquals((long)expectedOff, (long)newKv.getOffset());
            Assert.assertTrue((String)"Allocation overruns buffer", (newKv.getOffset() + size <= newKv.getBuffer().capacity() ? 1 : 0) != 0);
            expectedOff += size;
        }
    }

    @Test
    public void testLABLargeAllocation() {
        MemStoreLABImpl mslab = new MemStoreLABImpl();
        KeyValue kv = new KeyValue(rk, cf, q, new byte[0x200000]);
        Cell newCell = mslab.copyCellInto((Cell)kv);
        Assert.assertNull((String)"2MB allocation shouldn't be satisfied by LAB.", (Object)newCell);
    }

    @Test
    public void testLABThreading() throws Exception {
        Configuration conf = new Configuration();
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(conf);
        AtomicInteger totalAllocated = new AtomicInteger();
        MemStoreLABImpl mslab = new MemStoreLABImpl();
        ArrayList allocations = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            LinkedList allocsByThisThread = Lists.newLinkedList();
            allocations.add(allocsByThisThread);
            MultithreadedTestUtil.RepeatingTestThread t = new MultithreadedTestUtil.RepeatingTestThread(ctx, (MemStoreLAB)mslab, totalAllocated, allocsByThisThread){
                private Random r;
                final /* synthetic */ MemStoreLAB val$mslab;
                final /* synthetic */ AtomicInteger val$totalAllocated;
                final /* synthetic */ List val$allocsByThisThread;
                {
                    this.val$mslab = memStoreLAB;
                    this.val$totalAllocated = atomicInteger;
                    this.val$allocsByThisThread = list;
                    super(ctx);
                    this.r = new Random();
                }

                @Override
                public void doAnAction() throws Exception {
                    int valSize = this.r.nextInt(3);
                    KeyValue kv = new KeyValue(rk, cf, q, new byte[valSize]);
                    int size = kv.getSerializedSize();
                    ByteBufferKeyValue newCell = (ByteBufferKeyValue)this.val$mslab.copyCellInto((Cell)kv);
                    this.val$totalAllocated.addAndGet(size);
                    this.val$allocsByThisThread.add(new AllocRecord(newCell.getBuffer(), newCell.getOffset(), size));
                }
            };
            ctx.addThread(t);
        }
        ctx.startThreads();
        while (totalAllocated.get() < 51200000 && ctx.shouldRun()) {
            Thread.sleep(10L);
        }
        ctx.stop();
        HashMap mapsByChunk = Maps.newHashMap();
        int sizeCounted = 0;
        for (AllocRecord rec : Iterables.concat((Iterable)allocations)) {
            sizeCounted += rec.size;
            if (rec.size == 0) continue;
            Map mapForThisByteArray = (Map)mapsByChunk.get(rec.alloc);
            if (mapForThisByteArray == null) {
                mapForThisByteArray = Maps.newTreeMap();
                mapsByChunk.put(rec.alloc, mapForThisByteArray);
            }
            AllocRecord oldVal = mapForThisByteArray.put(rec.offset, rec);
            Assert.assertNull((String)("Already had an entry " + oldVal + " for allocation " + rec), (Object)oldVal);
        }
        Assert.assertEquals((String)"Sanity check test", (long)sizeCounted, (long)totalAllocated.get());
        for (Map allocsInChunk : mapsByChunk.values()) {
            int expectedOff = 4;
            for (AllocRecord alloc : allocsInChunk.values()) {
                Assert.assertEquals((long)expectedOff, (long)alloc.offset);
                Assert.assertTrue((String)"Allocation overruns buffer", (alloc.offset + alloc.size <= alloc.alloc.capacity() ? 1 : 0) != 0);
                expectedOff += alloc.size;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLABChunkQueue() throws Exception {
        ChunkCreator oldInstance = null;
        try {
            MemStoreLABImpl mslab = new MemStoreLABImpl();
            Assert.assertTrue((boolean)mslab.getPooledChunks().isEmpty());
            oldInstance = ChunkCreator.instance;
            ChunkCreator.instance = null;
            Configuration conf = HBaseConfiguration.create();
            conf.setDouble("hbase.hregion.memstore.chunkpool.maxsize", 0.1);
            conf.setLong("hbase.hregion.memstore.mslab.chunksize", 262144L);
            long globalMemStoreLimit = (long)((float)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * MemorySizeUtil.getGlobalMemStoreHeapPercent((Configuration)conf, (boolean)false));
            ChunkCreator.initialize((int)262144, (boolean)false, (long)globalMemStoreLimit, (float)0.1f, (float)0.0f, null, (float)0.1f);
            ChunkCreator.clearDisableFlag();
            mslab = new MemStoreLABImpl(conf);
            ArrayList<Thread> threads = new ArrayList<Thread>();
            KeyValue kv = new KeyValue(Bytes.toBytes((String)"r"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"q"), new byte[262112]);
            for (int i = 0; i < 10; ++i) {
                threads.add(this.getChunkQueueTestThread(mslab, "testLABChunkQueue-" + i, (Cell)kv));
            }
            for (Thread thread : threads) {
                thread.start();
            }
            Thread.sleep(1000L);
            for (Thread thread : threads) {
                thread.interrupt();
            }
            boolean threadsRunning = true;
            boolean alive = false;
            while (threadsRunning) {
                alive = false;
                for (Thread thread : threads) {
                    if (!thread.isAlive()) continue;
                    alive = true;
                    break;
                }
                if (alive) continue;
                threadsRunning = false;
            }
            Assert.assertTrue((String)"All the chunks must have been cleared", (ChunkCreator.instance.numberOfMappedChunks() != 0 ? 1 : 0) != 0);
            int pooledChunksNum = mslab.getPooledChunks().size();
            mslab.close();
            int queueLength = mslab.getNumOfChunksReturnedToPool();
            Assert.assertTrue((String)("All chunks in chunk queue should be reclaimed or removed after mslab closed but actually: " + (pooledChunksNum - queueLength)), (pooledChunksNum - queueLength == 0 ? 1 : 0) != 0);
        }
        finally {
            ChunkCreator.instance = oldInstance;
        }
    }

    private Thread getChunkQueueTestThread(final MemStoreLABImpl mslab, String threadName, final Cell cellToCopyInto) {
        Thread thread = new Thread(){
            volatile boolean stopped = false;

            @Override
            public void run() {
                while (!this.stopped) {
                    mslab.copyCellInto(cellToCopyInto);
                }
            }

            @Override
            public void interrupt() {
                this.stopped = true;
            }
        };
        thread.setName(threadName);
        thread.setDaemon(true);
        return thread;
    }

    private static class AllocRecord
    implements Comparable<AllocRecord> {
        private final ByteBuffer alloc;
        private final int offset;
        private final int size;

        public AllocRecord(ByteBuffer alloc, int offset, int size) {
            this.alloc = alloc;
            this.offset = offset;
            this.size = size;
        }

        @Override
        public int compareTo(AllocRecord e) {
            if (this.alloc != e.alloc) {
                throw new RuntimeException("Can only compare within a particular array");
            }
            return Ints.compare((int)this.offset, (int)e.offset);
        }

        public String toString() {
            return "AllocRecord(offset=" + this.offset + ", size=" + this.size + ")";
        }
    }
}

