/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.hbase.ConcurrentTableModificationException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.PerClientRandomNonceGenerator;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.ModifyTableProcedure;
import org.apache.hadoop.hbase.master.procedure.TestTableDDLProcedureBase;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.NonceKey;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, LargeTests.class})
public class TestModifyTableProcedure
extends TestTableDDLProcedureBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestModifyTableProcedure.class);
    @Rule
    public TestName name = new TestName();
    private static final String column_Family1 = "cf1";
    private static final String column_Family2 = "cf2";
    private static final String column_Family3 = "cf3";

    @Test
    public void testModifyTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf");
        UTIL.getAdmin().disableTable(tableName);
        HTableDescriptor htd = new HTableDescriptor(UTIL.getAdmin().getTableDescriptor(tableName));
        long newMaxFileSize = htd.getMaxFileSize() * 2L;
        htd.setMaxFileSize(newMaxFileSize);
        htd.setRegionReplication(3);
        long procId1 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId1));
        HTableDescriptor currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((long)newMaxFileSize, (long)currentHtd.getMaxFileSize());
        boolean newReadOnlyOption = !htd.isReadOnly();
        long newMemStoreFlushSize = htd.getMemStoreFlushSize() * 2L;
        htd.setReadOnly(newReadOnlyOption);
        htd.setMemStoreFlushSize(newMemStoreFlushSize);
        long procId2 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId2));
        currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((Object)newReadOnlyOption, (Object)currentHtd.isReadOnly());
        Assert.assertEquals((long)newMemStoreFlushSize, (long)currentHtd.getMemStoreFlushSize());
    }

    @Test
    public void testModifyTableAddCF() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, column_Family1);
        HTableDescriptor currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((long)1L, (long)currentHtd.getFamiliesKeys().size());
        String cf2 = column_Family2;
        HTableDescriptor htd = new HTableDescriptor(UTIL.getAdmin().getTableDescriptor(tableName));
        htd.addFamily(new HColumnDescriptor(cf2));
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId));
        currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((long)2L, (long)currentHtd.getFamiliesKeys().size());
        Assert.assertTrue((boolean)currentHtd.hasFamily(Bytes.toBytes((String)cf2)));
        UTIL.getAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        String cf3 = column_Family3;
        HTableDescriptor htd2 = new HTableDescriptor(UTIL.getAdmin().getTableDescriptor(tableName));
        htd2.addFamily(new HColumnDescriptor(cf3));
        long procId2 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd2));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId2));
        currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertTrue((boolean)currentHtd.hasFamily(Bytes.toBytes((String)cf3)));
        Assert.assertEquals((long)3L, (long)currentHtd.getFamiliesKeys().size());
    }

    @Test
    public void testModifyTableDeleteCF() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String cf1 = column_Family1;
        String cf2 = column_Family2;
        String cf3 = column_Family3;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, column_Family1, column_Family2, column_Family3);
        HTableDescriptor currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((long)3L, (long)currentHtd.getFamiliesKeys().size());
        HTableDescriptor htd = new HTableDescriptor(UTIL.getAdmin().getTableDescriptor(tableName));
        htd.removeFamily(Bytes.toBytes((String)column_Family2));
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId));
        currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((long)2L, (long)currentHtd.getFamiliesKeys().size());
        Assert.assertFalse((boolean)currentHtd.hasFamily(Bytes.toBytes((String)column_Family2)));
        UTIL.getAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        HTableDescriptor htd2 = new HTableDescriptor(UTIL.getAdmin().getTableDescriptor(tableName));
        htd2.removeFamily(Bytes.toBytes((String)column_Family3));
        htd2.setConfiguration("hbase.table.sanity.checks", Boolean.FALSE.toString());
        long procId2 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd2));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId2));
        currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((long)1L, (long)currentHtd.getFamiliesKeys().size());
        Assert.assertFalse((boolean)currentHtd.hasFamily(Bytes.toBytes((String)column_Family3)));
        HTableDescriptor htd3 = new HTableDescriptor(UTIL.getAdmin().getTableDescriptor(tableName));
        htd3.removeFamily(Bytes.toBytes((String)column_Family1));
        long procId3 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd3));
        Procedure result = procExec.getResult(procId3);
        Assert.assertEquals((Object)true, (Object)result.isFailed());
        Throwable cause = ProcedureTestingUtility.getExceptionCause((Procedure)result);
        Assert.assertTrue((String)("expected DoNotRetryIOException, got " + cause), (boolean)(cause instanceof DoNotRetryIOException));
        Assert.assertEquals((long)1L, (long)currentHtd.getFamiliesKeys().size());
        Assert.assertTrue((boolean)currentHtd.hasFamily(Bytes.toBytes((String)column_Family1)));
    }

    @Test
    public void testRecoveryAndDoubleExecutionOffline() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String cf2 = column_Family2;
        String cf3 = column_Family3;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, column_Family1, column_Family3);
        UTIL.getAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        TableDescriptor oldDescriptor = UTIL.getAdmin().getDescriptor(tableName);
        TableDescriptor newDescriptor = TableDescriptorBuilder.newBuilder((TableDescriptor)oldDescriptor).setCompactionEnabled(!oldDescriptor.isCompactionEnabled()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)column_Family2)).removeColumnFamily(Bytes.toBytes((String)column_Family3)).setRegionReplication(3).build();
        long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), newDescriptor));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        TableDescriptor currentDescriptor = UTIL.getAdmin().getDescriptor(tableName);
        Assert.assertEquals((Object)newDescriptor.isCompactionEnabled(), (Object)currentDescriptor.isCompactionEnabled());
        Assert.assertEquals((long)2L, (long)newDescriptor.getColumnFamilyNames().size());
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, false, column_Family1, column_Family2);
    }

    @Test
    public void testRecoveryAndDoubleExecutionOnline() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String cf2 = column_Family2;
        String cf3 = column_Family3;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, column_Family1, column_Family3);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        HTableDescriptor htd = new HTableDescriptor(UTIL.getAdmin().getTableDescriptor(tableName));
        boolean newCompactionEnableOption = !htd.isCompactionEnabled();
        htd.setCompactionEnabled(newCompactionEnableOption);
        htd.addFamily(new HColumnDescriptor(column_Family2));
        htd.removeFamily(Bytes.toBytes((String)column_Family3));
        long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        HTableDescriptor currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((Object)newCompactionEnableOption, (Object)currentHtd.isCompactionEnabled());
        Assert.assertEquals((long)2L, (long)currentHtd.getFamiliesKeys().size());
        Assert.assertTrue((boolean)currentHtd.hasFamily(Bytes.toBytes((String)column_Family2)));
        Assert.assertFalse((boolean)currentHtd.hasFamily(Bytes.toBytes((String)column_Family3)));
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, column_Family1, column_Family2);
    }

    @Test
    public void testColumnFamilyAdditionTwiceWithNonce() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String cf2 = column_Family2;
        String cf3 = column_Family3;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, column_Family1, column_Family3);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        TableDescriptor td = UTIL.getAdmin().getDescriptor(tableName);
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setCompactionEnabled(!td.isCompactionEnabled()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)column_Family2)).build();
        PerClientRandomNonceGenerator nonceGenerator = PerClientRandomNonceGenerator.get();
        final long nonceGroup = nonceGenerator.getNonceGroup();
        final long newNonce = nonceGenerator.newNonce();
        NonceKey nonceKey = new NonceKey(nonceGroup, newNonce);
        procExec.registerNonce(nonceKey);
        final long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), newTd), nonceKey);
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, new MasterProcedureTestingUtility.StepHook(){

            @Override
            public boolean execute(int step) throws IOException {
                if (step == 3) {
                    return procId == TestTableDDLProcedureBase.UTIL.getHBaseCluster().getMaster().addColumn(tableName, ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)TestModifyTableProcedure.column_Family2)).build(), nonceGroup, newNonce);
                }
                return true;
            }
        });
        try {
            UTIL.getHBaseCluster().getMaster().addColumn(tableName, ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)column_Family2)).build(), nonceGroup, nonceGenerator.newNonce());
            Assert.fail();
        }
        catch (InvalidFamilyOperationException invalidFamilyOperationException) {
            // empty catch block
        }
        TableDescriptor currentHtd = UTIL.getAdmin().getDescriptor(tableName);
        Assert.assertEquals((Object)(!td.isCompactionEnabled() ? 1 : 0), (Object)currentHtd.isCompactionEnabled());
        Assert.assertEquals((long)3L, (long)currentHtd.getColumnFamilyCount());
        Assert.assertTrue((boolean)currentHtd.hasColumnFamily(Bytes.toBytes((String)column_Family2)));
        Assert.assertTrue((boolean)currentHtd.hasColumnFamily(Bytes.toBytes((String)column_Family3)));
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, column_Family1, column_Family2, column_Family3);
    }

    @Test
    public void testRollbackAndDoubleExecutionOnline() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String familyName = column_Family2;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, column_Family1);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        TableDescriptor td = UTIL.getAdmin().getDescriptor(tableName);
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setCompactionEnabled(!td.isCompactionEnabled()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)column_Family2)).build();
        long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), newTd));
        int lastStep = 3;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, lastStep);
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, column_Family1);
    }

    @Test
    public void testRollbackAndDoubleExecutionOffline() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String familyName = column_Family2;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, column_Family1);
        UTIL.getAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        TableDescriptor td = UTIL.getAdmin().getDescriptor(tableName);
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setCompactionEnabled(!td.isCompactionEnabled()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)column_Family2)).setRegionReplication(3).build();
        long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), newTd));
        int lastStep = 3;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, lastStep);
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, column_Family1);
    }

    @Test
    public void testConcurrentAddColumnFamily() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        UTIL.createTable(tableName, column_Family1);
        class ConcurrentAddColumnFamily
        extends Thread {
            TableName tableName = null;
            HColumnDescriptor hcd = null;
            boolean exception;

            public ConcurrentAddColumnFamily(TableName tableName, HColumnDescriptor hcd) {
                this.tableName = tableName;
                this.hcd = hcd;
                this.exception = false;
            }

            @Override
            public void run() {
                block2: {
                    try {
                        TestTableDDLProcedureBase.UTIL.getAdmin().addColumnFamily(this.tableName, (ColumnFamilyDescriptor)this.hcd);
                    }
                    catch (Exception e) {
                        if (!e.getClass().equals(ConcurrentTableModificationException.class)) break block2;
                        this.exception = true;
                    }
                }
            }
        }
        ConcurrentAddColumnFamily t1 = new ConcurrentAddColumnFamily(tableName, new HColumnDescriptor(column_Family2));
        ConcurrentAddColumnFamily t2 = new ConcurrentAddColumnFamily(tableName, new HColumnDescriptor(column_Family3));
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        int noOfColumnFamilies = UTIL.getAdmin().getDescriptor(tableName).getColumnFamilies().length;
        Assert.assertTrue((String)"Expected ConcurrentTableModificationException.", ((t1.exception || t2.exception) && noOfColumnFamilies == 2 || noOfColumnFamilies == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentDeleteColumnFamily() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(column_Family1));
        htd.addFamily(new HColumnDescriptor(column_Family2));
        htd.addFamily(new HColumnDescriptor(column_Family3));
        UTIL.getAdmin().createTable((TableDescriptor)htd);
        class ConcurrentCreateDeleteTable
        extends Thread {
            TableName tableName = null;
            String columnFamily = null;
            boolean exception;

            public ConcurrentCreateDeleteTable(TableName tableName, String columnFamily) {
                this.tableName = tableName;
                this.columnFamily = columnFamily;
                this.exception = false;
            }

            @Override
            public void run() {
                block2: {
                    try {
                        TestTableDDLProcedureBase.UTIL.getAdmin().deleteColumnFamily(this.tableName, this.columnFamily.getBytes());
                    }
                    catch (Exception e) {
                        if (!e.getClass().equals(ConcurrentTableModificationException.class)) break block2;
                        this.exception = true;
                    }
                }
            }
        }
        ConcurrentCreateDeleteTable t1 = new ConcurrentCreateDeleteTable(tableName, column_Family2);
        ConcurrentCreateDeleteTable t2 = new ConcurrentCreateDeleteTable(tableName, column_Family3);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        int noOfColumnFamilies = UTIL.getAdmin().getDescriptor(tableName).getColumnFamilies().length;
        Assert.assertTrue((String)"Expected ConcurrentTableModificationException.", ((t1.exception || t2.exception) && noOfColumnFamilies == 2 || noOfColumnFamilies == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentModifyColumnFamily() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        UTIL.createTable(tableName, column_Family1);
        ColumnFamilyDescriptor modColumnFamily1 = ColumnFamilyDescriptorBuilder.newBuilder((byte[])column_Family1.getBytes()).setMaxVersions(5).build();
        ColumnFamilyDescriptor modColumnFamily2 = ColumnFamilyDescriptorBuilder.newBuilder((byte[])column_Family1.getBytes()).setMaxVersions(6).build();
        class ConcurrentModifyColumnFamily
        extends Thread {
            TableName tableName = null;
            ColumnFamilyDescriptor hcd = null;
            boolean exception;

            public ConcurrentModifyColumnFamily(TableName tableName, ColumnFamilyDescriptor hcd) {
                this.tableName = tableName;
                this.hcd = hcd;
                this.exception = false;
            }

            @Override
            public void run() {
                block2: {
                    try {
                        TestTableDDLProcedureBase.UTIL.getAdmin().modifyColumnFamily(this.tableName, this.hcd);
                    }
                    catch (Exception e) {
                        if (!e.getClass().equals(ConcurrentTableModificationException.class)) break block2;
                        this.exception = true;
                    }
                }
            }
        }
        ConcurrentModifyColumnFamily t1 = new ConcurrentModifyColumnFamily(tableName, modColumnFamily1);
        ConcurrentModifyColumnFamily t2 = new ConcurrentModifyColumnFamily(tableName, modColumnFamily2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        int maxVersions = UTIL.getAdmin().getDescriptor(tableName).getColumnFamily(column_Family1.getBytes()).getMaxVersions();
        Assert.assertTrue((String)"Expected ConcurrentTableModificationException.", (t1.exception && maxVersions == 5 || t2.exception && maxVersions == 6 || !t1.exception || !t2.exception ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentModifyTable() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        UTIL.createTable(tableName, column_Family1);
        TableDescriptor htd = UTIL.getAdmin().getDescriptor(tableName);
        TableDescriptor modifiedDescriptor = TableDescriptorBuilder.newBuilder((TableDescriptor)htd).setCompactionEnabled(false).build();
        class ConcurrentModifyTable
        extends Thread {
            TableName tableName = null;
            TableDescriptor htd = null;
            boolean exception;

            public ConcurrentModifyTable(TableName tableName, TableDescriptor htd) {
                this.tableName = tableName;
                this.htd = htd;
                this.exception = false;
            }

            @Override
            public void run() {
                block2: {
                    try {
                        TestTableDDLProcedureBase.UTIL.getAdmin().modifyTable(this.tableName, this.htd);
                    }
                    catch (Exception e) {
                        if (!e.getClass().equals(ConcurrentTableModificationException.class)) break block2;
                        this.exception = true;
                    }
                }
            }
        }
        ConcurrentModifyTable t1 = new ConcurrentModifyTable(tableName, modifiedDescriptor);
        ConcurrentModifyTable t2 = new ConcurrentModifyTable(tableName, modifiedDescriptor);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        Assert.assertFalse((String)"Expected ConcurrentTableModificationException.", (t1.exception || t2.exception ? 1 : 0) != 0);
    }
}

