/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hadoop.hbase.io.hfile.HFilePreadReader;
import org.apache.hadoop.hbase.io.hfile.HFileWriterImpl;
import org.apache.hadoop.hbase.io.hfile.RandomKeyValueUtil;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={IOTests.class, SmallTests.class})
public class TestHFileWriterV3 {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFileWriterV3.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHFileWriterV3.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Configuration conf;
    private FileSystem fs;
    private boolean useTags;

    public TestHFileWriterV3(boolean useTags) {
        this.useTags = useTags;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return HBaseCommonTestingUtility.BOOLEAN_PARAMETERIZED;
    }

    @Before
    public void setUp() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.fs = FileSystem.get((Configuration)this.conf);
    }

    @Test
    public void testHFileFormatV3() throws IOException {
        this.testHFileFormatV3Internals(this.useTags);
    }

    private void testHFileFormatV3Internals(boolean useTags) throws IOException {
        Path hfilePath = new Path(TEST_UTIL.getDataTestDir(), "testHFileFormatV3");
        Compression.Algorithm compressAlgo = Compression.Algorithm.GZ;
        int entryCount = 10000;
        this.writeDataAndReadFromHFile(hfilePath, compressAlgo, 10000, false, useTags);
    }

    @Test
    public void testMidKeyInHFile() throws IOException {
        this.testMidKeyInHFileInternals(this.useTags);
    }

    private void testMidKeyInHFileInternals(boolean useTags) throws IOException {
        Path hfilePath = new Path(TEST_UTIL.getDataTestDir(), "testMidKeyInHFile");
        Compression.Algorithm compressAlgo = Compression.Algorithm.NONE;
        int entryCount = 50000;
        this.writeDataAndReadFromHFile(hfilePath, compressAlgo, entryCount, true, useTags);
    }

    private void writeDataAndReadFromHFile(Path hfilePath, Compression.Algorithm compressAlgo, int entryCount, boolean findMidKey, boolean useTags) throws IOException {
        long curBlockPos;
        HFileBlock block;
        HFileContext context = new HFileContextBuilder().withBlockSize(4096).withIncludesTags(useTags).withDataBlockEncoding(DataBlockEncoding.NONE).withCompression(compressAlgo).build();
        CacheConfig cacheConfig = new CacheConfig(this.conf);
        HFile.Writer writer = new HFile.WriterFactory(this.conf, cacheConfig).withPath(this.fs, hfilePath).withFileContext(context).create();
        Random rand = new Random(9713312L);
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>(entryCount);
        for (int i = 0; i < entryCount; ++i) {
            byte[] keyBytes = RandomKeyValueUtil.randomOrderedKey(rand, i);
            byte[] valueBytes = RandomKeyValueUtil.randomValue(rand);
            KeyValue keyValue = null;
            if (useTags) {
                ArrayList<ArrayBackedTag> tags = new ArrayList<ArrayBackedTag>();
                for (int j = 0; j < 1 + rand.nextInt(4); ++j) {
                    byte[] tagBytes = new byte[16];
                    rand.nextBytes(tagBytes);
                    tags.add(new ArrayBackedTag(1, tagBytes));
                }
                keyValue = new KeyValue(keyBytes, null, null, Long.MAX_VALUE, valueBytes, tags);
            } else {
                keyValue = new KeyValue(keyBytes, null, null, Long.MAX_VALUE, valueBytes);
            }
            writer.append((Cell)keyValue);
            keyValues.add(keyValue);
        }
        writer.appendMetaBlock("CAPITAL_OF_USA", (Writable)new Text("Washington, D.C."));
        writer.appendMetaBlock("CAPITAL_OF_RUSSIA", (Writable)new Text("Moscow"));
        writer.appendMetaBlock("CAPITAL_OF_FRANCE", (Writable)new Text("Paris"));
        writer.close();
        FSDataInputStream fsdis = this.fs.open(hfilePath);
        long fileSize = this.fs.getFileStatus(hfilePath).getLen();
        FixedFileTrailer trailer = FixedFileTrailer.readFromStream((FSDataInputStream)fsdis, (long)fileSize);
        Assert.assertEquals((long)3L, (long)trailer.getMajorVersion());
        Assert.assertEquals((long)entryCount, (long)trailer.getEntryCount());
        HFileContext meta = new HFileContextBuilder().withCompression(compressAlgo).withIncludesMvcc(false).withIncludesTags(useTags).withDataBlockEncoding(DataBlockEncoding.NONE).withHBaseCheckSum(true).build();
        ReaderContext readerContext = new ReaderContextBuilder().withInputStreamWrapper(new FSDataInputStreamWrapper(fsdis)).withFilePath(hfilePath).withFileSystem(this.fs).withFileSize(fileSize).build();
        HFileBlock.FSReaderImpl blockReader = new HFileBlock.FSReaderImpl(readerContext, meta, ByteBuffAllocator.HEAP);
        CellComparator comparator = trailer.createComparator();
        HFileBlockIndex.CellBasedKeyBlockIndexReader dataBlockIndexReader = new HFileBlockIndex.CellBasedKeyBlockIndexReader(comparator, trailer.getNumDataIndexLevels());
        HFileBlockIndex.ByteArrayKeyBlockIndexReader metaBlockIndexReader = new HFileBlockIndex.ByteArrayKeyBlockIndexReader(1);
        HFileBlock.BlockIterator blockIter = blockReader.blockRange(trailer.getLoadOnOpenDataOffset(), fileSize - (long)trailer.getTrailerSize());
        dataBlockIndexReader.readMultiLevelIndexRoot(blockIter.nextBlockWithBlockType(BlockType.ROOT_INDEX), trailer.getDataIndexCount());
        FSDataInputStreamWrapper wrapper = new FSDataInputStreamWrapper(this.fs, hfilePath);
        readerContext = new ReaderContextBuilder().withFilePath(hfilePath).withFileSize(fileSize).withFileSystem(wrapper.getHfs()).withInputStreamWrapper(wrapper).build();
        HFileInfo hfile = new HFileInfo(readerContext, this.conf);
        HFilePreadReader reader = new HFilePreadReader(readerContext, hfile, cacheConfig, this.conf);
        hfile.initMetaAndIndex((HFile.Reader)reader);
        if (findMidKey) {
            Cell midkey = dataBlockIndexReader.midkey((HFile.CachingBlockReader)reader);
            Assert.assertNotNull((String)"Midkey should not be null", (Object)midkey);
        }
        metaBlockIndexReader.readRootIndex((DataInput)blockIter.nextBlockWithBlockType(BlockType.ROOT_INDEX).getByteStream(), trailer.getMetaIndexCount());
        HFileInfo fileInfo = new HFileInfo();
        fileInfo.read(blockIter.nextBlockWithBlockType(BlockType.FILE_INFO).getByteStream());
        byte[] keyValueFormatVersion = fileInfo.get((Object)HFileWriterImpl.KEY_VALUE_VERSION);
        boolean includeMemstoreTS = keyValueFormatVersion != null && Bytes.toInt((byte[])keyValueFormatVersion) > 0;
        int entriesRead = 0;
        int blocksRead = 0;
        long memstoreTS = 0L;
        fsdis.seek(0L);
        for (curBlockPos = 0L; curBlockPos <= trailer.getLastDataBlockOffset(); curBlockPos += (long)block.getOnDiskSizeWithHeader()) {
            block = blockReader.readBlockData(curBlockPos, -1L, false, false, true).unpack(context, (HFileBlock.FSReader)blockReader);
            Assert.assertEquals((Object)BlockType.DATA, (Object)block.getBlockType());
            ByteBuff buf = block.getBufferWithoutHeader();
            int keyLen = -1;
            while (buf.hasRemaining()) {
                KeyValue kv;
                keyLen = buf.getInt();
                int valueLen = buf.getInt();
                byte[] key = new byte[keyLen];
                buf.get(key);
                byte[] value = new byte[valueLen];
                buf.get(value);
                byte[] tagValue = null;
                if (useTags) {
                    int tagLen = (buf.get() & 0xFF) << 8 ^ buf.get() & 0xFF;
                    tagValue = new byte[tagLen];
                    buf.get(tagValue);
                }
                if (includeMemstoreTS) {
                    ByteArrayInputStream byte_input = new ByteArrayInputStream(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
                    DataInputStream data_input = new DataInputStream(byte_input);
                    memstoreTS = WritableUtils.readVLong((DataInput)data_input);
                    buf.position(buf.position() + WritableUtils.getVIntSize((long)memstoreTS));
                }
                Assert.assertTrue((Bytes.compareTo((byte[])key, (byte[])(kv = (KeyValue)keyValues.get(entriesRead)).getKey()) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((Bytes.compareTo((byte[])value, (int)0, (int)value.length, (byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()) == 0 ? 1 : 0) != 0);
                if (useTags) {
                    Assert.assertNotNull((Object)tagValue);
                    KeyValue tkv = kv;
                    Assert.assertEquals((long)tagValue.length, (long)tkv.getTagsLength());
                    Assert.assertTrue((Bytes.compareTo((byte[])tagValue, (int)0, (int)tagValue.length, (byte[])tkv.getTagsArray(), (int)tkv.getTagsOffset(), (int)tkv.getTagsLength()) == 0 ? 1 : 0) != 0);
                }
                ++entriesRead;
            }
            ++blocksRead;
        }
        LOG.info("Finished reading: entries=" + entriesRead + ", blocksRead=" + blocksRead);
        Assert.assertEquals((long)entryCount, (long)entriesRead);
        int metaCounter = 0;
        while (fsdis.getPos() < trailer.getLoadOnOpenDataOffset()) {
            LOG.info("Current offset: " + fsdis.getPos() + ", scanning until " + trailer.getLoadOnOpenDataOffset());
            HFileBlock block2 = blockReader.readBlockData(curBlockPos, -1L, false, false, true).unpack(context, (HFileBlock.FSReader)blockReader);
            Assert.assertEquals((Object)BlockType.META, (Object)block2.getBlockType());
            Text t = new Text();
            ByteBuff buf = block2.getBufferWithoutHeader();
            if (Writables.getWritable((byte[])buf.array(), (int)buf.arrayOffset(), (int)buf.limit(), (Writable)t) == null) {
                throw new IOException("Failed to deserialize block " + this + " into a " + t.getClass().getSimpleName());
            }
            Text expectedText = metaCounter == 0 ? new Text("Paris") : (metaCounter == 1 ? new Text("Moscow") : new Text("Washington, D.C."));
            Assert.assertEquals((Object)expectedText, (Object)t);
            LOG.info("Read meta block data: " + t);
            ++metaCounter;
            curBlockPos += (long)block2.getOnDiskSizeWithHeader();
        }
        fsdis.close();
        reader.close();
    }
}

