/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestRowPrefixBloomFilter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRowPrefixBloomFilter.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRowPrefixBloomFilter.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private CacheConfig cacheConf = new CacheConfig(TEST_UTIL.getConfiguration());
    private static final ChecksumType CKTYPE = ChecksumType.CRC32C;
    private static final int CKBYTES = 512;
    private boolean localfs = false;
    private static Configuration conf;
    private static FileSystem fs;
    private static Path testDir;
    private static final int BLOCKSIZE_SMALL = 8192;
    private static final float err = 0.01f;
    private static final int prefixLength = 10;
    private static final String invalidFormatter = "%08d";
    private static final String prefixFormatter = "%010d";
    private static final String suffixFormatter = "%010d";
    private static final int prefixRowCount = 50;
    private static final int suffixRowCount = 10;
    private static final int fixedLengthExpKeys = 50;
    private static final BloomType bt;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setFloat("io.storefile.bloom.error.rate", 0.01f);
        conf.setBoolean("io.storefile.bloom.enabled", true);
        conf.setInt("RowPrefixBloomFilter.prefix_length", 10);
        boolean bl = this.localfs = conf.get("fs.defaultFS", "file:///").compareTo("file:///") == 0;
        if (fs == null) {
            fs = FileSystem.get((Configuration)conf);
        }
        try {
            if (this.localfs) {
                testDir = TEST_UTIL.getDataTestDir("TestRowPrefixBloomFilter");
                if (fs.exists(testDir)) {
                    fs.delete(testDir, true);
                }
            } else {
                testDir = FSUtils.getRootDir((Configuration)conf);
            }
        }
        catch (Exception e) {
            LOG.error(HBaseMarkers.FATAL, "error during setup", (Throwable)e);
            throw e;
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.localfs && fs.exists(testDir)) {
                fs.delete(testDir, true);
            }
        }
        catch (Exception e) {
            LOG.error(HBaseMarkers.FATAL, "error during tear down", (Throwable)e);
        }
    }

    private static StoreFileScanner getStoreFileScanner(StoreFileReader reader) {
        return reader.getStoreFileScanner(false, false, false, 0L, 0L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStoreFile(Path f, BloomType bt, int expKeys) throws IOException {
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).withChecksumType(CKTYPE).withBytesPerCheckSum(512).build();
        long now = System.currentTimeMillis();
        try (StoreFileWriter writer = new StoreFileWriter.Builder(conf, this.cacheConf, fs).withFilePath(f).withBloomType(bt).withMaxKeyCount((long)expKeys).withFileContext(meta).build();){
            int i;
            for (i = 0; i < 50; i += 2) {
                String prefixRow = String.format("%010d", i);
                for (int j = 0; j < 10; ++j) {
                    String row = this.generateRowWithSuffix(prefixRow, j);
                    KeyValue kv = new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"col"), now, Bytes.toBytes((String)"value"));
                    writer.append((Cell)kv);
                }
            }
            for (i = 50; i < 100; i += 2) {
                String row = String.format(invalidFormatter, i);
                KeyValue kv = new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"col"), now, Bytes.toBytes((String)"value"));
                writer.append((Cell)kv);
            }
        }
    }

    private String generateRowWithSuffix(String prefixRow, int suffix) {
        StringBuilder row = new StringBuilder(prefixRow);
        row.append("#");
        row.append(String.format("%010d", suffix));
        return row.toString();
    }

    @Test
    public void testRowPrefixBloomFilter() throws Exception {
        int i;
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        float expErr = 10.0f;
        int expKeys = 50;
        Path f = new Path(testDir, this.name.getMethodName());
        this.writeStoreFile(f, bt, expKeys);
        StoreFileReader reader = new StoreFileReader((FileSystem)fs, f, this.cacheConf, true, new AtomicInteger(0), true, conf);
        reader.loadFileInfo();
        reader.loadBloomfilter();
        Assert.assertEquals((Object)bt, (Object)reader.getBloomFilterType());
        Assert.assertEquals((long)10L, (long)reader.getPrefixLength());
        Assert.assertEquals((long)expKeys, (long)reader.getGeneralBloomFilter().getKeyCount());
        StoreFileScanner scanner = TestRowPrefixBloomFilter.getStoreFileScanner(reader);
        HStore store = (HStore)Mockito.mock(HStore.class);
        Mockito.when((Object)store.getColumnFamilyDescriptor()).thenReturn((Object)ColumnFamilyDescriptorBuilder.of((String)"family"));
        int falsePos = 0;
        int falseNeg = 0;
        for (i = 0; i < 50; ++i) {
            String prefixRow = String.format("%010d", i);
            for (int j = 0; j < 10; ++j) {
                boolean shouldPrefixRowExist;
                String startRow = this.generateRowWithSuffix(prefixRow, j);
                String stopRow = this.generateRowWithSuffix(prefixRow, j + 1);
                Scan scan = new Scan().withStartRow(Bytes.toBytes((String)startRow)).withStopRow(Bytes.toBytes((String)stopRow));
                boolean exists = scanner.shouldUseScanner(scan, store, Long.MIN_VALUE);
                boolean bl = shouldPrefixRowExist = i % 2 == 0;
                if (shouldPrefixRowExist) {
                    if (exists) continue;
                    ++falseNeg;
                    continue;
                }
                if (!exists) continue;
                ++falsePos;
            }
        }
        for (i = 50; i < 100; ++i) {
            boolean shouldPrefixRowExist;
            String row = String.format(invalidFormatter, i);
            Scan scan = new Scan(new Get(Bytes.toBytes((String)row)));
            boolean exists = scanner.shouldUseScanner(scan, store, Long.MIN_VALUE);
            boolean bl = shouldPrefixRowExist = i % 2 == 0;
            if (shouldPrefixRowExist) {
                if (exists) continue;
                ++falseNeg;
                continue;
            }
            if (!exists) continue;
            ++falsePos;
        }
        reader.close(true);
        fs.delete(f, true);
        Assert.assertEquals((String)("False negatives: " + falseNeg), (long)0L, (long)falseNeg);
        int maxFalsePos = (int)(2.0f * expErr);
        Assert.assertTrue((String)("Too many false positives: " + falsePos + " (err=" + 0.01f + ", expected no more than " + maxFalsePos + ")"), (falsePos <= maxFalsePos ? 1 : 0) != 0);
    }

    @Test
    public void testRowPrefixBloomFilterWithGet() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        int expKeys = 50;
        Path f = new Path(testDir, this.name.getMethodName());
        this.writeStoreFile(f, bt, expKeys);
        StoreFileReader reader = new StoreFileReader((FileSystem)fs, f, this.cacheConf, true, new AtomicInteger(0), true, conf);
        reader.loadFileInfo();
        reader.loadBloomfilter();
        StoreFileScanner scanner = TestRowPrefixBloomFilter.getStoreFileScanner(reader);
        HStore store = (HStore)Mockito.mock(HStore.class);
        Mockito.when((Object)store.getColumnFamilyDescriptor()).thenReturn((Object)ColumnFamilyDescriptorBuilder.of((String)"family"));
        String prefixRow = String.format("%010d", 48);
        String row = this.generateRowWithSuffix(prefixRow, 0);
        Scan scan = new Scan(new Get(Bytes.toBytes((String)row)));
        boolean exists = scanner.shouldUseScanner(scan, store, Long.MIN_VALUE);
        Assert.assertTrue((boolean)exists);
        prefixRow = String.format("%010d", 49);
        row = this.generateRowWithSuffix(prefixRow, 0);
        scan = new Scan(new Get(Bytes.toBytes((String)row)));
        exists = scanner.shouldUseScanner(scan, store, Long.MIN_VALUE);
        Assert.assertFalse((boolean)exists);
        row = String.format(invalidFormatter, 52);
        scan = new Scan(new Get(Bytes.toBytes((String)row)));
        exists = scanner.shouldUseScanner(scan, store, Long.MIN_VALUE);
        Assert.assertTrue((boolean)exists);
        row = String.format(invalidFormatter, 51);
        scan = new Scan(new Get(Bytes.toBytes((String)row)));
        exists = scanner.shouldUseScanner(scan, store, Long.MIN_VALUE);
        Assert.assertFalse((boolean)exists);
        reader.close(true);
        fs.delete(f, true);
    }

    @Test
    public void testRowPrefixBloomFilterWithScan() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        int expKeys = 50;
        Path f = new Path(testDir, this.name.getMethodName());
        this.writeStoreFile(f, bt, expKeys);
        StoreFileReader reader = new StoreFileReader((FileSystem)fs, f, this.cacheConf, true, new AtomicInteger(0), true, conf);
        reader.loadFileInfo();
        reader.loadBloomfilter();
        StoreFileScanner scanner = TestRowPrefixBloomFilter.getStoreFileScanner(reader);
        HStore store = (HStore)Mockito.mock(HStore.class);
        Mockito.when((Object)store.getColumnFamilyDescriptor()).thenReturn((Object)ColumnFamilyDescriptorBuilder.of((String)"family"));
        String prefixRow = String.format("%010d", 48);
        String startRow = this.generateRowWithSuffix(prefixRow, 0);
        String stopRow = this.generateRowWithSuffix(prefixRow, 1);
        Scan scan = new Scan().withStartRow(Bytes.toBytes((String)startRow)).withStopRow(Bytes.toBytes((String)stopRow));
        boolean exists = scanner.shouldUseScanner(scan, store, Long.MIN_VALUE);
        Assert.assertTrue((boolean)exists);
        prefixRow = String.format("%010d", 49);
        startRow = this.generateRowWithSuffix(prefixRow, 0);
        stopRow = this.generateRowWithSuffix(prefixRow, 1);
        scan = new Scan().withStartRow(Bytes.toBytes((String)startRow)).withStopRow(Bytes.toBytes((String)stopRow));
        exists = scanner.shouldUseScanner(scan, store, Long.MIN_VALUE);
        Assert.assertFalse((boolean)exists);
        prefixRow = String.format("%010d", 48);
        startRow = this.generateRowWithSuffix(prefixRow, 0);
        scan = new Scan().withStartRow(Bytes.toBytes((String)startRow));
        exists = scanner.shouldUseScanner(scan, store, Long.MIN_VALUE);
        Assert.assertTrue((boolean)exists);
        String prefixStartRow = String.format("%010d", 48);
        String prefixStopRow = String.format("%010d", 49);
        startRow = this.generateRowWithSuffix(prefixStartRow, 0);
        stopRow = this.generateRowWithSuffix(prefixStopRow, 0);
        scan = new Scan().withStartRow(Bytes.toBytes((String)startRow)).withStopRow(Bytes.toBytes((String)stopRow));
        exists = scanner.shouldUseScanner(scan, store, Long.MIN_VALUE);
        Assert.assertTrue((boolean)exists);
        reader.close(true);
        fs.delete(f, true);
    }

    static {
        bt = BloomType.ROWPREFIX_FIXED_LENGTH;
    }
}

